@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin

import com.pulumi.azurenative.appplatform.ServiceArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.inputs.ClusterResourcePropertiesArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.ClusterResourcePropertiesArgsBuilder
import com.pulumi.azurenative.appplatform.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.appplatform.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Service resource
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2020-07-01.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01, 2024-01-01-preview.
 * ## Example Usage
 * ### Services_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.AppPlatform.Service("service", new()
 *     {
 *         Location = "eastus",
 *         Properties = null,
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         Sku = new AzureNative.AppPlatform.Inputs.SkuArgs
 *         {
 *             Name = "S0",
 *             Tier = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewService(ctx, "service", &appplatform.ServiceArgs{
 * 			Location:          pulumi.String("eastus"),
 * 			Properties:        nil,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 			Sku: &appplatform.SkuArgs{
 * 				Name: pulumi.String("S0"),
 * 				Tier: pulumi.String("Standard"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Service;
 * import com.pulumi.azurenative.appplatform.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .location("eastus")
 *             .properties()
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "S0"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Services_CreateOrUpdate_Consumption
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.AppPlatform.Service("service", new()
 *     {
 *         Location = "eastus",
 *         Properties = new AzureNative.AppPlatform.Inputs.ClusterResourcePropertiesArgs
 *         {
 *             ManagedEnvironmentId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.App/managedEnvironments/myenvironment",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         Sku = new AzureNative.AppPlatform.Inputs.SkuArgs
 *         {
 *             Name = "S0",
 *             Tier = "StandardGen2",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewService(ctx, "service", &appplatform.ServiceArgs{
 * 			Location: pulumi.String("eastus"),
 * 			Properties: &appplatform.ClusterResourcePropertiesArgs{
 * 				ManagedEnvironmentId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.App/managedEnvironments/myenvironment"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 			Sku: &appplatform.SkuArgs{
 * 				Name: pulumi.String("S0"),
 * 				Tier: pulumi.String("StandardGen2"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Service;
 * import com.pulumi.azurenative.appplatform.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .location("eastus")
 *             .properties(Map.of("managedEnvironmentId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.App/managedEnvironments/myenvironment"))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "S0"),
 *                 Map.entry("tier", "StandardGen2")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Services_CreateOrUpdate_Enterprise
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.AppPlatform.Service("service", new()
 *     {
 *         Location = "eastus",
 *         Properties = new AzureNative.AppPlatform.Inputs.ClusterResourcePropertiesArgs
 *         {
 *             MarketplaceResource = new AzureNative.AppPlatform.Inputs.MarketplaceResourceArgs
 *             {
 *                 Plan = "tanzu-asc-ent-mtr",
 *                 Product = "azure-spring-cloud-vmware-tanzu-2",
 *                 Publisher = "vmware-inc",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         Sku = new AzureNative.AppPlatform.Inputs.SkuArgs
 *         {
 *             Name = "E0",
 *             Tier = "Enterprise",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appplatform.NewService(ctx, "service", &appplatform.ServiceArgs{
 * 			Location: pulumi.String("eastus"),
 * 			Properties: appplatform.ClusterResourcePropertiesResponse{
 * 				MarketplaceResource: &appplatform.MarketplaceResourceArgs{
 * 					Plan:      pulumi.String("tanzu-asc-ent-mtr"),
 * 					Product:   pulumi.String("azure-spring-cloud-vmware-tanzu-2"),
 * 					Publisher: pulumi.String("vmware-inc"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ServiceName:       pulumi.String("myservice"),
 * 			Sku: &appplatform.SkuArgs{
 * 				Name: pulumi.String("E0"),
 * 				Tier: pulumi.String("Enterprise"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Service;
 * import com.pulumi.azurenative.appplatform.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .location("eastus")
 *             .properties(Map.of("marketplaceResource", Map.ofEntries(
 *                 Map.entry("plan", "tanzu-asc-ent-mtr"),
 *                 Map.entry("product", "azure-spring-cloud-vmware-tanzu-2"),
 *                 Map.entry("publisher", "vmware-inc")
 *             )))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "E0"),
 *                 Map.entry("tier", "Enterprise")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Services_CreateOrUpdate_VNetInjection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.AppPlatform.Service("service", new()
 *     {
 *         Location = "eastus",
 *         Properties = new AzureNative.AppPlatform.Inputs.ClusterResourcePropertiesArgs
 *         {
 *             NetworkProfile = new AzureNative.AppPlatform.Inputs.NetworkProfileArgs
 *             {
 *                 AppNetworkResourceGroup = "my-app-network-rg",
 *                 AppSubnetId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVirtualNetwork/subnets/apps",
 *                 IngressConfig = new AzureNative.AppPlatform.Inputs.IngressConfigArgs
 *                 {
 *                     ReadTimeoutInSeconds = 300,
 *                 },
 *                 ServiceCidr = "10.8.0.0/16,10.244.0.0/16,10.245.0.1/16",
 *                 ServiceRuntimeNetworkResourceGroup = "my-service-runtime-network-rg",
 *                 ServiceRuntimeSubnetId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVirtualNetwork/subnets/serviceRuntime",
 *             },
 *             VnetAddons = new AzureNative.AppPlatform.Inputs.ServiceVNetAddonsArgs
 *             {
 *                 DataPlanePublicEndpoint = true,
 *                 LogStreamPublicEndpoint = true,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myservice",
 *         Sku = new AzureNative.AppPlatform.Inputs.SkuArgs
 *         {
 *             Name = "S0",
 *             Tier = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/appplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := appplatform.NewService(ctx, "service", &appplatform.ServiceArgs{
 * Location: pulumi.String("eastus"),
 * Properties: appplatform.ClusterResourcePropertiesResponse{
 * NetworkProfile: interface{}{
 * AppNetworkResourceGroup: pulumi.String("my-app-network-rg"),
 * AppSubnetId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVirtualNetwork/subnets/apps"),
 * IngressConfig: &appplatform.IngressConfigArgs{
 * ReadTimeoutInSeconds: pulumi.Int(300),
 * },
 * ServiceCidr: pulumi.String("10.8.0.0/16,10.244.0.0/16,10.245.0.1/16"),
 * ServiceRuntimeNetworkResourceGroup: pulumi.String("my-service-runtime-network-rg"),
 * ServiceRuntimeSubnetId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVirtualNetwork/subnets/serviceRuntime"),
 * },
 * VnetAddons: &appplatform.ServiceVNetAddonsArgs{
 * DataPlanePublicEndpoint: pulumi.Bool(true),
 * LogStreamPublicEndpoint: pulumi.Bool(true),
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * ServiceName: pulumi.String("myservice"),
 * Sku: &appplatform.SkuArgs{
 * Name: pulumi.String("S0"),
 * Tier: pulumi.String("Standard"),
 * },
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("value1"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.appplatform.Service;
 * import com.pulumi.azurenative.appplatform.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("networkProfile", Map.ofEntries(
 *                     Map.entry("appNetworkResourceGroup", "my-app-network-rg"),
 *                     Map.entry("appSubnetId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVirtualNetwork/subnets/apps"),
 *                     Map.entry("ingressConfig", Map.of("readTimeoutInSeconds", 300)),
 *                     Map.entry("serviceCidr", "10.8.0.0/16,10.244.0.0/16,10.245.0.1/16"),
 *                     Map.entry("serviceRuntimeNetworkResourceGroup", "my-service-runtime-network-rg"),
 *                     Map.entry("serviceRuntimeSubnetId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/myVirtualNetwork/subnets/serviceRuntime")
 *                 )),
 *                 Map.entry("vnetAddons", Map.ofEntries(
 *                     Map.entry("dataPlanePublicEndpoint", true),
 *                     Map.entry("logStreamPublicEndpoint", true)
 *                 ))
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myservice")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "S0"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:appplatform:Service myservice /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}
 * ```
 * @property location The GEO location of the resource.
 * @property properties Properties of the Service resource
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 * @property sku Sku of the Service resource
 * @property tags Tags of the service which is a list of key value pairs that describe the resource.
 */
public data class ServiceArgs(
    public val location: Output<String>? = null,
    public val properties: Output<ClusterResourcePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.ServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.ServiceArgs =
        com.pulumi.azurenative.appplatform.ServiceArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ServiceArgs].
 */
@PulumiTagMarker
public class ServiceArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var properties: Output<ClusterResourcePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The GEO location of the resource.
     */
    @JvmName("dsutccxobmhrsixg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties of the Service resource
     */
    @JvmName("lsisliisbaxsxnvj")
    public suspend fun properties(`value`: Output<ClusterResourcePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("sfdleijwnmawyorq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("ktnjpjqedttdnnws")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Sku of the Service resource
     */
    @JvmName("knpcrykwavnmgjou")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Tags of the service which is a list of key value pairs that describe the resource.
     */
    @JvmName("tmdkflyafjqalkxr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The GEO location of the resource.
     */
    @JvmName("uyllkienxqvesjcn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties of the Service resource
     */
    @JvmName("iaigvnaleportcpt")
    public suspend fun properties(`value`: ClusterResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the Service resource
     */
    @JvmName("woahhiasbrgrstha")
    public suspend fun properties(argument: suspend ClusterResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterResourcePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("kvsdrutnrhhfvpgo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("xmgnpkixyxksxbox")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Sku of the Service resource
     */
    @JvmName("vxutqsupuqbqkaxd")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Sku of the Service resource
     */
    @JvmName("hxgfyeulcjslyior")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Tags of the service which is a list of key value pairs that describe the resource.
     */
    @JvmName("cirwithivnilrfan")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags of the service which is a list of key value pairs that describe the resource.
     */
    @JvmName("vytumaknnwkcrgbd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ServiceArgs = ServiceArgs(
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        sku = sku,
        tags = tags,
    )
}
