@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * State of the plugin
 */
public enum class DevToolPortalFeatureState(
    public val javaValue: com.pulumi.azurenative.appplatform.enums.DevToolPortalFeatureState,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.enums.DevToolPortalFeatureState> {
    /**
     * Enable the plugin in Dev Tool Portal.
     */
    Enabled(com.pulumi.azurenative.appplatform.enums.DevToolPortalFeatureState.Enabled),

    /**
     * Disable the plugin in Dev Tool Portal.
     */
    Disabled(com.pulumi.azurenative.appplatform.enums.DevToolPortalFeatureState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.appplatform.enums.DevToolPortalFeatureState =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.enums.DevToolPortalFeatureState):
            DevToolPortalFeatureState =
            DevToolPortalFeatureState.values().first { it.javaValue == javaType }
    }
}
