@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.AcceleratorGitRepositoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authSetting Properties of the auth setting payload.
 * @property branch Git repository branch to be used.
 * @property commit Git repository commit to be used.
 * @property gitTag Git repository tag to be used.
 * @property intervalInSeconds Interval for checking for updates to Git or image repository.
 * @property url Git repository URL for the accelerator.
 */
public data class AcceleratorGitRepositoryArgs(
    public val authSetting: Output<Any>,
    public val branch: Output<String>? = null,
    public val commit: Output<String>? = null,
    public val gitTag: Output<String>? = null,
    public val intervalInSeconds: Output<Int>? = null,
    public val url: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.AcceleratorGitRepositoryArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.AcceleratorGitRepositoryArgs =
        com.pulumi.azurenative.appplatform.inputs.AcceleratorGitRepositoryArgs.builder()
            .authSetting(authSetting.applyValue({ args0 -> args0 }))
            .branch(branch?.applyValue({ args0 -> args0 }))
            .commit(commit?.applyValue({ args0 -> args0 }))
            .gitTag(gitTag?.applyValue({ args0 -> args0 }))
            .intervalInSeconds(intervalInSeconds?.applyValue({ args0 -> args0 }))
            .url(url.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AcceleratorGitRepositoryArgs].
 */
@PulumiTagMarker
public class AcceleratorGitRepositoryArgsBuilder internal constructor() {
    private var authSetting: Output<Any>? = null

    private var branch: Output<String>? = null

    private var commit: Output<String>? = null

    private var gitTag: Output<String>? = null

    private var intervalInSeconds: Output<Int>? = null

    private var url: Output<String>? = null

    /**
     * @param value Properties of the auth setting payload.
     */
    @JvmName("nigyypinllylyuwk")
    public suspend fun authSetting(`value`: Output<Any>) {
        this.authSetting = value
    }

    /**
     * @param value Git repository branch to be used.
     */
    @JvmName("ignvpsyyhbcdqiii")
    public suspend fun branch(`value`: Output<String>) {
        this.branch = value
    }

    /**
     * @param value Git repository commit to be used.
     */
    @JvmName("yekuamcrdorxksda")
    public suspend fun commit(`value`: Output<String>) {
        this.commit = value
    }

    /**
     * @param value Git repository tag to be used.
     */
    @JvmName("ccwpatehgroejrsv")
    public suspend fun gitTag(`value`: Output<String>) {
        this.gitTag = value
    }

    /**
     * @param value Interval for checking for updates to Git or image repository.
     */
    @JvmName("fulslavdqtsqwlaf")
    public suspend fun intervalInSeconds(`value`: Output<Int>) {
        this.intervalInSeconds = value
    }

    /**
     * @param value Git repository URL for the accelerator.
     */
    @JvmName("svcnogussbbvbotd")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Properties of the auth setting payload.
     */
    @JvmName("axvswwlbrflcxrke")
    public suspend fun authSetting(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authSetting = mapped
    }

    /**
     * @param value Git repository branch to be used.
     */
    @JvmName("sicgbfglvcidhpvl")
    public suspend fun branch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branch = mapped
    }

    /**
     * @param value Git repository commit to be used.
     */
    @JvmName("pphcngevcnexgoou")
    public suspend fun commit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commit = mapped
    }

    /**
     * @param value Git repository tag to be used.
     */
    @JvmName("bgtnsqukcuyeapwu")
    public suspend fun gitTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitTag = mapped
    }

    /**
     * @param value Interval for checking for updates to Git or image repository.
     */
    @JvmName("hoicoktxvsivtxbc")
    public suspend fun intervalInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intervalInSeconds = mapped
    }

    /**
     * @param value Git repository URL for the accelerator.
     */
    @JvmName("bbpfhdwkjltfgyoh")
    public suspend fun url(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): AcceleratorGitRepositoryArgs = AcceleratorGitRepositoryArgs(
        authSetting = authSetting ?: throw PulumiNullFieldException("authSetting"),
        branch = branch,
        commit = commit,
        gitTag = gitTag,
        intervalInSeconds = intervalInSeconds,
        url = url ?: throw PulumiNullFieldException("url"),
    )
}
