@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.AcceleratorPublicSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Auth setting for public url.
 * @property authType The type of the auth setting.
 * Expected value is 'Public'.
 * @property caCertResourceId Resource Id of CA certificate for https URL of Git repository.
 */
public data class AcceleratorPublicSettingArgs(
    public val authType: Output<String>,
    public val caCertResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.AcceleratorPublicSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.AcceleratorPublicSettingArgs =
        com.pulumi.azurenative.appplatform.inputs.AcceleratorPublicSettingArgs.builder()
            .authType(authType.applyValue({ args0 -> args0 }))
            .caCertResourceId(caCertResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AcceleratorPublicSettingArgs].
 */
@PulumiTagMarker
public class AcceleratorPublicSettingArgsBuilder internal constructor() {
    private var authType: Output<String>? = null

    private var caCertResourceId: Output<String>? = null

    /**
     * @param value The type of the auth setting.
     * Expected value is 'Public'.
     */
    @JvmName("quqtqdnimeuwxjen")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value Resource Id of CA certificate for https URL of Git repository.
     */
    @JvmName("aojlukjvtpoieurm")
    public suspend fun caCertResourceId(`value`: Output<String>) {
        this.caCertResourceId = value
    }

    /**
     * @param value The type of the auth setting.
     * Expected value is 'Public'.
     */
    @JvmName("jhtkanmgtfsdupxf")
    public suspend fun authType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value Resource Id of CA certificate for https URL of Git repository.
     */
    @JvmName("pdcxbjhwnkarqbqt")
    public suspend fun caCertResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caCertResourceId = mapped
    }

    internal fun build(): AcceleratorPublicSettingArgs = AcceleratorPublicSettingArgs(
        authType = authType ?: throw PulumiNullFieldException("authType"),
        caCertResourceId = caCertResourceId,
    )
}
