@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.AppResourcePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * App resource properties payload
 * @property addonConfigs Collection of addons
 * @property customPersistentDisks List of custom persistent disks
 * @property enableEndToEndTLS Indicate if end to end TLS is enabled.
 * @property httpsOnly Indicate if only https is allowed.
 * @property ingressSettings App ingress settings payload.
 * @property loadedCertificates Collection of loaded certificates
 * @property persistentDisk Persistent disk settings
 * @property public Indicates whether the App exposes public endpoint
 * @property secrets Collection of auth secrets
 * @property temporaryDisk Temporary disk settings
 * @property vnetAddons Additional App settings in vnet injection instance
 * @property workloadProfileName The workload profile used for this app. Supported for Consumption + Dedicated plan.
 */
public data class AppResourcePropertiesArgs(
    public val addonConfigs: Output<Map<String, Any>>? = null,
    public val customPersistentDisks: Output<List<CustomPersistentDiskResourceArgs>>? = null,
    public val enableEndToEndTLS: Output<Boolean>? = null,
    public val httpsOnly: Output<Boolean>? = null,
    public val ingressSettings: Output<IngressSettingsArgs>? = null,
    public val loadedCertificates: Output<List<LoadedCertificateArgs>>? = null,
    public val persistentDisk: Output<PersistentDiskArgs>? = null,
    public val `public`: Output<Boolean>? = null,
    public val secrets: Output<List<SecretArgs>>? = null,
    public val temporaryDisk: Output<TemporaryDiskArgs>? = null,
    public val vnetAddons: Output<AppVNetAddonsArgs>? = null,
    public val workloadProfileName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.AppResourcePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.AppResourcePropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.AppResourcePropertiesArgs.builder()
            .addonConfigs(
                addonConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .customPersistentDisks(
                customPersistentDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enableEndToEndTLS(enableEndToEndTLS?.applyValue({ args0 -> args0 }))
            .httpsOnly(httpsOnly?.applyValue({ args0 -> args0 }))
            .ingressSettings(ingressSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .loadedCertificates(
                loadedCertificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .persistentDisk(persistentDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .public_(`public`?.applyValue({ args0 -> args0 }))
            .secrets(
                secrets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .temporaryDisk(temporaryDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vnetAddons(vnetAddons?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .workloadProfileName(workloadProfileName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppResourcePropertiesArgs].
 */
@PulumiTagMarker
public class AppResourcePropertiesArgsBuilder internal constructor() {
    private var addonConfigs: Output<Map<String, Any>>? = null

    private var customPersistentDisks: Output<List<CustomPersistentDiskResourceArgs>>? = null

    private var enableEndToEndTLS: Output<Boolean>? = null

    private var httpsOnly: Output<Boolean>? = null

    private var ingressSettings: Output<IngressSettingsArgs>? = null

    private var loadedCertificates: Output<List<LoadedCertificateArgs>>? = null

    private var persistentDisk: Output<PersistentDiskArgs>? = null

    private var `public`: Output<Boolean>? = null

    private var secrets: Output<List<SecretArgs>>? = null

    private var temporaryDisk: Output<TemporaryDiskArgs>? = null

    private var vnetAddons: Output<AppVNetAddonsArgs>? = null

    private var workloadProfileName: Output<String>? = null

    /**
     * @param value Collection of addons
     */
    @JvmName("xteniuvfbpbynpja")
    public suspend fun addonConfigs(`value`: Output<Map<String, Any>>) {
        this.addonConfigs = value
    }

    /**
     * @param value List of custom persistent disks
     */
    @JvmName("poylcnplxxfsuwkd")
    public suspend
    fun customPersistentDisks(`value`: Output<List<CustomPersistentDiskResourceArgs>>) {
        this.customPersistentDisks = value
    }

    @JvmName("donqwinktbjxxolt")
    public suspend fun customPersistentDisks(
        vararg
        values: Output<CustomPersistentDiskResourceArgs>,
    ) {
        this.customPersistentDisks = Output.all(values.asList())
    }

    /**
     * @param values List of custom persistent disks
     */
    @JvmName("umtrwmgaananlfda")
    public suspend fun customPersistentDisks(values: List<Output<CustomPersistentDiskResourceArgs>>) {
        this.customPersistentDisks = Output.all(values)
    }

    /**
     * @param value Indicate if end to end TLS is enabled.
     */
    @JvmName("ylfhcsxftcegamnk")
    public suspend fun enableEndToEndTLS(`value`: Output<Boolean>) {
        this.enableEndToEndTLS = value
    }

    /**
     * @param value Indicate if only https is allowed.
     */
    @JvmName("afcleqeggegldfoc")
    public suspend fun httpsOnly(`value`: Output<Boolean>) {
        this.httpsOnly = value
    }

    /**
     * @param value App ingress settings payload.
     */
    @JvmName("xnofddvysjhmfuqq")
    public suspend fun ingressSettings(`value`: Output<IngressSettingsArgs>) {
        this.ingressSettings = value
    }

    /**
     * @param value Collection of loaded certificates
     */
    @JvmName("reifnhyxdfxefqgs")
    public suspend fun loadedCertificates(`value`: Output<List<LoadedCertificateArgs>>) {
        this.loadedCertificates = value
    }

    @JvmName("eewokxqxqbjvemna")
    public suspend fun loadedCertificates(vararg values: Output<LoadedCertificateArgs>) {
        this.loadedCertificates = Output.all(values.asList())
    }

    /**
     * @param values Collection of loaded certificates
     */
    @JvmName("uohwsahdyvvdkfta")
    public suspend fun loadedCertificates(values: List<Output<LoadedCertificateArgs>>) {
        this.loadedCertificates = Output.all(values)
    }

    /**
     * @param value Persistent disk settings
     */
    @JvmName("wiwubtwhtifoangh")
    public suspend fun persistentDisk(`value`: Output<PersistentDiskArgs>) {
        this.persistentDisk = value
    }

    /**
     * @param value Indicates whether the App exposes public endpoint
     */
    @JvmName("mhbykracwvdlgaso")
    public suspend fun `public`(`value`: Output<Boolean>) {
        this.`public` = value
    }

    /**
     * @param value Collection of auth secrets
     */
    @JvmName("fudxoirfjmfmgjkl")
    public suspend fun secrets(`value`: Output<List<SecretArgs>>) {
        this.secrets = value
    }

    @JvmName("btpufvfijrnrnibs")
    public suspend fun secrets(vararg values: Output<SecretArgs>) {
        this.secrets = Output.all(values.asList())
    }

    /**
     * @param values Collection of auth secrets
     */
    @JvmName("kmfeaitbcpaowrsk")
    public suspend fun secrets(values: List<Output<SecretArgs>>) {
        this.secrets = Output.all(values)
    }

    /**
     * @param value Temporary disk settings
     */
    @JvmName("ctanbqvdwhjihilc")
    public suspend fun temporaryDisk(`value`: Output<TemporaryDiskArgs>) {
        this.temporaryDisk = value
    }

    /**
     * @param value Additional App settings in vnet injection instance
     */
    @JvmName("lctqjrimdxupgwsr")
    public suspend fun vnetAddons(`value`: Output<AppVNetAddonsArgs>) {
        this.vnetAddons = value
    }

    /**
     * @param value The workload profile used for this app. Supported for Consumption + Dedicated plan.
     */
    @JvmName("tgdydeolqlyygnrp")
    public suspend fun workloadProfileName(`value`: Output<String>) {
        this.workloadProfileName = value
    }

    /**
     * @param value Collection of addons
     */
    @JvmName("ligbmhrnxncrqjma")
    public suspend fun addonConfigs(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addonConfigs = mapped
    }

    /**
     * @param values Collection of addons
     */
    @JvmName("ljjfomvaayhsgftb")
    public fun addonConfigs(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addonConfigs = mapped
    }

    /**
     * @param value List of custom persistent disks
     */
    @JvmName("vxgtchxgjoaiwjbj")
    public suspend fun customPersistentDisks(`value`: List<CustomPersistentDiskResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customPersistentDisks = mapped
    }

    /**
     * @param argument List of custom persistent disks
     */
    @JvmName("scfveslrsswoyfdr")
    public suspend
    fun customPersistentDisks(argument: List<suspend CustomPersistentDiskResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CustomPersistentDiskResourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customPersistentDisks = mapped
    }

    /**
     * @param argument List of custom persistent disks
     */
    @JvmName("nqvyhvdaftbgfamx")
    public suspend fun customPersistentDisks(
        vararg
        argument: suspend CustomPersistentDiskResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CustomPersistentDiskResourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customPersistentDisks = mapped
    }

    /**
     * @param argument List of custom persistent disks
     */
    @JvmName("kqnqyeivsrcwyedv")
    public suspend
    fun customPersistentDisks(argument: suspend CustomPersistentDiskResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            CustomPersistentDiskResourceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customPersistentDisks = mapped
    }

    /**
     * @param values List of custom persistent disks
     */
    @JvmName("ismxilsmcwqapvru")
    public suspend fun customPersistentDisks(vararg values: CustomPersistentDiskResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customPersistentDisks = mapped
    }

    /**
     * @param value Indicate if end to end TLS is enabled.
     */
    @JvmName("ckffjdydfullqqhd")
    public suspend fun enableEndToEndTLS(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableEndToEndTLS = mapped
    }

    /**
     * @param value Indicate if only https is allowed.
     */
    @JvmName("evyqpdkmfurdtxoa")
    public suspend fun httpsOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsOnly = mapped
    }

    /**
     * @param value App ingress settings payload.
     */
    @JvmName("yiatdikdjrkwbmjw")
    public suspend fun ingressSettings(`value`: IngressSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingressSettings = mapped
    }

    /**
     * @param argument App ingress settings payload.
     */
    @JvmName("lrmqvgghlrompuds")
    public suspend fun ingressSettings(argument: suspend IngressSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = IngressSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ingressSettings = mapped
    }

    /**
     * @param value Collection of loaded certificates
     */
    @JvmName("rvprjikhjcqfrfsp")
    public suspend fun loadedCertificates(`value`: List<LoadedCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadedCertificates = mapped
    }

    /**
     * @param argument Collection of loaded certificates
     */
    @JvmName("xxoaryhawmkdfcbm")
    public suspend
    fun loadedCertificates(argument: List<suspend LoadedCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LoadedCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadedCertificates = mapped
    }

    /**
     * @param argument Collection of loaded certificates
     */
    @JvmName("flabkwfytlsxqxue")
    public suspend fun loadedCertificates(
        vararg
        argument: suspend LoadedCertificateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LoadedCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadedCertificates = mapped
    }

    /**
     * @param argument Collection of loaded certificates
     */
    @JvmName("mhbhwpedcwrxnfjr")
    public suspend fun loadedCertificates(argument: suspend LoadedCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LoadedCertificateArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.loadedCertificates = mapped
    }

    /**
     * @param values Collection of loaded certificates
     */
    @JvmName("juwhpryaefijlpib")
    public suspend fun loadedCertificates(vararg values: LoadedCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadedCertificates = mapped
    }

    /**
     * @param value Persistent disk settings
     */
    @JvmName("xbiplgsfsyvdoasr")
    public suspend fun persistentDisk(`value`: PersistentDiskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.persistentDisk = mapped
    }

    /**
     * @param argument Persistent disk settings
     */
    @JvmName("fdeivfojussvhnug")
    public suspend fun persistentDisk(argument: suspend PersistentDiskArgsBuilder.() -> Unit) {
        val toBeMapped = PersistentDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.persistentDisk = mapped
    }

    /**
     * @param value Indicates whether the App exposes public endpoint
     */
    @JvmName("fxnifbjmhfxrdxbk")
    public suspend fun `public`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`public` = mapped
    }

    /**
     * @param value Collection of auth secrets
     */
    @JvmName("tndtnhjhjuslhsea")
    public suspend fun secrets(`value`: List<SecretArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param argument Collection of auth secrets
     */
    @JvmName("ghkwqprrdxcxsobf")
    public suspend fun secrets(argument: List<suspend SecretArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SecretArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param argument Collection of auth secrets
     */
    @JvmName("nahujsmqhbqmajfw")
    public suspend fun secrets(vararg argument: suspend SecretArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SecretArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param argument Collection of auth secrets
     */
    @JvmName("bjossgbrfebopdvs")
    public suspend fun secrets(argument: suspend SecretArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SecretArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.secrets = mapped
    }

    /**
     * @param values Collection of auth secrets
     */
    @JvmName("kglmisbqwuvdhofc")
    public suspend fun secrets(vararg values: SecretArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param value Temporary disk settings
     */
    @JvmName("tfnejbhtxlceuwpk")
    public suspend fun temporaryDisk(`value`: TemporaryDiskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.temporaryDisk = mapped
    }

    /**
     * @param argument Temporary disk settings
     */
    @JvmName("qqwbravljwnnjpkg")
    public suspend fun temporaryDisk(argument: suspend TemporaryDiskArgsBuilder.() -> Unit) {
        val toBeMapped = TemporaryDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.temporaryDisk = mapped
    }

    /**
     * @param value Additional App settings in vnet injection instance
     */
    @JvmName("nybblcfaeppadiuf")
    public suspend fun vnetAddons(`value`: AppVNetAddonsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetAddons = mapped
    }

    /**
     * @param argument Additional App settings in vnet injection instance
     */
    @JvmName("ngwgpuhyyewqlebr")
    public suspend fun vnetAddons(argument: suspend AppVNetAddonsArgsBuilder.() -> Unit) {
        val toBeMapped = AppVNetAddonsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vnetAddons = mapped
    }

    /**
     * @param value The workload profile used for this app. Supported for Consumption + Dedicated plan.
     */
    @JvmName("grftjselavrhtudf")
    public suspend fun workloadProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadProfileName = mapped
    }

    internal fun build(): AppResourcePropertiesArgs = AppResourcePropertiesArgs(
        addonConfigs = addonConfigs,
        customPersistentDisks = customPersistentDisks,
        enableEndToEndTLS = enableEndToEndTLS,
        httpsOnly = httpsOnly,
        ingressSettings = ingressSettings,
        loadedCertificates = loadedCertificates,
        persistentDisk = persistentDisk,
        `public` = `public`,
        secrets = secrets,
        temporaryDisk = temporaryDisk,
        vnetAddons = vnetAddons,
        workloadProfileName = workloadProfileName,
    )
}
