@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.BuildpackBindingLaunchPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Buildpack Binding Launch Properties
 * @property properties Non-sensitive properties for launchProperties
 * @property secrets Sensitive properties for launchProperties
 */
public data class BuildpackBindingLaunchPropertiesArgs(
    public val properties: Output<Map<String, String>>? = null,
    public val secrets: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.BuildpackBindingLaunchPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.appplatform.inputs.BuildpackBindingLaunchPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.BuildpackBindingLaunchPropertiesArgs.builder()
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .secrets(
                secrets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BuildpackBindingLaunchPropertiesArgs].
 */
@PulumiTagMarker
public class BuildpackBindingLaunchPropertiesArgsBuilder internal constructor() {
    private var properties: Output<Map<String, String>>? = null

    private var secrets: Output<Map<String, String>>? = null

    /**
     * @param value Non-sensitive properties for launchProperties
     */
    @JvmName("twturjjgvxnarhbc")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Sensitive properties for launchProperties
     */
    @JvmName("ihgfmbueidjtwhmj")
    public suspend fun secrets(`value`: Output<Map<String, String>>) {
        this.secrets = value
    }

    /**
     * @param value Non-sensitive properties for launchProperties
     */
    @JvmName("pteffvyhdhhgitgm")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Non-sensitive properties for launchProperties
     */
    @JvmName("fpybtwlwfynxsndm")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Sensitive properties for launchProperties
     */
    @JvmName("avsrxrgxdjxmyelf")
    public suspend fun secrets(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param values Sensitive properties for launchProperties
     */
    @JvmName("vewtprsnmvaialvj")
    public fun secrets(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    internal fun build(): BuildpackBindingLaunchPropertiesArgs = BuildpackBindingLaunchPropertiesArgs(
        properties = properties,
        secrets = secrets,
    )
}
