@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ClusterResourcePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Service properties payload
 * @property infraResourceGroup The name of the resource group that contains the infrastructure resources
 * @property managedEnvironmentId The resource Id of the Managed Environment that the Spring Apps instance builds on
 * @property marketplaceResource Purchasing 3rd party product of the Service resource.
 * @property networkProfile Network profile of the Service
 * @property vnetAddons Additional Service settings in vnet injection instance
 * @property zoneRedundant
 */
public data class ClusterResourcePropertiesArgs(
    public val infraResourceGroup: Output<String>? = null,
    public val managedEnvironmentId: Output<String>? = null,
    public val marketplaceResource: Output<MarketplaceResourceArgs>? = null,
    public val networkProfile: Output<NetworkProfileArgs>? = null,
    public val vnetAddons: Output<ServiceVNetAddonsArgs>? = null,
    public val zoneRedundant: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ClusterResourcePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ClusterResourcePropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.ClusterResourcePropertiesArgs.builder()
            .infraResourceGroup(infraResourceGroup?.applyValue({ args0 -> args0 }))
            .managedEnvironmentId(managedEnvironmentId?.applyValue({ args0 -> args0 }))
            .marketplaceResource(
                marketplaceResource?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vnetAddons(vnetAddons?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .zoneRedundant(zoneRedundant?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterResourcePropertiesArgs].
 */
@PulumiTagMarker
public class ClusterResourcePropertiesArgsBuilder internal constructor() {
    private var infraResourceGroup: Output<String>? = null

    private var managedEnvironmentId: Output<String>? = null

    private var marketplaceResource: Output<MarketplaceResourceArgs>? = null

    private var networkProfile: Output<NetworkProfileArgs>? = null

    private var vnetAddons: Output<ServiceVNetAddonsArgs>? = null

    private var zoneRedundant: Output<Boolean>? = null

    /**
     * @param value The name of the resource group that contains the infrastructure resources
     */
    @JvmName("yxodrynfuqpxqqmk")
    public suspend fun infraResourceGroup(`value`: Output<String>) {
        this.infraResourceGroup = value
    }

    /**
     * @param value The resource Id of the Managed Environment that the Spring Apps instance builds on
     */
    @JvmName("ivowqbqkmblejego")
    public suspend fun managedEnvironmentId(`value`: Output<String>) {
        this.managedEnvironmentId = value
    }

    /**
     * @param value Purchasing 3rd party product of the Service resource.
     */
    @JvmName("yvkqqckpujjnunxs")
    public suspend fun marketplaceResource(`value`: Output<MarketplaceResourceArgs>) {
        this.marketplaceResource = value
    }

    /**
     * @param value Network profile of the Service
     */
    @JvmName("dedroluakwraixwr")
    public suspend fun networkProfile(`value`: Output<NetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value Additional Service settings in vnet injection instance
     */
    @JvmName("mrfxrhnctdlochpa")
    public suspend fun vnetAddons(`value`: Output<ServiceVNetAddonsArgs>) {
        this.vnetAddons = value
    }

    /**
     * @param value
     */
    @JvmName("mtyamhlstybjtwps")
    public suspend fun zoneRedundant(`value`: Output<Boolean>) {
        this.zoneRedundant = value
    }

    /**
     * @param value The name of the resource group that contains the infrastructure resources
     */
    @JvmName("nrcfblsvotaqqtxc")
    public suspend fun infraResourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infraResourceGroup = mapped
    }

    /**
     * @param value The resource Id of the Managed Environment that the Spring Apps instance builds on
     */
    @JvmName("msekblqextifvahj")
    public suspend fun managedEnvironmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedEnvironmentId = mapped
    }

    /**
     * @param value Purchasing 3rd party product of the Service resource.
     */
    @JvmName("lxccnplkemecidwq")
    public suspend fun marketplaceResource(`value`: MarketplaceResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketplaceResource = mapped
    }

    /**
     * @param argument Purchasing 3rd party product of the Service resource.
     */
    @JvmName("qowcqrbxisyekohm")
    public suspend
    fun marketplaceResource(argument: suspend MarketplaceResourceArgsBuilder.() -> Unit) {
        val toBeMapped = MarketplaceResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.marketplaceResource = mapped
    }

    /**
     * @param value Network profile of the Service
     */
    @JvmName("wuomgxeooyjwxjwg")
    public suspend fun networkProfile(`value`: NetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument Network profile of the Service
     */
    @JvmName("qqvvnehoxwawdhat")
    public suspend fun networkProfile(argument: suspend NetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value Additional Service settings in vnet injection instance
     */
    @JvmName("gdecueaowdiqeqon")
    public suspend fun vnetAddons(`value`: ServiceVNetAddonsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetAddons = mapped
    }

    /**
     * @param argument Additional Service settings in vnet injection instance
     */
    @JvmName("hnkvohuvjvkfoyha")
    public suspend fun vnetAddons(argument: suspend ServiceVNetAddonsArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceVNetAddonsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vnetAddons = mapped
    }

    /**
     * @param value
     */
    @JvmName("nohfhahbfaeowqko")
    public suspend fun zoneRedundant(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneRedundant = mapped
    }

    internal fun build(): ClusterResourcePropertiesArgs = ClusterResourcePropertiesArgs(
        infraResourceGroup = infraResourceGroup,
        managedEnvironmentId = managedEnvironmentId,
        marketplaceResource = marketplaceResource,
        networkProfile = networkProfile,
        vnetAddons = vnetAddons,
        zoneRedundant = zoneRedundant,
    )
}
