@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ConfigServerPropertiesArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.enums.ConfigServerEnabledState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Config server git properties payload
 * @property configServer Settings of config server.
 * @property enabledState Enabled state of the config server. This is only used in Consumption tier.
 * @property error Error when apply config server settings.
 */
public data class ConfigServerPropertiesArgs(
    public val configServer: Output<ConfigServerSettingsArgs>? = null,
    public val enabledState: Output<Either<String, ConfigServerEnabledState>>? = null,
    public val error: Output<ErrorArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ConfigServerPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ConfigServerPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.ConfigServerPropertiesArgs.builder()
            .configServer(configServer?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabledState(
                enabledState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .error(error?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConfigServerPropertiesArgs].
 */
@PulumiTagMarker
public class ConfigServerPropertiesArgsBuilder internal constructor() {
    private var configServer: Output<ConfigServerSettingsArgs>? = null

    private var enabledState: Output<Either<String, ConfigServerEnabledState>>? = null

    private var error: Output<ErrorArgs>? = null

    /**
     * @param value Settings of config server.
     */
    @JvmName("vwhwpcdahualylia")
    public suspend fun configServer(`value`: Output<ConfigServerSettingsArgs>) {
        this.configServer = value
    }

    /**
     * @param value Enabled state of the config server. This is only used in Consumption tier.
     */
    @JvmName("fymetqgtrxjynstw")
    public suspend fun enabledState(`value`: Output<Either<String, ConfigServerEnabledState>>) {
        this.enabledState = value
    }

    /**
     * @param value Error when apply config server settings.
     */
    @JvmName("uegrcxooebpalehc")
    public suspend fun error(`value`: Output<ErrorArgs>) {
        this.error = value
    }

    /**
     * @param value Settings of config server.
     */
    @JvmName("trdmfwvcmfigqthe")
    public suspend fun configServer(`value`: ConfigServerSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configServer = mapped
    }

    /**
     * @param argument Settings of config server.
     */
    @JvmName("ttjyrvlkmkcsctua")
    public suspend fun configServer(argument: suspend ConfigServerSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigServerSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configServer = mapped
    }

    /**
     * @param value Enabled state of the config server. This is only used in Consumption tier.
     */
    @JvmName("lmfibewygebnqlhl")
    public suspend fun enabledState(`value`: Either<String, ConfigServerEnabledState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Enabled state of the config server. This is only used in Consumption tier.
     */
    @JvmName("waywephjrkyymnab")
    public fun enabledState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConfigServerEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Enabled state of the config server. This is only used in Consumption tier.
     */
    @JvmName("lhfxvscitsonbtis")
    public fun enabledState(`value`: ConfigServerEnabledState) {
        val toBeMapped = Either.ofRight<String, ConfigServerEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Error when apply config server settings.
     */
    @JvmName("oudlwmsjxghflxes")
    public suspend fun error(`value`: ErrorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.error = mapped
    }

    /**
     * @param argument Error when apply config server settings.
     */
    @JvmName("xhxmkunbrqptmrja")
    public suspend fun error(argument: suspend ErrorArgsBuilder.() -> Unit) {
        val toBeMapped = ErrorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.error = mapped
    }

    internal fun build(): ConfigServerPropertiesArgs = ConfigServerPropertiesArgs(
        configServer = configServer,
        enabledState = enabledState,
        error = error,
    )
}
