@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.ContainerProbeSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Container liveness and readiness probe settings
 * @property disableProbe Indicates whether disable the liveness and readiness probe
 */
public data class ContainerProbeSettingsArgs(
    public val disableProbe: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.ContainerProbeSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.ContainerProbeSettingsArgs =
        com.pulumi.azurenative.appplatform.inputs.ContainerProbeSettingsArgs.builder()
            .disableProbe(disableProbe?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerProbeSettingsArgs].
 */
@PulumiTagMarker
public class ContainerProbeSettingsArgsBuilder internal constructor() {
    private var disableProbe: Output<Boolean>? = null

    /**
     * @param value Indicates whether disable the liveness and readiness probe
     */
    @JvmName("iwthipflulfuvobh")
    public suspend fun disableProbe(`value`: Output<Boolean>) {
        this.disableProbe = value
    }

    /**
     * @param value Indicates whether disable the liveness and readiness probe
     */
    @JvmName("pccvleajtstubsfq")
    public suspend fun disableProbe(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableProbe = mapped
    }

    internal fun build(): ContainerProbeSettingsArgs = ContainerProbeSettingsArgs(
        disableProbe = disableProbe,
    )
}
