@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.CustomDomainPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Custom domain of app resource payload.
 * @property certName The bound certificate name of domain.
 * @property thumbprint The thumbprint of bound certificate.
 */
public data class CustomDomainPropertiesArgs(
    public val certName: Output<String>? = null,
    public val thumbprint: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.CustomDomainPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.CustomDomainPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.CustomDomainPropertiesArgs.builder()
            .certName(certName?.applyValue({ args0 -> args0 }))
            .thumbprint(thumbprint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomDomainPropertiesArgs].
 */
@PulumiTagMarker
public class CustomDomainPropertiesArgsBuilder internal constructor() {
    private var certName: Output<String>? = null

    private var thumbprint: Output<String>? = null

    /**
     * @param value The bound certificate name of domain.
     */
    @JvmName("iyuyprtorcucltji")
    public suspend fun certName(`value`: Output<String>) {
        this.certName = value
    }

    /**
     * @param value The thumbprint of bound certificate.
     */
    @JvmName("ppxgxvigiahsecaw")
    public suspend fun thumbprint(`value`: Output<String>) {
        this.thumbprint = value
    }

    /**
     * @param value The bound certificate name of domain.
     */
    @JvmName("jlpfmbspahkdwujc")
    public suspend fun certName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certName = mapped
    }

    /**
     * @param value The thumbprint of bound certificate.
     */
    @JvmName("mlepnajkacmhypvs")
    public suspend fun thumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thumbprint = mapped
    }

    internal fun build(): CustomDomainPropertiesArgs = CustomDomainPropertiesArgs(
        certName = certName,
        thumbprint = thumbprint,
    )
}
