@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.CustomizedAcceleratorPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Customized accelerator properties payload
 * @property acceleratorTags
 * @property description
 * @property displayName
 * @property gitRepository
 * @property iconUrl
 */
public data class CustomizedAcceleratorPropertiesArgs(
    public val acceleratorTags: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val gitRepository: Output<AcceleratorGitRepositoryArgs>,
    public val iconUrl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.CustomizedAcceleratorPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.appplatform.inputs.CustomizedAcceleratorPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.CustomizedAcceleratorPropertiesArgs.builder()
            .acceleratorTags(acceleratorTags?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .gitRepository(gitRepository.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .iconUrl(iconUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomizedAcceleratorPropertiesArgs].
 */
@PulumiTagMarker
public class CustomizedAcceleratorPropertiesArgsBuilder internal constructor() {
    private var acceleratorTags: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var gitRepository: Output<AcceleratorGitRepositoryArgs>? = null

    private var iconUrl: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("icllruuyjemqkxqx")
    public suspend fun acceleratorTags(`value`: Output<List<String>>) {
        this.acceleratorTags = value
    }

    @JvmName("epodfxclpvykgkuf")
    public suspend fun acceleratorTags(vararg values: Output<String>) {
        this.acceleratorTags = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("vfgclbvencfskhhp")
    public suspend fun acceleratorTags(values: List<Output<String>>) {
        this.acceleratorTags = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("kgwdtfnyfefvxmva")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("hutnimimikdbbowf")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value
     */
    @JvmName("kwdhfcpielevgwrx")
    public suspend fun gitRepository(`value`: Output<AcceleratorGitRepositoryArgs>) {
        this.gitRepository = value
    }

    /**
     * @param value
     */
    @JvmName("awuaocegjtxeuvpg")
    public suspend fun iconUrl(`value`: Output<String>) {
        this.iconUrl = value
    }

    /**
     * @param value
     */
    @JvmName("ywehifeuwrjslakm")
    public suspend fun acceleratorTags(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorTags = mapped
    }

    /**
     * @param values
     */
    @JvmName("exksxtfgwxjgpbqh")
    public suspend fun acceleratorTags(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acceleratorTags = mapped
    }

    /**
     * @param value
     */
    @JvmName("decqtuutlgjypvog")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("xacmibsvwknhegoa")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value
     */
    @JvmName("bceolewjcwejhpyp")
    public suspend fun gitRepository(`value`: AcceleratorGitRepositoryArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gitRepository = mapped
    }

    /**
     * @param argument
     */
    @JvmName("tlhrlymnndxcuciq")
    public suspend
    fun gitRepository(argument: suspend AcceleratorGitRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped = AcceleratorGitRepositoryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gitRepository = mapped
    }

    /**
     * @param value
     */
    @JvmName("kaijrqbbduedcidi")
    public suspend fun iconUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iconUrl = mapped
    }

    internal fun build(): CustomizedAcceleratorPropertiesArgs = CustomizedAcceleratorPropertiesArgs(
        acceleratorTags = acceleratorTags,
        description = description,
        displayName = displayName,
        gitRepository = gitRepository ?: throw PulumiNullFieldException("gitRepository"),
        iconUrl = iconUrl,
    )
}
