@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.DevToolPortalFeatureDetailArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.enums.DevToolPortalFeatureState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Detail settings for Dev Tool Portal feature
 * @property state State of the plugin
 */
public data class DevToolPortalFeatureDetailArgs(
    public val state: Output<Either<String, DevToolPortalFeatureState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.DevToolPortalFeatureDetailArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.DevToolPortalFeatureDetailArgs =
        com.pulumi.azurenative.appplatform.inputs.DevToolPortalFeatureDetailArgs.builder()
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DevToolPortalFeatureDetailArgs].
 */
@PulumiTagMarker
public class DevToolPortalFeatureDetailArgsBuilder internal constructor() {
    private var state: Output<Either<String, DevToolPortalFeatureState>>? = null

    /**
     * @param value State of the plugin
     */
    @JvmName("kuwhrjtufvioyxmp")
    public suspend fun state(`value`: Output<Either<String, DevToolPortalFeatureState>>) {
        this.state = value
    }

    /**
     * @param value State of the plugin
     */
    @JvmName("eiisbalgkgmntmhs")
    public suspend fun state(`value`: Either<String, DevToolPortalFeatureState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value State of the plugin
     */
    @JvmName("hhygknsikjujeimn")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DevToolPortalFeatureState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value State of the plugin
     */
    @JvmName("calmmvwfyukwedft")
    public fun state(`value`: DevToolPortalFeatureState) {
        val toBeMapped = Either.ofRight<String, DevToolPortalFeatureState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): DevToolPortalFeatureDetailArgs = DevToolPortalFeatureDetailArgs(
        state = state,
    )
}
