@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.DevToolPortalFeatureSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Settings for Dev Tool Portal
 * @property applicationAccelerator Detail of Accelerator plugin
 * @property applicationLiveView Detail of App Live View plugin
 */
public data class DevToolPortalFeatureSettingsArgs(
    public val applicationAccelerator: Output<DevToolPortalFeatureDetailArgs>? = null,
    public val applicationLiveView: Output<DevToolPortalFeatureDetailArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.DevToolPortalFeatureSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.DevToolPortalFeatureSettingsArgs =
        com.pulumi.azurenative.appplatform.inputs.DevToolPortalFeatureSettingsArgs.builder()
            .applicationAccelerator(
                applicationAccelerator?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .applicationLiveView(
                applicationLiveView?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DevToolPortalFeatureSettingsArgs].
 */
@PulumiTagMarker
public class DevToolPortalFeatureSettingsArgsBuilder internal constructor() {
    private var applicationAccelerator: Output<DevToolPortalFeatureDetailArgs>? = null

    private var applicationLiveView: Output<DevToolPortalFeatureDetailArgs>? = null

    /**
     * @param value Detail of Accelerator plugin
     */
    @JvmName("sthbqaiphblyljsq")
    public suspend fun applicationAccelerator(`value`: Output<DevToolPortalFeatureDetailArgs>) {
        this.applicationAccelerator = value
    }

    /**
     * @param value Detail of App Live View plugin
     */
    @JvmName("utjaegojshojumyg")
    public suspend fun applicationLiveView(`value`: Output<DevToolPortalFeatureDetailArgs>) {
        this.applicationLiveView = value
    }

    /**
     * @param value Detail of Accelerator plugin
     */
    @JvmName("egdenaxvlbdewqcw")
    public suspend fun applicationAccelerator(`value`: DevToolPortalFeatureDetailArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationAccelerator = mapped
    }

    /**
     * @param argument Detail of Accelerator plugin
     */
    @JvmName("lanpoqxyevrsebnb")
    public suspend
    fun applicationAccelerator(argument: suspend DevToolPortalFeatureDetailArgsBuilder.() -> Unit) {
        val toBeMapped = DevToolPortalFeatureDetailArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.applicationAccelerator = mapped
    }

    /**
     * @param value Detail of App Live View plugin
     */
    @JvmName("fboimievcfclggnx")
    public suspend fun applicationLiveView(`value`: DevToolPortalFeatureDetailArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationLiveView = mapped
    }

    /**
     * @param argument Detail of App Live View plugin
     */
    @JvmName("ulalohaiueclwwoj")
    public suspend
    fun applicationLiveView(argument: suspend DevToolPortalFeatureDetailArgsBuilder.() -> Unit) {
        val toBeMapped = DevToolPortalFeatureDetailArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.applicationLiveView = mapped
    }

    internal fun build(): DevToolPortalFeatureSettingsArgs = DevToolPortalFeatureSettingsArgs(
        applicationAccelerator = applicationAccelerator,
        applicationLiveView = applicationLiveView,
    )
}
