@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.DevToolPortalSsoPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Single sign-on related configuration
 * @property clientId The public identifier for the application
 * @property clientSecret The secret known only to the application and the authorization server
 * @property metadataUrl The URI of a JSON file with generic OIDC provider configuration.
 * @property scopes It defines the specific actions applications can be allowed to do on a user's behalf
 */
public data class DevToolPortalSsoPropertiesArgs(
    public val clientId: Output<String>? = null,
    public val clientSecret: Output<String>? = null,
    public val metadataUrl: Output<String>? = null,
    public val scopes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.DevToolPortalSsoPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.DevToolPortalSsoPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.DevToolPortalSsoPropertiesArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret?.applyValue({ args0 -> args0 }))
            .metadataUrl(metadataUrl?.applyValue({ args0 -> args0 }))
            .scopes(scopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DevToolPortalSsoPropertiesArgs].
 */
@PulumiTagMarker
public class DevToolPortalSsoPropertiesArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var metadataUrl: Output<String>? = null

    private var scopes: Output<List<String>>? = null

    /**
     * @param value The public identifier for the application
     */
    @JvmName("kaplqrcjrlfyqrag")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The secret known only to the application and the authorization server
     */
    @JvmName("brtytrqjxooraqnv")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value The URI of a JSON file with generic OIDC provider configuration.
     */
    @JvmName("hloklqwhwuvgjgjk")
    public suspend fun metadataUrl(`value`: Output<String>) {
        this.metadataUrl = value
    }

    /**
     * @param value It defines the specific actions applications can be allowed to do on a user's behalf
     */
    @JvmName("jtourfjvbtocpbyk")
    public suspend fun scopes(`value`: Output<List<String>>) {
        this.scopes = value
    }

    @JvmName("ieoalgkdcbxjtosr")
    public suspend fun scopes(vararg values: Output<String>) {
        this.scopes = Output.all(values.asList())
    }

    /**
     * @param values It defines the specific actions applications can be allowed to do on a user's behalf
     */
    @JvmName("trveiqlhxcuncbmc")
    public suspend fun scopes(values: List<Output<String>>) {
        this.scopes = Output.all(values)
    }

    /**
     * @param value The public identifier for the application
     */
    @JvmName("mcqeholsnoofaunk")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The secret known only to the application and the authorization server
     */
    @JvmName("hdvncwudoengwaqa")
    public suspend fun clientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The URI of a JSON file with generic OIDC provider configuration.
     */
    @JvmName("yjgayecwntnfpgqc")
    public suspend fun metadataUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadataUrl = mapped
    }

    /**
     * @param value It defines the specific actions applications can be allowed to do on a user's behalf
     */
    @JvmName("mworesqiiucukkia")
    public suspend fun scopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param values It defines the specific actions applications can be allowed to do on a user's behalf
     */
    @JvmName("skpmvnktfncnjgnk")
    public suspend fun scopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    internal fun build(): DevToolPortalSsoPropertiesArgs = DevToolPortalSsoPropertiesArgs(
        clientId = clientId,
        clientSecret = clientSecret,
        metadataUrl = metadataUrl,
        scopes = scopes,
    )
}
