@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GatewayPropertiesArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.enums.ApmType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Spring Cloud Gateway properties payload
 * @property addonConfigs Collection of addons for Spring Cloud Gateway
 * @property apiMetadataProperties API metadata property for Spring Cloud Gateway
 * @property apmTypes Collection of APM type used in Spring Cloud Gateway
 * @property clientAuth Client-Certification Authentication.
 * @property corsProperties Cross-Origin Resource Sharing property
 * @property environmentVariables Environment variables of Spring Cloud Gateway
 * @property httpsOnly Indicate if only https is allowed.
 * @property public Indicates whether the Spring Cloud Gateway exposes endpoint.
 * @property resourceRequests The requested resource quantity for required CPU and Memory.
 * @property ssoProperties Single sign-on related configuration
 */
public data class GatewayPropertiesArgs(
    public val addonConfigs: Output<Map<String, Any>>? = null,
    public val apiMetadataProperties: Output<GatewayApiMetadataPropertiesArgs>? = null,
    public val apmTypes: Output<List<Either<String, ApmType>>>? = null,
    public val clientAuth: Output<GatewayPropertiesClientAuthArgs>? = null,
    public val corsProperties: Output<GatewayCorsPropertiesArgs>? = null,
    public val environmentVariables: Output<GatewayPropertiesEnvironmentVariablesArgs>? = null,
    public val httpsOnly: Output<Boolean>? = null,
    public val `public`: Output<Boolean>? = null,
    public val resourceRequests: Output<GatewayResourceRequestsArgs>? = null,
    public val ssoProperties: Output<SsoPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GatewayPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GatewayPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.GatewayPropertiesArgs.builder()
            .addonConfigs(
                addonConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .apiMetadataProperties(
                apiMetadataProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .apmTypes(
                apmTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .clientAuth(clientAuth?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .corsProperties(corsProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .httpsOnly(httpsOnly?.applyValue({ args0 -> args0 }))
            .public_(`public`?.applyValue({ args0 -> args0 }))
            .resourceRequests(resourceRequests?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ssoProperties(ssoProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GatewayPropertiesArgs].
 */
@PulumiTagMarker
public class GatewayPropertiesArgsBuilder internal constructor() {
    private var addonConfigs: Output<Map<String, Any>>? = null

    private var apiMetadataProperties: Output<GatewayApiMetadataPropertiesArgs>? = null

    private var apmTypes: Output<List<Either<String, ApmType>>>? = null

    private var clientAuth: Output<GatewayPropertiesClientAuthArgs>? = null

    private var corsProperties: Output<GatewayCorsPropertiesArgs>? = null

    private var environmentVariables: Output<GatewayPropertiesEnvironmentVariablesArgs>? = null

    private var httpsOnly: Output<Boolean>? = null

    private var `public`: Output<Boolean>? = null

    private var resourceRequests: Output<GatewayResourceRequestsArgs>? = null

    private var ssoProperties: Output<SsoPropertiesArgs>? = null

    /**
     * @param value Collection of addons for Spring Cloud Gateway
     */
    @JvmName("arxdwjeneylnnvgb")
    public suspend fun addonConfigs(`value`: Output<Map<String, Any>>) {
        this.addonConfigs = value
    }

    /**
     * @param value API metadata property for Spring Cloud Gateway
     */
    @JvmName("kmodnmprakdjdyew")
    public suspend fun apiMetadataProperties(`value`: Output<GatewayApiMetadataPropertiesArgs>) {
        this.apiMetadataProperties = value
    }

    /**
     * @param value Collection of APM type used in Spring Cloud Gateway
     */
    @JvmName("qotnuvdhmihvsjcp")
    public suspend fun apmTypes(`value`: Output<List<Either<String, ApmType>>>) {
        this.apmTypes = value
    }

    @JvmName("hcudcevthutvkybr")
    public suspend fun apmTypes(vararg values: Output<Either<String, ApmType>>) {
        this.apmTypes = Output.all(values.asList())
    }

    /**
     * @param values Collection of APM type used in Spring Cloud Gateway
     */
    @JvmName("dmjfohttpsxhjjqp")
    public suspend fun apmTypes(values: List<Output<Either<String, ApmType>>>) {
        this.apmTypes = Output.all(values)
    }

    /**
     * @param value Client-Certification Authentication.
     */
    @JvmName("ydwehpmqtkkisdux")
    public suspend fun clientAuth(`value`: Output<GatewayPropertiesClientAuthArgs>) {
        this.clientAuth = value
    }

    /**
     * @param value Cross-Origin Resource Sharing property
     */
    @JvmName("fnhfttgurirfyaej")
    public suspend fun corsProperties(`value`: Output<GatewayCorsPropertiesArgs>) {
        this.corsProperties = value
    }

    /**
     * @param value Environment variables of Spring Cloud Gateway
     */
    @JvmName("nfbiqluwhqmrupvn")
    public suspend
    fun environmentVariables(`value`: Output<GatewayPropertiesEnvironmentVariablesArgs>) {
        this.environmentVariables = value
    }

    /**
     * @param value Indicate if only https is allowed.
     */
    @JvmName("prvtojddhhedwqsb")
    public suspend fun httpsOnly(`value`: Output<Boolean>) {
        this.httpsOnly = value
    }

    /**
     * @param value Indicates whether the Spring Cloud Gateway exposes endpoint.
     */
    @JvmName("reiqxsbuwrjdrtnr")
    public suspend fun `public`(`value`: Output<Boolean>) {
        this.`public` = value
    }

    /**
     * @param value The requested resource quantity for required CPU and Memory.
     */
    @JvmName("tndeetkoptdfpjiu")
    public suspend fun resourceRequests(`value`: Output<GatewayResourceRequestsArgs>) {
        this.resourceRequests = value
    }

    /**
     * @param value Single sign-on related configuration
     */
    @JvmName("wmrxaqufbopslhqn")
    public suspend fun ssoProperties(`value`: Output<SsoPropertiesArgs>) {
        this.ssoProperties = value
    }

    /**
     * @param value Collection of addons for Spring Cloud Gateway
     */
    @JvmName("vbyjrbswjhyjweex")
    public suspend fun addonConfigs(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addonConfigs = mapped
    }

    /**
     * @param values Collection of addons for Spring Cloud Gateway
     */
    @JvmName("hevbdgpddcjbxakn")
    public fun addonConfigs(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addonConfigs = mapped
    }

    /**
     * @param value API metadata property for Spring Cloud Gateway
     */
    @JvmName("wnabodbpmhkbochf")
    public suspend fun apiMetadataProperties(`value`: GatewayApiMetadataPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiMetadataProperties = mapped
    }

    /**
     * @param argument API metadata property for Spring Cloud Gateway
     */
    @JvmName("eqswjkcoystvtajy")
    public suspend
    fun apiMetadataProperties(argument: suspend GatewayApiMetadataPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayApiMetadataPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.apiMetadataProperties = mapped
    }

    /**
     * @param value Collection of APM type used in Spring Cloud Gateway
     */
    @JvmName("uhiwegbmhmvevpeh")
    public suspend fun apmTypes(`value`: List<Either<String, ApmType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apmTypes = mapped
    }

    /**
     * @param values Collection of APM type used in Spring Cloud Gateway
     */
    @JvmName("fvlafqjsbyicgnfn")
    public suspend fun apmTypes(vararg values: Either<String, ApmType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apmTypes = mapped
    }

    /**
     * @param value Client-Certification Authentication.
     */
    @JvmName("lodhrdinrhyplbju")
    public suspend fun clientAuth(`value`: GatewayPropertiesClientAuthArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientAuth = mapped
    }

    /**
     * @param argument Client-Certification Authentication.
     */
    @JvmName("njhspiorvxtbfxef")
    public suspend
    fun clientAuth(argument: suspend GatewayPropertiesClientAuthArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayPropertiesClientAuthArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clientAuth = mapped
    }

    /**
     * @param value Cross-Origin Resource Sharing property
     */
    @JvmName("ctjoqaiyfadyxqis")
    public suspend fun corsProperties(`value`: GatewayCorsPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.corsProperties = mapped
    }

    /**
     * @param argument Cross-Origin Resource Sharing property
     */
    @JvmName("nkmrajlixjfkrssu")
    public suspend fun corsProperties(argument: suspend GatewayCorsPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayCorsPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.corsProperties = mapped
    }

    /**
     * @param value Environment variables of Spring Cloud Gateway
     */
    @JvmName("ptgsdtnselcqhowh")
    public suspend fun environmentVariables(`value`: GatewayPropertiesEnvironmentVariablesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param argument Environment variables of Spring Cloud Gateway
     */
    @JvmName("eudrswxiigyhibrh")
    public suspend
    fun environmentVariables(argument: suspend GatewayPropertiesEnvironmentVariablesArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayPropertiesEnvironmentVariablesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param value Indicate if only https is allowed.
     */
    @JvmName("iwknbbptydxvhjmc")
    public suspend fun httpsOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsOnly = mapped
    }

    /**
     * @param value Indicates whether the Spring Cloud Gateway exposes endpoint.
     */
    @JvmName("tckxrotbiyhagkcw")
    public suspend fun `public`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`public` = mapped
    }

    /**
     * @param value The requested resource quantity for required CPU and Memory.
     */
    @JvmName("pnfrxsgokxgsuuew")
    public suspend fun resourceRequests(`value`: GatewayResourceRequestsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceRequests = mapped
    }

    /**
     * @param argument The requested resource quantity for required CPU and Memory.
     */
    @JvmName("euuueppbeluefiqr")
    public suspend
    fun resourceRequests(argument: suspend GatewayResourceRequestsArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayResourceRequestsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resourceRequests = mapped
    }

    /**
     * @param value Single sign-on related configuration
     */
    @JvmName("osttffmbyvyyggwf")
    public suspend fun ssoProperties(`value`: SsoPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssoProperties = mapped
    }

    /**
     * @param argument Single sign-on related configuration
     */
    @JvmName("ivptqeluudvjuhpu")
    public suspend fun ssoProperties(argument: suspend SsoPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SsoPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ssoProperties = mapped
    }

    internal fun build(): GatewayPropertiesArgs = GatewayPropertiesArgs(
        addonConfigs = addonConfigs,
        apiMetadataProperties = apiMetadataProperties,
        apmTypes = apmTypes,
        clientAuth = clientAuth,
        corsProperties = corsProperties,
        environmentVariables = environmentVariables,
        httpsOnly = httpsOnly,
        `public` = `public`,
        resourceRequests = resourceRequests,
        ssoProperties = ssoProperties,
    )
}
