@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GatewayPropertiesClientAuthArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.enums.GatewayCertificateVerification
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Client-Certification Authentication.
 * @property certificateVerification Whether to enable certificate verification or not
 * @property certificates Collection of certificate resource Ids in Azure Spring Apps.
 */
public data class GatewayPropertiesClientAuthArgs(
    public val certificateVerification: Output<Either<String, GatewayCertificateVerification>>? =
        null,
    public val certificates: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GatewayPropertiesClientAuthArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GatewayPropertiesClientAuthArgs =
        com.pulumi.azurenative.appplatform.inputs.GatewayPropertiesClientAuthArgs.builder()
            .certificateVerification(
                certificateVerification?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .certificates(certificates?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GatewayPropertiesClientAuthArgs].
 */
@PulumiTagMarker
public class GatewayPropertiesClientAuthArgsBuilder internal constructor() {
    private var certificateVerification: Output<Either<String, GatewayCertificateVerification>>? =
        null

    private var certificates: Output<List<String>>? = null

    /**
     * @param value Whether to enable certificate verification or not
     */
    @JvmName("eyvsheidpjjeqyiw")
    public suspend
    fun certificateVerification(`value`: Output<Either<String, GatewayCertificateVerification>>) {
        this.certificateVerification = value
    }

    /**
     * @param value Collection of certificate resource Ids in Azure Spring Apps.
     */
    @JvmName("lkierbnwjetufpqo")
    public suspend fun certificates(`value`: Output<List<String>>) {
        this.certificates = value
    }

    @JvmName("wpfhahulbpdsltfa")
    public suspend fun certificates(vararg values: Output<String>) {
        this.certificates = Output.all(values.asList())
    }

    /**
     * @param values Collection of certificate resource Ids in Azure Spring Apps.
     */
    @JvmName("hxttrrtaixjcnmla")
    public suspend fun certificates(values: List<Output<String>>) {
        this.certificates = Output.all(values)
    }

    /**
     * @param value Whether to enable certificate verification or not
     */
    @JvmName("ugdfnporxvnabuep")
    public suspend
    fun certificateVerification(`value`: Either<String, GatewayCertificateVerification>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateVerification = mapped
    }

    /**
     * @param value Whether to enable certificate verification or not
     */
    @JvmName("rqsrqkqxocyudmxn")
    public fun certificateVerification(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GatewayCertificateVerification>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateVerification = mapped
    }

    /**
     * @param value Whether to enable certificate verification or not
     */
    @JvmName("ejvxhscwkfkawmsd")
    public fun certificateVerification(`value`: GatewayCertificateVerification) {
        val toBeMapped = Either.ofRight<String, GatewayCertificateVerification>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateVerification = mapped
    }

    /**
     * @param value Collection of certificate resource Ids in Azure Spring Apps.
     */
    @JvmName("lkkvpqbhrjbsuqxu")
    public suspend fun certificates(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param values Collection of certificate resource Ids in Azure Spring Apps.
     */
    @JvmName("qftjirkxvabpcara")
    public suspend fun certificates(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    internal fun build(): GatewayPropertiesClientAuthArgs = GatewayPropertiesClientAuthArgs(
        certificateVerification = certificateVerification,
        certificates = certificates,
    )
}
