@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GatewayRouteConfigPropertiesArgs.builder
import com.pulumi.azurenative.appplatform.kotlin.enums.GatewayRouteConfigProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * API route config of the Spring Cloud Gateway
 * @property appResourceId The resource Id of the Azure Spring Apps app, required unless route defines `uri`.
 * @property filters To modify the request before sending it to the target endpoint, or the received response in app level.
 * @property openApi OpenAPI properties of Spring Cloud Gateway route config.
 * @property predicates A number of conditions to evaluate a route for each request in app level. Each predicate may be evaluated against request headers and parameter values. All of the predicates associated with a route must evaluate to true for the route to be matched to the request.
 * @property protocol Protocol of routed Azure Spring Apps applications.
 * @property routes Array of API routes, each route contains properties such as `title`, `uri`, `ssoEnabled`, `predicates`, `filters`.
 * @property ssoEnabled Enable Single Sign-On in app level.
 */
public data class GatewayRouteConfigPropertiesArgs(
    public val appResourceId: Output<String>? = null,
    public val filters: Output<List<String>>? = null,
    public val openApi: Output<GatewayRouteConfigOpenApiPropertiesArgs>? = null,
    public val predicates: Output<List<String>>? = null,
    public val protocol: Output<Either<String, GatewayRouteConfigProtocol>>? = null,
    public val routes: Output<List<GatewayApiRouteArgs>>? = null,
    public val ssoEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GatewayRouteConfigPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GatewayRouteConfigPropertiesArgs =
        com.pulumi.azurenative.appplatform.inputs.GatewayRouteConfigPropertiesArgs.builder()
            .appResourceId(appResourceId?.applyValue({ args0 -> args0 }))
            .filters(filters?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .openApi(openApi?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .predicates(predicates?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .routes(routes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .ssoEnabled(ssoEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayRouteConfigPropertiesArgs].
 */
@PulumiTagMarker
public class GatewayRouteConfigPropertiesArgsBuilder internal constructor() {
    private var appResourceId: Output<String>? = null

    private var filters: Output<List<String>>? = null

    private var openApi: Output<GatewayRouteConfigOpenApiPropertiesArgs>? = null

    private var predicates: Output<List<String>>? = null

    private var protocol: Output<Either<String, GatewayRouteConfigProtocol>>? = null

    private var routes: Output<List<GatewayApiRouteArgs>>? = null

    private var ssoEnabled: Output<Boolean>? = null

    /**
     * @param value The resource Id of the Azure Spring Apps app, required unless route defines `uri`.
     */
    @JvmName("vhhwnokhagxddsvq")
    public suspend fun appResourceId(`value`: Output<String>) {
        this.appResourceId = value
    }

    /**
     * @param value To modify the request before sending it to the target endpoint, or the received response in app level.
     */
    @JvmName("eddnxttyfgfpffrc")
    public suspend fun filters(`value`: Output<List<String>>) {
        this.filters = value
    }

    @JvmName("yqbgtwjotpxscavq")
    public suspend fun filters(vararg values: Output<String>) {
        this.filters = Output.all(values.asList())
    }

    /**
     * @param values To modify the request before sending it to the target endpoint, or the received response in app level.
     */
    @JvmName("ngnxylkyidjvwuil")
    public suspend fun filters(values: List<Output<String>>) {
        this.filters = Output.all(values)
    }

    /**
     * @param value OpenAPI properties of Spring Cloud Gateway route config.
     */
    @JvmName("peukidtpuwhxwicu")
    public suspend fun openApi(`value`: Output<GatewayRouteConfigOpenApiPropertiesArgs>) {
        this.openApi = value
    }

    /**
     * @param value A number of conditions to evaluate a route for each request in app level. Each predicate may be evaluated against request headers and parameter values. All of the predicates associated with a route must evaluate to true for the route to be matched to the request.
     */
    @JvmName("hrrhavcsmrmieycs")
    public suspend fun predicates(`value`: Output<List<String>>) {
        this.predicates = value
    }

    @JvmName("vebbcjigmuwhhqgr")
    public suspend fun predicates(vararg values: Output<String>) {
        this.predicates = Output.all(values.asList())
    }

    /**
     * @param values A number of conditions to evaluate a route for each request in app level. Each predicate may be evaluated against request headers and parameter values. All of the predicates associated with a route must evaluate to true for the route to be matched to the request.
     */
    @JvmName("scibmcqrexriilcp")
    public suspend fun predicates(values: List<Output<String>>) {
        this.predicates = Output.all(values)
    }

    /**
     * @param value Protocol of routed Azure Spring Apps applications.
     */
    @JvmName("nxbtrbsmaxhgstuk")
    public suspend fun protocol(`value`: Output<Either<String, GatewayRouteConfigProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value Array of API routes, each route contains properties such as `title`, `uri`, `ssoEnabled`, `predicates`, `filters`.
     */
    @JvmName("idmcnxaffbvpvuxq")
    public suspend fun routes(`value`: Output<List<GatewayApiRouteArgs>>) {
        this.routes = value
    }

    @JvmName("gwtpbbnglblpfhjk")
    public suspend fun routes(vararg values: Output<GatewayApiRouteArgs>) {
        this.routes = Output.all(values.asList())
    }

    /**
     * @param values Array of API routes, each route contains properties such as `title`, `uri`, `ssoEnabled`, `predicates`, `filters`.
     */
    @JvmName("evtguttjmruxudjg")
    public suspend fun routes(values: List<Output<GatewayApiRouteArgs>>) {
        this.routes = Output.all(values)
    }

    /**
     * @param value Enable Single Sign-On in app level.
     */
    @JvmName("keaxoktjxfadnfde")
    public suspend fun ssoEnabled(`value`: Output<Boolean>) {
        this.ssoEnabled = value
    }

    /**
     * @param value The resource Id of the Azure Spring Apps app, required unless route defines `uri`.
     */
    @JvmName("nembncmysekspslq")
    public suspend fun appResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appResourceId = mapped
    }

    /**
     * @param value To modify the request before sending it to the target endpoint, or the received response in app level.
     */
    @JvmName("hlairknaxcbmtuyb")
    public suspend fun filters(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param values To modify the request before sending it to the target endpoint, or the received response in app level.
     */
    @JvmName("rjimsamajdvoiaoc")
    public suspend fun filters(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param value OpenAPI properties of Spring Cloud Gateway route config.
     */
    @JvmName("fumcscfujsbpblmf")
    public suspend fun openApi(`value`: GatewayRouteConfigOpenApiPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openApi = mapped
    }

    /**
     * @param argument OpenAPI properties of Spring Cloud Gateway route config.
     */
    @JvmName("yvomcjihylmvinlx")
    public suspend
    fun openApi(argument: suspend GatewayRouteConfigOpenApiPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayRouteConfigOpenApiPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.openApi = mapped
    }

    /**
     * @param value A number of conditions to evaluate a route for each request in app level. Each predicate may be evaluated against request headers and parameter values. All of the predicates associated with a route must evaluate to true for the route to be matched to the request.
     */
    @JvmName("hfcdeofoktedbmov")
    public suspend fun predicates(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.predicates = mapped
    }

    /**
     * @param values A number of conditions to evaluate a route for each request in app level. Each predicate may be evaluated against request headers and parameter values. All of the predicates associated with a route must evaluate to true for the route to be matched to the request.
     */
    @JvmName("gcksspvcuadimvpf")
    public suspend fun predicates(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.predicates = mapped
    }

    /**
     * @param value Protocol of routed Azure Spring Apps applications.
     */
    @JvmName("yqewlormlwkkmxnr")
    public suspend fun protocol(`value`: Either<String, GatewayRouteConfigProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol of routed Azure Spring Apps applications.
     */
    @JvmName("pbjqvaaahruffwwl")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GatewayRouteConfigProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol of routed Azure Spring Apps applications.
     */
    @JvmName("hubsavtlvkhqthia")
    public fun protocol(`value`: GatewayRouteConfigProtocol) {
        val toBeMapped = Either.ofRight<String, GatewayRouteConfigProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Array of API routes, each route contains properties such as `title`, `uri`, `ssoEnabled`, `predicates`, `filters`.
     */
    @JvmName("gcpvxqwnnachiyif")
    public suspend fun routes(`value`: List<GatewayApiRouteArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param argument Array of API routes, each route contains properties such as `title`, `uri`, `ssoEnabled`, `predicates`, `filters`.
     */
    @JvmName("wmfyxeenvagjldws")
    public suspend fun routes(argument: List<suspend GatewayApiRouteArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GatewayApiRouteArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument Array of API routes, each route contains properties such as `title`, `uri`, `ssoEnabled`, `predicates`, `filters`.
     */
    @JvmName("jqqrtbrrdrtvluqp")
    public suspend fun routes(vararg argument: suspend GatewayApiRouteArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GatewayApiRouteArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument Array of API routes, each route contains properties such as `title`, `uri`, `ssoEnabled`, `predicates`, `filters`.
     */
    @JvmName("ceddfybjtwgokbke")
    public suspend fun routes(argument: suspend GatewayApiRouteArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GatewayApiRouteArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param values Array of API routes, each route contains properties such as `title`, `uri`, `ssoEnabled`, `predicates`, `filters`.
     */
    @JvmName("rxpdbxddlhnximde")
    public suspend fun routes(vararg values: GatewayApiRouteArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param value Enable Single Sign-On in app level.
     */
    @JvmName("fmjmlybthspevprn")
    public suspend fun ssoEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssoEnabled = mapped
    }

    internal fun build(): GatewayRouteConfigPropertiesArgs = GatewayRouteConfigPropertiesArgs(
        appResourceId = appResourceId,
        filters = filters,
        openApi = openApi,
        predicates = predicates,
        protocol = protocol,
        routes = routes,
        ssoEnabled = ssoEnabled,
    )
}
