@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GetApplicationLiveViewPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationLiveViewName The name of Application Live View.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class GetApplicationLiveViewPlainArgs(
    public val applicationLiveViewName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GetApplicationLiveViewPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GetApplicationLiveViewPlainArgs =
        com.pulumi.azurenative.appplatform.inputs.GetApplicationLiveViewPlainArgs.builder()
            .applicationLiveViewName(applicationLiveViewName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationLiveViewPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationLiveViewPlainArgsBuilder internal constructor() {
    private var applicationLiveViewName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value The name of Application Live View.
     */
    @JvmName("shnydiawpprngxek")
    public suspend fun applicationLiveViewName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationLiveViewName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("brihqdqfxvkjhvkp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("cyhoyrdjtlnpugbm")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetApplicationLiveViewPlainArgs = GetApplicationLiveViewPlainArgs(
        applicationLiveViewName = applicationLiveViewName ?: throw
            PulumiNullFieldException("applicationLiveViewName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
