@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GetBuildServiceAgentPoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property agentPoolName The name of the build service agent pool resource.
 * @property buildServiceName The name of the build service resource.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class GetBuildServiceAgentPoolPlainArgs(
    public val agentPoolName: String,
    public val buildServiceName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GetBuildServiceAgentPoolPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GetBuildServiceAgentPoolPlainArgs =
        com.pulumi.azurenative.appplatform.inputs.GetBuildServiceAgentPoolPlainArgs.builder()
            .agentPoolName(agentPoolName.let({ args0 -> args0 }))
            .buildServiceName(buildServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBuildServiceAgentPoolPlainArgs].
 */
@PulumiTagMarker
public class GetBuildServiceAgentPoolPlainArgsBuilder internal constructor() {
    private var agentPoolName: String? = null

    private var buildServiceName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value The name of the build service agent pool resource.
     */
    @JvmName("ktijmkxicgvmeyci")
    public suspend fun agentPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.agentPoolName = mapped
    }

    /**
     * @param value The name of the build service resource.
     */
    @JvmName("xjgxtcspainwropb")
    public suspend fun buildServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.buildServiceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("kysjotoomobimtey")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("qpkrbniuscgsmatd")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetBuildServiceAgentPoolPlainArgs = GetBuildServiceAgentPoolPlainArgs(
        agentPoolName = agentPoolName ?: throw PulumiNullFieldException("agentPoolName"),
        buildServiceName = buildServiceName ?: throw PulumiNullFieldException("buildServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
