@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GetGatewayCustomDomainPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainName The name of the Spring Cloud Gateway custom domain.
 * @property gatewayName The name of Spring Cloud Gateway.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serviceName The name of the Service resource.
 */
public data class GetGatewayCustomDomainPlainArgs(
    public val domainName: String,
    public val gatewayName: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GetGatewayCustomDomainPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GetGatewayCustomDomainPlainArgs =
        com.pulumi.azurenative.appplatform.inputs.GetGatewayCustomDomainPlainArgs.builder()
            .domainName(domainName.let({ args0 -> args0 }))
            .gatewayName(gatewayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGatewayCustomDomainPlainArgs].
 */
@PulumiTagMarker
public class GetGatewayCustomDomainPlainArgsBuilder internal constructor() {
    private var domainName: String? = null

    private var gatewayName: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value The name of the Spring Cloud Gateway custom domain.
     */
    @JvmName("ercvepidggwmtllt")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value The name of Spring Cloud Gateway.
     */
    @JvmName("tbgmoujtsuyoqbem")
    public suspend fun gatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.gatewayName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("hiaotftmlncxbsiw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("sohbgnfeehdaahly")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetGatewayCustomDomainPlainArgs = GetGatewayCustomDomainPlainArgs(
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        gatewayName = gatewayName ?: throw PulumiNullFieldException("gatewayName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
