@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.GetGatewayRouteConfigPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property gatewayName The name of Spring Cloud Gateway.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property routeConfigName The name of the Spring Cloud Gateway route config.
 * @property serviceName The name of the Service resource.
 */
public data class GetGatewayRouteConfigPlainArgs(
    public val gatewayName: String,
    public val resourceGroupName: String,
    public val routeConfigName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.GetGatewayRouteConfigPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.GetGatewayRouteConfigPlainArgs =
        com.pulumi.azurenative.appplatform.inputs.GetGatewayRouteConfigPlainArgs.builder()
            .gatewayName(gatewayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .routeConfigName(routeConfigName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGatewayRouteConfigPlainArgs].
 */
@PulumiTagMarker
public class GetGatewayRouteConfigPlainArgsBuilder internal constructor() {
    private var gatewayName: String? = null

    private var resourceGroupName: String? = null

    private var routeConfigName: String? = null

    private var serviceName: String? = null

    /**
     * @param value The name of Spring Cloud Gateway.
     */
    @JvmName("gciypgmewagidgly")
    public suspend fun gatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.gatewayName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("sfkjaibtvccrgpms")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Spring Cloud Gateway route config.
     */
    @JvmName("mpovnfdixraocqbw")
    public suspend fun routeConfigName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.routeConfigName = mapped
    }

    /**
     * @param value The name of the Service resource.
     */
    @JvmName("ixjogdneeeejmucs")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetGatewayRouteConfigPlainArgs = GetGatewayRouteConfigPlainArgs(
        gatewayName = gatewayName ?: throw PulumiNullFieldException("gatewayName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        routeConfigName = routeConfigName ?: throw PulumiNullFieldException("routeConfigName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
