@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.IngressSettingsClientAuthArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Client-Certification Authentication.
 * @property certificates Collection of certificate resource id.
 */
public data class IngressSettingsClientAuthArgs(
    public val certificates: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.IngressSettingsClientAuthArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.IngressSettingsClientAuthArgs =
        com.pulumi.azurenative.appplatform.inputs.IngressSettingsClientAuthArgs.builder()
            .certificates(certificates?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [IngressSettingsClientAuthArgs].
 */
@PulumiTagMarker
public class IngressSettingsClientAuthArgsBuilder internal constructor() {
    private var certificates: Output<List<String>>? = null

    /**
     * @param value Collection of certificate resource id.
     */
    @JvmName("tniuqcjguncletni")
    public suspend fun certificates(`value`: Output<List<String>>) {
        this.certificates = value
    }

    @JvmName("pgvdetuptbwtwosd")
    public suspend fun certificates(vararg values: Output<String>) {
        this.certificates = Output.all(values.asList())
    }

    /**
     * @param values Collection of certificate resource id.
     */
    @JvmName("mscjryiikangnjek")
    public suspend fun certificates(values: List<Output<String>>) {
        this.certificates = Output.all(values)
    }

    /**
     * @param value Collection of certificate resource id.
     */
    @JvmName("neyjfkidpnbtgelm")
    public suspend fun certificates(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param values Collection of certificate resource id.
     */
    @JvmName("ktgbkxpgumctbmyg")
    public suspend fun certificates(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    internal fun build(): IngressSettingsClientAuthArgs = IngressSettingsClientAuthArgs(
        certificates = certificates,
    )
}
