@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.NetworkProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Service network profile payload
 * @property appNetworkResourceGroup Name of the resource group containing network resources for customer apps in Azure Spring Apps
 * @property appSubnetId Fully qualified resource Id of the subnet to host customer apps in Azure Spring Apps
 * @property ingressConfig Ingress configuration payload for Azure Spring Apps resource.
 * @property outboundType The egress traffic type of Azure Spring Apps VNet instances.
 * @property serviceCidr Azure Spring Apps service reserved CIDR
 * @property serviceRuntimeNetworkResourceGroup Name of the resource group containing network resources of Azure Spring Apps Service Runtime
 * @property serviceRuntimeSubnetId Fully qualified resource Id of the subnet to host Azure Spring Apps Service Runtime
 */
public data class NetworkProfileArgs(
    public val appNetworkResourceGroup: Output<String>? = null,
    public val appSubnetId: Output<String>? = null,
    public val ingressConfig: Output<IngressConfigArgs>? = null,
    public val outboundType: Output<String>? = null,
    public val serviceCidr: Output<String>? = null,
    public val serviceRuntimeNetworkResourceGroup: Output<String>? = null,
    public val serviceRuntimeSubnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.NetworkProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.NetworkProfileArgs =
        com.pulumi.azurenative.appplatform.inputs.NetworkProfileArgs.builder()
            .appNetworkResourceGroup(appNetworkResourceGroup?.applyValue({ args0 -> args0 }))
            .appSubnetId(appSubnetId?.applyValue({ args0 -> args0 }))
            .ingressConfig(ingressConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .outboundType(outboundType?.applyValue({ args0 -> args0 }))
            .serviceCidr(serviceCidr?.applyValue({ args0 -> args0 }))
            .serviceRuntimeNetworkResourceGroup(
                serviceRuntimeNetworkResourceGroup?.applyValue({ args0 ->
                    args0
                }),
            )
            .serviceRuntimeSubnetId(serviceRuntimeSubnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkProfileArgs].
 */
@PulumiTagMarker
public class NetworkProfileArgsBuilder internal constructor() {
    private var appNetworkResourceGroup: Output<String>? = null

    private var appSubnetId: Output<String>? = null

    private var ingressConfig: Output<IngressConfigArgs>? = null

    private var outboundType: Output<String>? = null

    private var serviceCidr: Output<String>? = null

    private var serviceRuntimeNetworkResourceGroup: Output<String>? = null

    private var serviceRuntimeSubnetId: Output<String>? = null

    /**
     * @param value Name of the resource group containing network resources for customer apps in Azure Spring Apps
     */
    @JvmName("ugsrbnncgtsubnug")
    public suspend fun appNetworkResourceGroup(`value`: Output<String>) {
        this.appNetworkResourceGroup = value
    }

    /**
     * @param value Fully qualified resource Id of the subnet to host customer apps in Azure Spring Apps
     */
    @JvmName("jwslrryjwrfhxqxd")
    public suspend fun appSubnetId(`value`: Output<String>) {
        this.appSubnetId = value
    }

    /**
     * @param value Ingress configuration payload for Azure Spring Apps resource.
     */
    @JvmName("wgirixmlnmdntouw")
    public suspend fun ingressConfig(`value`: Output<IngressConfigArgs>) {
        this.ingressConfig = value
    }

    /**
     * @param value The egress traffic type of Azure Spring Apps VNet instances.
     */
    @JvmName("kucaajwendvxfyyn")
    public suspend fun outboundType(`value`: Output<String>) {
        this.outboundType = value
    }

    /**
     * @param value Azure Spring Apps service reserved CIDR
     */
    @JvmName("qvwjgnsfcvtyleww")
    public suspend fun serviceCidr(`value`: Output<String>) {
        this.serviceCidr = value
    }

    /**
     * @param value Name of the resource group containing network resources of Azure Spring Apps Service Runtime
     */
    @JvmName("juaallogtkhigruj")
    public suspend fun serviceRuntimeNetworkResourceGroup(`value`: Output<String>) {
        this.serviceRuntimeNetworkResourceGroup = value
    }

    /**
     * @param value Fully qualified resource Id of the subnet to host Azure Spring Apps Service Runtime
     */
    @JvmName("axhqqmkanwcpwhse")
    public suspend fun serviceRuntimeSubnetId(`value`: Output<String>) {
        this.serviceRuntimeSubnetId = value
    }

    /**
     * @param value Name of the resource group containing network resources for customer apps in Azure Spring Apps
     */
    @JvmName("rbdxgqvfknpdxapr")
    public suspend fun appNetworkResourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appNetworkResourceGroup = mapped
    }

    /**
     * @param value Fully qualified resource Id of the subnet to host customer apps in Azure Spring Apps
     */
    @JvmName("bxfyedgbdfwooolf")
    public suspend fun appSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appSubnetId = mapped
    }

    /**
     * @param value Ingress configuration payload for Azure Spring Apps resource.
     */
    @JvmName("bduidibyfisirjxq")
    public suspend fun ingressConfig(`value`: IngressConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingressConfig = mapped
    }

    /**
     * @param argument Ingress configuration payload for Azure Spring Apps resource.
     */
    @JvmName("vajhcpaqgvurweju")
    public suspend fun ingressConfig(argument: suspend IngressConfigArgsBuilder.() -> Unit) {
        val toBeMapped = IngressConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ingressConfig = mapped
    }

    /**
     * @param value The egress traffic type of Azure Spring Apps VNet instances.
     */
    @JvmName("ssuurifpteasabvp")
    public suspend fun outboundType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outboundType = mapped
    }

    /**
     * @param value Azure Spring Apps service reserved CIDR
     */
    @JvmName("vbbjyfcgjpomsdug")
    public suspend fun serviceCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceCidr = mapped
    }

    /**
     * @param value Name of the resource group containing network resources of Azure Spring Apps Service Runtime
     */
    @JvmName("asmuqfcbtosjqhhm")
    public suspend fun serviceRuntimeNetworkResourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceRuntimeNetworkResourceGroup = mapped
    }

    /**
     * @param value Fully qualified resource Id of the subnet to host Azure Spring Apps Service Runtime
     */
    @JvmName("voaeshdtusxabumg")
    public suspend fun serviceRuntimeSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceRuntimeSubnetId = mapped
    }

    internal fun build(): NetworkProfileArgs = NetworkProfileArgs(
        appNetworkResourceGroup = appNetworkResourceGroup,
        appSubnetId = appSubnetId,
        ingressConfig = ingressConfig,
        outboundType = outboundType,
        serviceCidr = serviceCidr,
        serviceRuntimeNetworkResourceGroup = serviceRuntimeNetworkResourceGroup,
        serviceRuntimeSubnetId = serviceRuntimeSubnetId,
    )
}
