@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.SourceUploadedUserSourceInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Uploaded Java source code binary for a deployment
 * @property artifactSelector Selector for the artifact to be used for the deployment for multi-module projects. This should be
 * the relative path to the target module/project.
 * @property relativePath Relative path of the storage which stores the source
 * @property runtimeVersion Runtime version of the source file
 * @property type Type of the source uploaded
 * Expected value is 'Source'.
 * @property version Version of the source
 */
public data class SourceUploadedUserSourceInfoArgs(
    public val artifactSelector: Output<String>? = null,
    public val relativePath: Output<String>? = null,
    public val runtimeVersion: Output<String>? = null,
    public val type: Output<String>,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.SourceUploadedUserSourceInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.SourceUploadedUserSourceInfoArgs =
        com.pulumi.azurenative.appplatform.inputs.SourceUploadedUserSourceInfoArgs.builder()
            .artifactSelector(artifactSelector?.applyValue({ args0 -> args0 }))
            .relativePath(relativePath?.applyValue({ args0 -> args0 }))
            .runtimeVersion(runtimeVersion?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SourceUploadedUserSourceInfoArgs].
 */
@PulumiTagMarker
public class SourceUploadedUserSourceInfoArgsBuilder internal constructor() {
    private var artifactSelector: Output<String>? = null

    private var relativePath: Output<String>? = null

    private var runtimeVersion: Output<String>? = null

    private var type: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Selector for the artifact to be used for the deployment for multi-module projects. This should be
     * the relative path to the target module/project.
     */
    @JvmName("pevjsuleyhtnphky")
    public suspend fun artifactSelector(`value`: Output<String>) {
        this.artifactSelector = value
    }

    /**
     * @param value Relative path of the storage which stores the source
     */
    @JvmName("xxfdkwxabosjgjnu")
    public suspend fun relativePath(`value`: Output<String>) {
        this.relativePath = value
    }

    /**
     * @param value Runtime version of the source file
     */
    @JvmName("vmqfadjyqodqyeou")
    public suspend fun runtimeVersion(`value`: Output<String>) {
        this.runtimeVersion = value
    }

    /**
     * @param value Type of the source uploaded
     * Expected value is 'Source'.
     */
    @JvmName("wgnpxebyuvpsvmpu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Version of the source
     */
    @JvmName("laesfosrfgaufbol")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Selector for the artifact to be used for the deployment for multi-module projects. This should be
     * the relative path to the target module/project.
     */
    @JvmName("wgqmfqoaxedcrajn")
    public suspend fun artifactSelector(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactSelector = mapped
    }

    /**
     * @param value Relative path of the storage which stores the source
     */
    @JvmName("isfxdkbmpjyhmsom")
    public suspend fun relativePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relativePath = mapped
    }

    /**
     * @param value Runtime version of the source file
     */
    @JvmName("rnrumeyqxerujtds")
    public suspend fun runtimeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeVersion = mapped
    }

    /**
     * @param value Type of the source uploaded
     * Expected value is 'Source'.
     */
    @JvmName("htesbbjkqsfxjyrq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Version of the source
     */
    @JvmName("fbpafwgevjqjxthf")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): SourceUploadedUserSourceInfoArgs = SourceUploadedUserSourceInfoArgs(
        artifactSelector = artifactSelector,
        relativePath = relativePath,
        runtimeVersion = runtimeVersion,
        type = type ?: throw PulumiNullFieldException("type"),
        version = version,
    )
}
