@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.TcpScaleRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure Spring Apps App Instance Tcp scaling rule.
 * @property auth Authentication secrets for the tcp scale rule.
 * @property metadata Metadata properties to describe tcp scale rule.
 */
public data class TcpScaleRuleArgs(
    public val auth: Output<List<ScaleRuleAuthArgs>>? = null,
    public val metadata: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.TcpScaleRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.TcpScaleRuleArgs =
        com.pulumi.azurenative.appplatform.inputs.TcpScaleRuleArgs.builder()
            .auth(auth?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [TcpScaleRuleArgs].
 */
@PulumiTagMarker
public class TcpScaleRuleArgsBuilder internal constructor() {
    private var auth: Output<List<ScaleRuleAuthArgs>>? = null

    private var metadata: Output<Map<String, String>>? = null

    /**
     * @param value Authentication secrets for the tcp scale rule.
     */
    @JvmName("oosryahcalnlchar")
    public suspend fun auth(`value`: Output<List<ScaleRuleAuthArgs>>) {
        this.auth = value
    }

    @JvmName("rmvwsafsriakapck")
    public suspend fun auth(vararg values: Output<ScaleRuleAuthArgs>) {
        this.auth = Output.all(values.asList())
    }

    /**
     * @param values Authentication secrets for the tcp scale rule.
     */
    @JvmName("bkwpnjdfjnubfdit")
    public suspend fun auth(values: List<Output<ScaleRuleAuthArgs>>) {
        this.auth = Output.all(values)
    }

    /**
     * @param value Metadata properties to describe tcp scale rule.
     */
    @JvmName("pkpsoruioludfajv")
    public suspend fun metadata(`value`: Output<Map<String, String>>) {
        this.metadata = value
    }

    /**
     * @param value Authentication secrets for the tcp scale rule.
     */
    @JvmName("xbawnikhvrdtshxa")
    public suspend fun auth(`value`: List<ScaleRuleAuthArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auth = mapped
    }

    /**
     * @param argument Authentication secrets for the tcp scale rule.
     */
    @JvmName("qdsgqqcqrdaqjjup")
    public suspend fun auth(argument: List<suspend ScaleRuleAuthArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScaleRuleAuthArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.auth = mapped
    }

    /**
     * @param argument Authentication secrets for the tcp scale rule.
     */
    @JvmName("wghfepsbobkahxwm")
    public suspend fun auth(vararg argument: suspend ScaleRuleAuthArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScaleRuleAuthArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.auth = mapped
    }

    /**
     * @param argument Authentication secrets for the tcp scale rule.
     */
    @JvmName("krydlwpbdeeqfntq")
    public suspend fun auth(argument: suspend ScaleRuleAuthArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ScaleRuleAuthArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.auth = mapped
    }

    /**
     * @param values Authentication secrets for the tcp scale rule.
     */
    @JvmName("sjsqkscciybvyhqb")
    public suspend fun auth(vararg values: ScaleRuleAuthArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.auth = mapped
    }

    /**
     * @param value Metadata properties to describe tcp scale rule.
     */
    @JvmName("wlybidtmcwejells")
    public suspend fun metadata(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param values Metadata properties to describe tcp scale rule.
     */
    @JvmName("efsvonxcqpnwdihs")
    public fun metadata(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    internal fun build(): TcpScaleRuleArgs = TcpScaleRuleArgs(
        auth = auth,
        metadata = metadata,
    )
}
