@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * App resource properties payload
 * @property addonConfigs Collection of addons
 * @property customPersistentDisks List of custom persistent disks
 * @property enableEndToEndTLS Indicate if end to end TLS is enabled.
 * @property fqdn Fully qualified dns Name.
 * @property httpsOnly Indicate if only https is allowed.
 * @property ingressSettings App ingress settings payload.
 * @property loadedCertificates Collection of loaded certificates
 * @property persistentDisk Persistent disk settings
 * @property provisioningState Provisioning state of the App
 * @property public Indicates whether the App exposes public endpoint
 * @property secrets Collection of auth secrets
 * @property temporaryDisk Temporary disk settings
 * @property url URL of the App
 * @property vnetAddons Additional App settings in vnet injection instance
 * @property workloadProfileName The workload profile used for this app. Supported for Consumption + Dedicated plan.
 */
public data class AppResourcePropertiesResponse(
    public val addonConfigs: Map<String, Any>? = null,
    public val customPersistentDisks: List<CustomPersistentDiskResourceResponse>? = null,
    public val enableEndToEndTLS: Boolean? = null,
    public val fqdn: String,
    public val httpsOnly: Boolean? = null,
    public val ingressSettings: IngressSettingsResponse? = null,
    public val loadedCertificates: List<LoadedCertificateResponse>? = null,
    public val persistentDisk: PersistentDiskResponse? = null,
    public val provisioningState: String,
    public val `public`: Boolean? = null,
    public val secrets: List<SecretResponse>? = null,
    public val temporaryDisk: TemporaryDiskResponse? = null,
    public val url: String,
    public val vnetAddons: AppVNetAddonsResponse? = null,
    public val workloadProfileName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.AppResourcePropertiesResponse):
            AppResourcePropertiesResponse = AppResourcePropertiesResponse(
            addonConfigs = javaType.addonConfigs().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            customPersistentDisks = javaType.customPersistentDisks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.CustomPersistentDiskResourceResponse.Companion.toKotlin(args0)
                })
            }),
            enableEndToEndTLS = javaType.enableEndToEndTLS().map({ args0 -> args0 }).orElse(null),
            fqdn = javaType.fqdn(),
            httpsOnly = javaType.httpsOnly().map({ args0 -> args0 }).orElse(null),
            ingressSettings = javaType.ingressSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.IngressSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            loadedCertificates = javaType.loadedCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.LoadedCertificateResponse.Companion.toKotlin(args0)
                })
            }),
            persistentDisk = javaType.persistentDisk().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.PersistentDiskResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            `public` = javaType.public_().map({ args0 -> args0 }).orElse(null),
            secrets = javaType.secrets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.SecretResponse.Companion.toKotlin(args0)
                })
            }),
            temporaryDisk = javaType.temporaryDisk().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.TemporaryDiskResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            url = javaType.url(),
            vnetAddons = javaType.vnetAddons().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.AppVNetAddonsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            workloadProfileName = javaType.workloadProfileName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
