@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Deployment resource properties payload
 * @property active Indicates whether the Deployment is active
 * @property deploymentSettings Deployment settings of the Deployment
 * @property instances Collection of instances belong to the Deployment
 * @property provisioningState Provisioning state of the Deployment
 * @property source Uploaded source information of the deployment.
 * @property status Status of the Deployment
 */
public data class DeploymentResourcePropertiesResponse(
    public val active: Boolean? = null,
    public val deploymentSettings: DeploymentSettingsResponse? = null,
    public val instances: List<DeploymentInstanceResponse>,
    public val provisioningState: String,
    public val source: Any? = null,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.DeploymentResourcePropertiesResponse):
            DeploymentResourcePropertiesResponse = DeploymentResourcePropertiesResponse(
            active = javaType.active().map({ args0 -> args0 }).orElse(null),
            deploymentSettings = javaType.deploymentSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.DeploymentSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.DeploymentInstanceResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
        )
    }
}
