@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Environment variables of Spring Cloud Gateway
 * @property properties Non-sensitive properties
 * @property secrets Sensitive properties
 */
public data class GatewayPropertiesResponseEnvironmentVariables(
    public val properties: Map<String, String>? = null,
    public val secrets: Map<String, String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.GatewayPropertiesResponseEnvironmentVariables):
            GatewayPropertiesResponseEnvironmentVariables =
            GatewayPropertiesResponseEnvironmentVariables(
                properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                secrets = javaType.secrets().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
