@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Resource request payload of Spring Cloud Gateway.
 * @property cpu Cpu allocated to each Spring Cloud Gateway instance.
 * @property memory Memory allocated to each Spring Cloud Gateway instance.
 */
public data class GatewayResourceRequestsResponse(
    public val cpu: String? = null,
    public val memory: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.GatewayResourceRequestsResponse):
            GatewayResourceRequestsResponse = GatewayResourceRequestsResponse(
            cpu = javaType.cpu().map({ args0 -> args0 }).orElse(null),
            memory = javaType.memory().map({ args0 -> args0 }).orElse(null),
        )
    }
}
