@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Ingress configuration payload for Azure Spring Apps resource.
 * @property readTimeoutInSeconds Ingress read time out in seconds.
 */
public data class IngressConfigResponse(
    public val readTimeoutInSeconds: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.IngressConfigResponse):
            IngressConfigResponse = IngressConfigResponse(
            readTimeoutInSeconds = javaType.readTimeoutInSeconds().map({ args0 -> args0 }).orElse(null),
        )
    }
}
