@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * App ingress settings payload.
 * @property backendProtocol How ingress should communicate with this app backend service.
 * @property clientAuth Client-Certification Authentication.
 * @property readTimeoutInSeconds Ingress read time out in seconds.
 * @property sendTimeoutInSeconds Ingress send time out in seconds.
 * @property sessionAffinity Type of the affinity, set this to Cookie to enable session affinity.
 * @property sessionCookieMaxAge Time in seconds until the cookie expires.
 */
public data class IngressSettingsResponse(
    public val backendProtocol: String? = null,
    public val clientAuth: IngressSettingsResponseClientAuth? = null,
    public val readTimeoutInSeconds: Int? = null,
    public val sendTimeoutInSeconds: Int? = null,
    public val sessionAffinity: String? = null,
    public val sessionCookieMaxAge: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.IngressSettingsResponse):
            IngressSettingsResponse = IngressSettingsResponse(
            backendProtocol = javaType.backendProtocol().map({ args0 -> args0 }).orElse(null),
            clientAuth = javaType.clientAuth().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.IngressSettingsResponseClientAuth.Companion.toKotlin(args0)
                })
            }).orElse(null),
            readTimeoutInSeconds = javaType.readTimeoutInSeconds().map({ args0 -> args0 }).orElse(null),
            sendTimeoutInSeconds = javaType.sendTimeoutInSeconds().map({ args0 -> args0 }).orElse(null),
            sessionAffinity = javaType.sessionAffinity().map({ args0 -> args0 }).orElse(null),
            sessionCookieMaxAge = javaType.sessionCookieMaxAge().map({ args0 -> args0 }).orElse(null),
        )
    }
}
