@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The details of the user-assigned managed identity assigned to an App.
 * @property clientId Client Id of user-assigned managed identity.
 * @property principalId Principal Id of user-assigned managed identity.
 */
public data class UserAssignedManagedIdentityResponse(
    public val clientId: String,
    public val principalId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.UserAssignedManagedIdentityResponse):
            UserAssignedManagedIdentityResponse = UserAssignedManagedIdentityResponse(
            clientId = javaType.clientId(),
            principalId = javaType.principalId(),
        )
    }
}
