@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.attestation.kotlin

import com.pulumi.azurenative.attestation.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.attestation.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.attestation.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.attestation.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AttestationProvider].
 */
@PulumiTagMarker
public class AttestationProviderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AttestationProviderArgs = AttestationProviderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AttestationProviderArgsBuilder.() -> Unit) {
        val builder = AttestationProviderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AttestationProvider {
        val builtJavaResource =
            com.pulumi.azurenative.attestation.AttestationProvider(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AttestationProvider(builtJavaResource)
    }
}

/**
 * Attestation service response message.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### AttestationProviders_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var attestationProvider = new AzureNative.Attestation.AttestationProvider("attestationProvider", new()
 *     {
 *         Location = "East US",
 *         Properties = new AzureNative.Attestation.Inputs.AttestationServiceCreationSpecificParamsArgs
 *         {
 *             PublicNetworkAccess = "Enabled",
 *             TpmAttestationAuthentication = "Enabled",
 *         },
 *         ProviderName = "myattestationprovider",
 *         ResourceGroupName = "MyResourceGroup",
 *         Tags =
 *         {
 *             { "Property1", "Value1" },
 *             { "Property2", "Value2" },
 *             { "Property3", "Value3" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/attestation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := attestation.NewAttestationProvider(ctx, "attestationProvider", &attestation.AttestationProviderArgs{
 * 			Location: pulumi.String("East US"),
 * 			Properties: &attestation.AttestationServiceCreationSpecificParamsArgs{
 * 				PublicNetworkAccess:          pulumi.String("Enabled"),
 * 				TpmAttestationAuthentication: pulumi.String("Enabled"),
 * 			},
 * 			ProviderName:      pulumi.String("myattestationprovider"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"Property1": pulumi.String("Value1"),
 * 				"Property2": pulumi.String("Value2"),
 * 				"Property3": pulumi.String("Value3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.attestation.AttestationProvider;
 * import com.pulumi.azurenative.attestation.AttestationProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var attestationProvider = new AttestationProvider("attestationProvider", AttestationProviderArgs.builder()
 *             .location("East US")
 *             .properties(Map.ofEntries(
 *                 Map.entry("publicNetworkAccess", "Enabled"),
 *                 Map.entry("tpmAttestationAuthentication", "Enabled")
 *             ))
 *             .providerName("myattestationprovider")
 *             .resourceGroupName("MyResourceGroup")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Property1", "Value1"),
 *                 Map.entry("Property2", "Value2"),
 *                 Map.entry("Property3", "Value3")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:attestation:AttestationProvider myattestationprovider /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Attestation/attestationProviders/{providerName}
 * ```
 */
public class AttestationProvider internal constructor(
    override val javaResource: com.pulumi.azurenative.attestation.AttestationProvider,
) : KotlinCustomResource(javaResource, AttestationProviderMapper) {
    /**
     * Gets the uri of attestation service
     */
    public val attestUri: Output<String>?
        get() = javaResource.attestUri().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of private endpoint connections associated with the attestation provider.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * Controls whether traffic from the public network is allowed to access the Attestation Provider APIs.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Status of attestation service.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The system metadata relating to this resource
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The setting that controls whether authentication is enabled or disabled for TPM Attestation REST APIs.
     */
    public val tpmAttestationAuthentication: Output<String>?
        get() = javaResource.tpmAttestationAuthentication().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Trust model for the attestation provider.
     */
    public val trustModel: Output<String>?
        get() = javaResource.trustModel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AttestationProviderMapper : ResourceMapper<AttestationProvider> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.attestation.AttestationProvider::class == javaResource::class

    override fun map(javaResource: Resource): AttestationProvider = AttestationProvider(
        javaResource
            as com.pulumi.azurenative.attestation.AttestationProvider,
    )
}

/**
 * @see [AttestationProvider].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AttestationProvider].
 */
public suspend fun attestationProvider(
    name: String,
    block: suspend AttestationProviderResourceBuilder.() -> Unit,
): AttestationProvider {
    val builder = AttestationProviderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AttestationProvider].
 * @param name The _unique_ name of the resulting resource.
 */
public fun attestationProvider(name: String): AttestationProvider {
    val builder = AttestationProviderResourceBuilder()
    builder.name(name)
    return builder.build()
}
