@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.AccessReviewHistoryDefinitionByIdArgs.builder
import com.pulumi.azurenative.authorization.kotlin.enums.AccessReviewRecurrenceRangeType
import com.pulumi.azurenative.authorization.kotlin.enums.AccessReviewResult
import com.pulumi.azurenative.authorization.kotlin.inputs.AccessReviewHistoryInstanceArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.AccessReviewHistoryInstanceArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.AccessReviewScopeArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.AccessReviewScopeArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Access Review History Definition.
 * Azure REST API version: 2021-12-01-preview. Prior API version in Azure Native 1.x: 2021-11-16-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:AccessReviewHistoryDefinitionById myresource1 /subscriptions/{subscriptionId}/providers/Microsoft.Authorization/accessReviewHistoryDefinitions/{historyDefinitionId}
 * ```
 * @property decisions Collection of review decisions which the history data should be filtered on. For example if Approve and Deny are supplied the data will only contain review results in which the decision maker approved or denied a review request.
 * @property displayName The display name for the history definition.
 * @property endDate The DateTime when the review is scheduled to end. Required if type is endDate
 * @property historyDefinitionId The id of the access review history definition.
 * @property instances Set of access review history instances for this history definition.
 * @property interval The interval for recurrence. For a quarterly review, the interval is 3 for type : absoluteMonthly.
 * @property numberOfOccurrences The number of times to repeat the access review. Required and must be positive if type is numbered.
 * @property scopes A collection of scopes used when selecting review history data
 * @property startDate The DateTime when the review is scheduled to be start. This could be a date in the future. Required on create.
 * @property type The recurrence range type. The possible values are: endDate, noEnd, numbered.
 */
public data class AccessReviewHistoryDefinitionByIdArgs(
    public val decisions: Output<List<Either<String, AccessReviewResult>>>? = null,
    public val displayName: Output<String>? = null,
    public val endDate: Output<String>? = null,
    public val historyDefinitionId: Output<String>? = null,
    public val instances: Output<List<AccessReviewHistoryInstanceArgs>>? = null,
    public val interval: Output<Int>? = null,
    public val numberOfOccurrences: Output<Int>? = null,
    public val scopes: Output<List<AccessReviewScopeArgs>>? = null,
    public val startDate: Output<String>? = null,
    public val type: Output<Either<String, AccessReviewRecurrenceRangeType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.AccessReviewHistoryDefinitionByIdArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.AccessReviewHistoryDefinitionByIdArgs =
        com.pulumi.azurenative.authorization.AccessReviewHistoryDefinitionByIdArgs.builder()
            .decisions(
                decisions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .endDate(endDate?.applyValue({ args0 -> args0 }))
            .historyDefinitionId(historyDefinitionId?.applyValue({ args0 -> args0 }))
            .instances(
                instances?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .interval(interval?.applyValue({ args0 -> args0 }))
            .numberOfOccurrences(numberOfOccurrences?.applyValue({ args0 -> args0 }))
            .scopes(scopes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .startDate(startDate?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AccessReviewHistoryDefinitionByIdArgs].
 */
@PulumiTagMarker
public class AccessReviewHistoryDefinitionByIdArgsBuilder internal constructor() {
    private var decisions: Output<List<Either<String, AccessReviewResult>>>? = null

    private var displayName: Output<String>? = null

    private var endDate: Output<String>? = null

    private var historyDefinitionId: Output<String>? = null

    private var instances: Output<List<AccessReviewHistoryInstanceArgs>>? = null

    private var interval: Output<Int>? = null

    private var numberOfOccurrences: Output<Int>? = null

    private var scopes: Output<List<AccessReviewScopeArgs>>? = null

    private var startDate: Output<String>? = null

    private var type: Output<Either<String, AccessReviewRecurrenceRangeType>>? = null

    /**
     * @param value Collection of review decisions which the history data should be filtered on. For example if Approve and Deny are supplied the data will only contain review results in which the decision maker approved or denied a review request.
     */
    @JvmName("vyueuxkdifhrprxo")
    public suspend fun decisions(`value`: Output<List<Either<String, AccessReviewResult>>>) {
        this.decisions = value
    }

    @JvmName("uscfiuqmlnqtqcam")
    public suspend fun decisions(vararg values: Output<Either<String, AccessReviewResult>>) {
        this.decisions = Output.all(values.asList())
    }

    /**
     * @param values Collection of review decisions which the history data should be filtered on. For example if Approve and Deny are supplied the data will only contain review results in which the decision maker approved or denied a review request.
     */
    @JvmName("sdgqlekxdaoqyfyw")
    public suspend fun decisions(values: List<Output<Either<String, AccessReviewResult>>>) {
        this.decisions = Output.all(values)
    }

    /**
     * @param value The display name for the history definition.
     */
    @JvmName("vfoyalvahthdeovy")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The DateTime when the review is scheduled to end. Required if type is endDate
     */
    @JvmName("sggmyjqgrtmwadwm")
    public suspend fun endDate(`value`: Output<String>) {
        this.endDate = value
    }

    /**
     * @param value The id of the access review history definition.
     */
    @JvmName("vklwiekcdxgvnyqi")
    public suspend fun historyDefinitionId(`value`: Output<String>) {
        this.historyDefinitionId = value
    }

    /**
     * @param value Set of access review history instances for this history definition.
     */
    @JvmName("ljgeljkdeuhlhkui")
    public suspend fun instances(`value`: Output<List<AccessReviewHistoryInstanceArgs>>) {
        this.instances = value
    }

    @JvmName("pwlqmbldqlgttjec")
    public suspend fun instances(vararg values: Output<AccessReviewHistoryInstanceArgs>) {
        this.instances = Output.all(values.asList())
    }

    /**
     * @param values Set of access review history instances for this history definition.
     */
    @JvmName("ufaauxeetcbaghvk")
    public suspend fun instances(values: List<Output<AccessReviewHistoryInstanceArgs>>) {
        this.instances = Output.all(values)
    }

    /**
     * @param value The interval for recurrence. For a quarterly review, the interval is 3 for type : absoluteMonthly.
     */
    @JvmName("rakthvvwgeiptsgl")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value The number of times to repeat the access review. Required and must be positive if type is numbered.
     */
    @JvmName("vrncvqjjdskpjfqj")
    public suspend fun numberOfOccurrences(`value`: Output<Int>) {
        this.numberOfOccurrences = value
    }

    /**
     * @param value A collection of scopes used when selecting review history data
     */
    @JvmName("iuxdbtpvlrwcekuo")
    public suspend fun scopes(`value`: Output<List<AccessReviewScopeArgs>>) {
        this.scopes = value
    }

    @JvmName("xysffyinpkqgryil")
    public suspend fun scopes(vararg values: Output<AccessReviewScopeArgs>) {
        this.scopes = Output.all(values.asList())
    }

    /**
     * @param values A collection of scopes used when selecting review history data
     */
    @JvmName("nyhuwyijaevpnhah")
    public suspend fun scopes(values: List<Output<AccessReviewScopeArgs>>) {
        this.scopes = Output.all(values)
    }

    /**
     * @param value The DateTime when the review is scheduled to be start. This could be a date in the future. Required on create.
     */
    @JvmName("utnmncyepmbxwcki")
    public suspend fun startDate(`value`: Output<String>) {
        this.startDate = value
    }

    /**
     * @param value The recurrence range type. The possible values are: endDate, noEnd, numbered.
     */
    @JvmName("qfacmjnympikskkh")
    public suspend fun type(`value`: Output<Either<String, AccessReviewRecurrenceRangeType>>) {
        this.type = value
    }

    /**
     * @param value Collection of review decisions which the history data should be filtered on. For example if Approve and Deny are supplied the data will only contain review results in which the decision maker approved or denied a review request.
     */
    @JvmName("nwulcljmdwcisuhy")
    public suspend fun decisions(`value`: List<Either<String, AccessReviewResult>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.decisions = mapped
    }

    /**
     * @param values Collection of review decisions which the history data should be filtered on. For example if Approve and Deny are supplied the data will only contain review results in which the decision maker approved or denied a review request.
     */
    @JvmName("qveuajwmpucwcodj")
    public suspend fun decisions(vararg values: Either<String, AccessReviewResult>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.decisions = mapped
    }

    /**
     * @param value The display name for the history definition.
     */
    @JvmName("gnkbhtrklxkofwup")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The DateTime when the review is scheduled to end. Required if type is endDate
     */
    @JvmName("shndyemotbwiqayl")
    public suspend fun endDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endDate = mapped
    }

    /**
     * @param value The id of the access review history definition.
     */
    @JvmName("vntbjqxlxlmajfyr")
    public suspend fun historyDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.historyDefinitionId = mapped
    }

    /**
     * @param value Set of access review history instances for this history definition.
     */
    @JvmName("biebicjslttmlxbb")
    public suspend fun instances(`value`: List<AccessReviewHistoryInstanceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instances = mapped
    }

    /**
     * @param argument Set of access review history instances for this history definition.
     */
    @JvmName("fsvtpxaacoupmlid")
    public suspend
    fun instances(argument: List<suspend AccessReviewHistoryInstanceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AccessReviewHistoryInstanceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.instances = mapped
    }

    /**
     * @param argument Set of access review history instances for this history definition.
     */
    @JvmName("mjohuhumqmswusip")
    public suspend fun instances(
        vararg
        argument: suspend AccessReviewHistoryInstanceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AccessReviewHistoryInstanceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.instances = mapped
    }

    /**
     * @param argument Set of access review history instances for this history definition.
     */
    @JvmName("waohhoycuixlcokr")
    public suspend
    fun instances(argument: suspend AccessReviewHistoryInstanceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AccessReviewHistoryInstanceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.instances = mapped
    }

    /**
     * @param values Set of access review history instances for this history definition.
     */
    @JvmName("dgnghhnxwmrkumhd")
    public suspend fun instances(vararg values: AccessReviewHistoryInstanceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instances = mapped
    }

    /**
     * @param value The interval for recurrence. For a quarterly review, the interval is 3 for type : absoluteMonthly.
     */
    @JvmName("haeeampnkrmwxadn")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value The number of times to repeat the access review. Required and must be positive if type is numbered.
     */
    @JvmName("cfqotwxxqascvtpj")
    public suspend fun numberOfOccurrences(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfOccurrences = mapped
    }

    /**
     * @param value A collection of scopes used when selecting review history data
     */
    @JvmName("fgkwrlnfpukinguc")
    public suspend fun scopes(`value`: List<AccessReviewScopeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param argument A collection of scopes used when selecting review history data
     */
    @JvmName("vplsxecqxyxmbxml")
    public suspend fun scopes(argument: List<suspend AccessReviewScopeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AccessReviewScopeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.scopes = mapped
    }

    /**
     * @param argument A collection of scopes used when selecting review history data
     */
    @JvmName("umjxhtvwqimmless")
    public suspend fun scopes(vararg argument: suspend AccessReviewScopeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AccessReviewScopeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.scopes = mapped
    }

    /**
     * @param argument A collection of scopes used when selecting review history data
     */
    @JvmName("ljkxndbubilxvdug")
    public suspend fun scopes(argument: suspend AccessReviewScopeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AccessReviewScopeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.scopes = mapped
    }

    /**
     * @param values A collection of scopes used when selecting review history data
     */
    @JvmName("wmyvqtouaeqeqtxu")
    public suspend fun scopes(vararg values: AccessReviewScopeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param value The DateTime when the review is scheduled to be start. This could be a date in the future. Required on create.
     */
    @JvmName("yifmvsoolbdtrwxu")
    public suspend fun startDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startDate = mapped
    }

    /**
     * @param value The recurrence range type. The possible values are: endDate, noEnd, numbered.
     */
    @JvmName("fmorfrjoyogvfmhx")
    public suspend fun type(`value`: Either<String, AccessReviewRecurrenceRangeType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The recurrence range type. The possible values are: endDate, noEnd, numbered.
     */
    @JvmName("eukupbaudkjavmso")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AccessReviewRecurrenceRangeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The recurrence range type. The possible values are: endDate, noEnd, numbered.
     */
    @JvmName("fhylamjfwhwmnfyi")
    public fun type(`value`: AccessReviewRecurrenceRangeType) {
        val toBeMapped = Either.ofRight<String, AccessReviewRecurrenceRangeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AccessReviewHistoryDefinitionByIdArgs =
        AccessReviewHistoryDefinitionByIdArgs(
            decisions = decisions,
            displayName = displayName,
            endDate = endDate,
            historyDefinitionId = historyDefinitionId,
            instances = instances,
            interval = interval,
            numberOfOccurrences = numberOfOccurrences,
            scopes = scopes,
            startDate = startDate,
            type = type,
        )
}
