@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.PolicyAssignmentArgs.builder
import com.pulumi.azurenative.authorization.kotlin.enums.EnforcementMode
import com.pulumi.azurenative.authorization.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.NonComplianceMessageArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.NonComplianceMessageArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.OverrideArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.OverrideArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.ParameterValuesValueArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.ParameterValuesValueArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.ResourceSelectorArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.ResourceSelectorArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The policy assignment.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2016-04-01, 2016-12-01, 2019-06-01, 2020-03-01, 2023-04-01.
 * ## Example Usage
 * ### Create or update a policy assignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignment = new AzureNative.Authorization.PolicyAssignment("policyAssignment", new()
 *     {
 *         Description = "Force resource names to begin with given DeptA and end with -LC",
 *         DisplayName = "Enforce resource naming rules",
 *         Metadata =
 *         {
 *             { "assignedBy", "Special Someone" },
 *         },
 *         NonComplianceMessages = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.NonComplianceMessageArgs
 *             {
 *                 Message = "Resource names must start with 'DeptA' and end with '-LC'.",
 *             },
 *         },
 *         Parameters =
 *         {
 *             { "prefix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *             {
 *                 Value = "DeptA",
 *             } },
 *             { "suffix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *             {
 *                 Value = "-LC",
 *             } },
 *         },
 *         PolicyAssignmentName = "EnforceNaming",
 *         PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming",
 *         Scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyAssignment(ctx, "policyAssignment", &authorization.PolicyAssignmentArgs{
 * 			Description: pulumi.String("Force resource names to begin with given DeptA and end with -LC"),
 * 			DisplayName: pulumi.String("Enforce resource naming rules"),
 * 			Metadata: pulumi.Any{
 * 				AssignedBy: "Special Someone",
 * 			},
 * 			NonComplianceMessages: []authorization.NonComplianceMessageArgs{
 * 				{
 * 					Message: pulumi.String("Resource names must start with 'DeptA' and end with '-LC'."),
 * 				},
 * 			},
 * 			Parameters: authorization.ParameterValuesValueMap{
 * 				"prefix": &authorization.ParameterValuesValueArgs{
 * 					Value: pulumi.Any("DeptA"),
 * 				},
 * 				"suffix": &authorization.ParameterValuesValueArgs{
 * 					Value: pulumi.Any("-LC"),
 * 				},
 * 			},
 * 			PolicyAssignmentName: pulumi.String("EnforceNaming"),
 * 			PolicyDefinitionId:   pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 * 			Scope:                pulumi.String("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyAssignment;
 * import com.pulumi.azurenative.authorization.PolicyAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignment = new PolicyAssignment("policyAssignment", PolicyAssignmentArgs.builder()
 *             .description("Force resource names to begin with given DeptA and end with -LC")
 *             .displayName("Enforce resource naming rules")
 *             .metadata(Map.of("assignedBy", "Special Someone"))
 *             .nonComplianceMessages(Map.of("message", "Resource names must start with 'DeptA' and end with '-LC'."))
 *             .parameters(Map.ofEntries(
 *                 Map.entry("prefix", Map.of("value", "DeptA")),
 *                 Map.entry("suffix", Map.of("value", "-LC"))
 *             ))
 *             .policyAssignmentName("EnforceNaming")
 *             .policyDefinitionId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming")
 *             .scope("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a policy assignment with a system assigned identity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignment = new AzureNative.Authorization.PolicyAssignment("policyAssignment", new()
 *     {
 *         Description = "Force resource names to begin with given DeptA and end with -LC",
 *         DisplayName = "Enforce resource naming rules",
 *         EnforcementMode = "Default",
 *         Identity = new AzureNative.Authorization.Inputs.IdentityArgs
 *         {
 *             Type = AzureNative.Authorization.ResourceIdentityType.SystemAssigned,
 *         },
 *         Location = "eastus",
 *         Metadata =
 *         {
 *             { "assignedBy", "Foo Bar" },
 *         },
 *         Parameters =
 *         {
 *             { "prefix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *             {
 *                 Value = "DeptA",
 *             } },
 *             { "suffix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *             {
 *                 Value = "-LC",
 *             } },
 *         },
 *         PolicyAssignmentName = "EnforceNaming",
 *         PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming",
 *         Scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyAssignment(ctx, "policyAssignment", &authorization.PolicyAssignmentArgs{
 * 			Description:     pulumi.String("Force resource names to begin with given DeptA and end with -LC"),
 * 			DisplayName:     pulumi.String("Enforce resource naming rules"),
 * 			EnforcementMode: pulumi.String("Default"),
 * 			Identity: &authorization.IdentityArgs{
 * 				Type: authorization.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			Metadata: pulumi.Any{
 * 				AssignedBy: "Foo Bar",
 * 			},
 * 			Parameters: authorization.ParameterValuesValueMap{
 * 				"prefix": &authorization.ParameterValuesValueArgs{
 * 					Value: pulumi.Any("DeptA"),
 * 				},
 * 				"suffix": &authorization.ParameterValuesValueArgs{
 * 					Value: pulumi.Any("-LC"),
 * 				},
 * 			},
 * 			PolicyAssignmentName: pulumi.String("EnforceNaming"),
 * 			PolicyDefinitionId:   pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 * 			Scope:                pulumi.String("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyAssignment;
 * import com.pulumi.azurenative.authorization.PolicyAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignment = new PolicyAssignment("policyAssignment", PolicyAssignmentArgs.builder()
 *             .description("Force resource names to begin with given DeptA and end with -LC")
 *             .displayName("Enforce resource naming rules")
 *             .enforcementMode("Default")
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .location("eastus")
 *             .metadata(Map.of("assignedBy", "Foo Bar"))
 *             .parameters(Map.ofEntries(
 *                 Map.entry("prefix", Map.of("value", "DeptA")),
 *                 Map.entry("suffix", Map.of("value", "-LC"))
 *             ))
 *             .policyAssignmentName("EnforceNaming")
 *             .policyDefinitionId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming")
 *             .scope("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a policy assignment with multiple non-compliance messages
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignment = new AzureNative.Authorization.PolicyAssignment("policyAssignment", new()
 *     {
 *         DisplayName = "Enforce security policies",
 *         NonComplianceMessages = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.NonComplianceMessageArgs
 *             {
 *                 Message = "Resources must comply with all internal security policies. See <internal site URL> for more info.",
 *             },
 *             new AzureNative.Authorization.Inputs.NonComplianceMessageArgs
 *             {
 *                 Message = "Resource names must start with 'DeptA' and end with '-LC'.",
 *                 PolicyDefinitionReferenceId = "10420126870854049575",
 *             },
 *             new AzureNative.Authorization.Inputs.NonComplianceMessageArgs
 *             {
 *                 Message = "Storage accounts must have firewall rules configured.",
 *                 PolicyDefinitionReferenceId = "8572513655450389710",
 *             },
 *         },
 *         PolicyAssignmentName = "securityInitAssignment",
 *         PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/securityInitiative",
 *         Scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyAssignment(ctx, "policyAssignment", &authorization.PolicyAssignmentArgs{
 * 			DisplayName: pulumi.String("Enforce security policies"),
 * 			NonComplianceMessages: []authorization.NonComplianceMessageArgs{
 * 				{
 * 					Message: pulumi.String("Resources must comply with all internal security policies. See <internal site URL> for more info."),
 * 				},
 * 				{
 * 					Message:                     pulumi.String("Resource names must start with 'DeptA' and end with '-LC'."),
 * 					PolicyDefinitionReferenceId: pulumi.String("10420126870854049575"),
 * 				},
 * 				{
 * 					Message:                     pulumi.String("Storage accounts must have firewall rules configured."),
 * 					PolicyDefinitionReferenceId: pulumi.String("8572513655450389710"),
 * 				},
 * 			},
 * 			PolicyAssignmentName: pulumi.String("securityInitAssignment"),
 * 			PolicyDefinitionId:   pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/securityInitiative"),
 * 			Scope:                pulumi.String("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyAssignment;
 * import com.pulumi.azurenative.authorization.PolicyAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignment = new PolicyAssignment("policyAssignment", PolicyAssignmentArgs.builder()
 *             .displayName("Enforce security policies")
 *             .nonComplianceMessages(
 *                 Map.of("message", "Resources must comply with all internal security policies. See <internal site URL> for more info."),
 *                 Map.ofEntries(
 *                     Map.entry("message", "Resource names must start with 'DeptA' and end with '-LC'."),
 *                     Map.entry("policyDefinitionReferenceId", "10420126870854049575")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("message", "Storage accounts must have firewall rules configured."),
 *                     Map.entry("policyDefinitionReferenceId", "8572513655450389710")
 *                 ))
 *             .policyAssignmentName("securityInitAssignment")
 *             .policyDefinitionId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/securityInitiative")
 *             .scope("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a policy assignment with overrides
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignment = new AzureNative.Authorization.PolicyAssignment("policyAssignment", new()
 *     {
 *         Description = "Limit the resource location and resource SKU",
 *         DisplayName = "Limit the resource location and resource SKU",
 *         Metadata =
 *         {
 *             { "assignedBy", "Special Someone" },
 *         },
 *         Overrides = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.OverrideArgs
 *             {
 *                 Kind = "policyEffect",
 *                 Selectors = new[]
 *                 {
 *                     new AzureNative.Authorization.Inputs.SelectorArgs
 *                     {
 *                         In = new[]
 *                         {
 *                             "Limit_Skus",
 *                             "Limit_Locations",
 *                         },
 *                         Kind = "policyDefinitionReferenceId",
 *                     },
 *                 },
 *                 Value = "Audit",
 *             },
 *         },
 *         PolicyAssignmentName = "CostManagement",
 *         PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement",
 *         Scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyAssignment(ctx, "policyAssignment", &authorization.PolicyAssignmentArgs{
 * 			Description: pulumi.String("Limit the resource location and resource SKU"),
 * 			DisplayName: pulumi.String("Limit the resource location and resource SKU"),
 * 			Metadata: pulumi.Any{
 * 				AssignedBy: "Special Someone",
 * 			},
 * 			Overrides: []authorization.OverrideArgs{
 * 				{
 * 					Kind: pulumi.String("policyEffect"),
 * 					Selectors: authorization.SelectorArray{
 * 						{
 * 							In: pulumi.StringArray{
 * 								pulumi.String("Limit_Skus"),
 * 								pulumi.String("Limit_Locations"),
 * 							},
 * 							Kind: pulumi.String("policyDefinitionReferenceId"),
 * 						},
 * 					},
 * 					Value: pulumi.String("Audit"),
 * 				},
 * 			},
 * 			PolicyAssignmentName: pulumi.String("CostManagement"),
 * 			PolicyDefinitionId:   pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement"),
 * 			Scope:                pulumi.String("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyAssignment;
 * import com.pulumi.azurenative.authorization.PolicyAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignment = new PolicyAssignment("policyAssignment", PolicyAssignmentArgs.builder()
 *             .description("Limit the resource location and resource SKU")
 *             .displayName("Limit the resource location and resource SKU")
 *             .metadata(Map.of("assignedBy", "Special Someone"))
 *             .overrides(Map.ofEntries(
 *                 Map.entry("kind", "policyEffect"),
 *                 Map.entry("selectors", Map.ofEntries(
 *                     Map.entry("in",
 *                         "Limit_Skus",
 *                         "Limit_Locations"),
 *                     Map.entry("kind", "policyDefinitionReferenceId")
 *                 )),
 *                 Map.entry("value", "Audit")
 *             ))
 *             .policyAssignmentName("CostManagement")
 *             .policyDefinitionId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement")
 *             .scope("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a policy assignment with resource selectors
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignment = new AzureNative.Authorization.PolicyAssignment("policyAssignment", new()
 *     {
 *         Description = "Limit the resource location and resource SKU",
 *         DisplayName = "Limit the resource location and resource SKU",
 *         Metadata =
 *         {
 *             { "assignedBy", "Special Someone" },
 *         },
 *         PolicyAssignmentName = "CostManagement",
 *         PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement",
 *         ResourceSelectors = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.ResourceSelectorArgs
 *             {
 *                 Name = "SDPRegions",
 *                 Selectors = new[]
 *                 {
 *                     new AzureNative.Authorization.Inputs.SelectorArgs
 *                     {
 *                         In = new[]
 *                         {
 *                             "eastus2euap",
 *                             "centraluseuap",
 *                         },
 *                         Kind = "resourceLocation",
 *                     },
 *                 },
 *             },
 *         },
 *         Scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyAssignment(ctx, "policyAssignment", &authorization.PolicyAssignmentArgs{
 * 			Description: pulumi.String("Limit the resource location and resource SKU"),
 * 			DisplayName: pulumi.String("Limit the resource location and resource SKU"),
 * 			Metadata: pulumi.Any{
 * 				AssignedBy: "Special Someone",
 * 			},
 * 			PolicyAssignmentName: pulumi.String("CostManagement"),
 * 			PolicyDefinitionId:   pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement"),
 * 			ResourceSelectors: []authorization.ResourceSelectorArgs{
 * 				{
 * 					Name: pulumi.String("SDPRegions"),
 * 					Selectors: authorization.SelectorArray{
 * 						{
 * 							In: pulumi.StringArray{
 * 								pulumi.String("eastus2euap"),
 * 								pulumi.String("centraluseuap"),
 * 							},
 * 							Kind: pulumi.String("resourceLocation"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Scope: pulumi.String("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyAssignment;
 * import com.pulumi.azurenative.authorization.PolicyAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignment = new PolicyAssignment("policyAssignment", PolicyAssignmentArgs.builder()
 *             .description("Limit the resource location and resource SKU")
 *             .displayName("Limit the resource location and resource SKU")
 *             .metadata(Map.of("assignedBy", "Special Someone"))
 *             .policyAssignmentName("CostManagement")
 *             .policyDefinitionId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement")
 *             .resourceSelectors(Map.ofEntries(
 *                 Map.entry("name", "SDPRegions"),
 *                 Map.entry("selectors", Map.ofEntries(
 *                     Map.entry("in",
 *                         "eastus2euap",
 *                         "centraluseuap"),
 *                     Map.entry("kind", "resourceLocation")
 *                 ))
 *             ))
 *             .scope("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a policy assignment without enforcing policy effect during resource creation or update.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignment = new AzureNative.Authorization.PolicyAssignment("policyAssignment", new()
 *     {
 *         Description = "Force resource names to begin with given DeptA and end with -LC",
 *         DisplayName = "Enforce resource naming rules",
 *         EnforcementMode = "DoNotEnforce",
 *         Metadata =
 *         {
 *             { "assignedBy", "Special Someone" },
 *         },
 *         Parameters =
 *         {
 *             { "prefix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *             {
 *                 Value = "DeptA",
 *             } },
 *             { "suffix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *             {
 *                 Value = "-LC",
 *             } },
 *         },
 *         PolicyAssignmentName = "EnforceNaming",
 *         PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming",
 *         Scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyAssignment(ctx, "policyAssignment", &authorization.PolicyAssignmentArgs{
 * 			Description:     pulumi.String("Force resource names to begin with given DeptA and end with -LC"),
 * 			DisplayName:     pulumi.String("Enforce resource naming rules"),
 * 			EnforcementMode: pulumi.String("DoNotEnforce"),
 * 			Metadata: pulumi.Any{
 * 				AssignedBy: "Special Someone",
 * 			},
 * 			Parameters: authorization.ParameterValuesValueMap{
 * 				"prefix": &authorization.ParameterValuesValueArgs{
 * 					Value: pulumi.Any("DeptA"),
 * 				},
 * 				"suffix": &authorization.ParameterValuesValueArgs{
 * 					Value: pulumi.Any("-LC"),
 * 				},
 * 			},
 * 			PolicyAssignmentName: pulumi.String("EnforceNaming"),
 * 			PolicyDefinitionId:   pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 * 			Scope:                pulumi.String("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyAssignment;
 * import com.pulumi.azurenative.authorization.PolicyAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignment = new PolicyAssignment("policyAssignment", PolicyAssignmentArgs.builder()
 *             .description("Force resource names to begin with given DeptA and end with -LC")
 *             .displayName("Enforce resource naming rules")
 *             .enforcementMode("DoNotEnforce")
 *             .metadata(Map.of("assignedBy", "Special Someone"))
 *             .parameters(Map.ofEntries(
 *                 Map.entry("prefix", Map.of("value", "DeptA")),
 *                 Map.entry("suffix", Map.of("value", "-LC"))
 *             ))
 *             .policyAssignmentName("EnforceNaming")
 *             .policyDefinitionId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming")
 *             .scope("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:PolicyAssignment EnforceNaming /{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}
 * ```
 * @property description This message will be part of response in case of policy violation.
 * @property displayName The display name of the policy assignment.
 * @property enforcementMode The policy assignment enforcement mode. Possible values are Default and DoNotEnforce.
 * @property identity The managed identity associated with the policy assignment.
 * @property location The location of the policy assignment. Only required when utilizing managed identity.
 * @property metadata The policy assignment metadata. Metadata is an open ended object and is typically a collection of key value pairs.
 * @property nonComplianceMessages The messages that describe why a resource is non-compliant with the policy.
 * @property notScopes The policy's excluded scopes.
 * @property overrides The policy property value override.
 * @property parameters The parameter values for the assigned policy rule. The keys are the parameter names.
 * @property policyAssignmentName The name of the policy assignment.
 * @property policyDefinitionId The ID of the policy definition or policy set definition being assigned.
 * @property resourceSelectors The resource selector list to filter policies by resource properties.
 * @property scope The scope of the policy assignment. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
 */
public data class PolicyAssignmentArgs(
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val enforcementMode: Output<Either<String, EnforcementMode>>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val metadata: Output<Any>? = null,
    public val nonComplianceMessages: Output<List<NonComplianceMessageArgs>>? = null,
    public val notScopes: Output<List<String>>? = null,
    public val overrides: Output<List<OverrideArgs>>? = null,
    public val parameters: Output<Map<String, ParameterValuesValueArgs>>? = null,
    public val policyAssignmentName: Output<String>? = null,
    public val policyDefinitionId: Output<String>? = null,
    public val resourceSelectors: Output<List<ResourceSelectorArgs>>? = null,
    public val scope: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.PolicyAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.PolicyAssignmentArgs =
        com.pulumi.azurenative.authorization.PolicyAssignmentArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .enforcementMode(
                enforcementMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .nonComplianceMessages(
                nonComplianceMessages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .notScopes(notScopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .overrides(
                overrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .policyAssignmentName(policyAssignmentName?.applyValue({ args0 -> args0 }))
            .policyDefinitionId(policyDefinitionId?.applyValue({ args0 -> args0 }))
            .resourceSelectors(
                resourceSelectors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .scope(scope?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyAssignmentArgs].
 */
@PulumiTagMarker
public class PolicyAssignmentArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var enforcementMode: Output<Either<String, EnforcementMode>>? = null

    private var identity: Output<IdentityArgs>? = null

    private var location: Output<String>? = null

    private var metadata: Output<Any>? = null

    private var nonComplianceMessages: Output<List<NonComplianceMessageArgs>>? = null

    private var notScopes: Output<List<String>>? = null

    private var overrides: Output<List<OverrideArgs>>? = null

    private var parameters: Output<Map<String, ParameterValuesValueArgs>>? = null

    private var policyAssignmentName: Output<String>? = null

    private var policyDefinitionId: Output<String>? = null

    private var resourceSelectors: Output<List<ResourceSelectorArgs>>? = null

    private var scope: Output<String>? = null

    /**
     * @param value This message will be part of response in case of policy violation.
     */
    @JvmName("srfdlvjbnrufnmlp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name of the policy assignment.
     */
    @JvmName("pndxbclavjhxifwd")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The policy assignment enforcement mode. Possible values are Default and DoNotEnforce.
     */
    @JvmName("oxsykdjencpnukek")
    public suspend fun enforcementMode(`value`: Output<Either<String, EnforcementMode>>) {
        this.enforcementMode = value
    }

    /**
     * @param value The managed identity associated with the policy assignment.
     */
    @JvmName("etcedbamjaolbpqx")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The location of the policy assignment. Only required when utilizing managed identity.
     */
    @JvmName("jstnybgkpcekwfxs")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The policy assignment metadata. Metadata is an open ended object and is typically a collection of key value pairs.
     */
    @JvmName("vdibxevcytikifrb")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value The messages that describe why a resource is non-compliant with the policy.
     */
    @JvmName("lehornoatcmdhnuc")
    public suspend fun nonComplianceMessages(`value`: Output<List<NonComplianceMessageArgs>>) {
        this.nonComplianceMessages = value
    }

    @JvmName("eyolkphdhfclsmwy")
    public suspend fun nonComplianceMessages(vararg values: Output<NonComplianceMessageArgs>) {
        this.nonComplianceMessages = Output.all(values.asList())
    }

    /**
     * @param values The messages that describe why a resource is non-compliant with the policy.
     */
    @JvmName("hluxldiaaavcqcam")
    public suspend fun nonComplianceMessages(values: List<Output<NonComplianceMessageArgs>>) {
        this.nonComplianceMessages = Output.all(values)
    }

    /**
     * @param value The policy's excluded scopes.
     */
    @JvmName("ewgdwpclfsajivkm")
    public suspend fun notScopes(`value`: Output<List<String>>) {
        this.notScopes = value
    }

    @JvmName("eglkxnjwvwpnlpgk")
    public suspend fun notScopes(vararg values: Output<String>) {
        this.notScopes = Output.all(values.asList())
    }

    /**
     * @param values The policy's excluded scopes.
     */
    @JvmName("dgkvphyxfnbntqnx")
    public suspend fun notScopes(values: List<Output<String>>) {
        this.notScopes = Output.all(values)
    }

    /**
     * @param value The policy property value override.
     */
    @JvmName("kwtfbevifupeijmt")
    public suspend fun overrides(`value`: Output<List<OverrideArgs>>) {
        this.overrides = value
    }

    @JvmName("wgtknnjvxstrnbfj")
    public suspend fun overrides(vararg values: Output<OverrideArgs>) {
        this.overrides = Output.all(values.asList())
    }

    /**
     * @param values The policy property value override.
     */
    @JvmName("tpkuxvamdsjiwkoe")
    public suspend fun overrides(values: List<Output<OverrideArgs>>) {
        this.overrides = Output.all(values)
    }

    /**
     * @param value The parameter values for the assigned policy rule. The keys are the parameter names.
     */
    @JvmName("mdcyqedkpontcdcx")
    public suspend fun parameters(`value`: Output<Map<String, ParameterValuesValueArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The name of the policy assignment.
     */
    @JvmName("csksbrkucahywkro")
    public suspend fun policyAssignmentName(`value`: Output<String>) {
        this.policyAssignmentName = value
    }

    /**
     * @param value The ID of the policy definition or policy set definition being assigned.
     */
    @JvmName("uplfwitlnpgxnxro")
    public suspend fun policyDefinitionId(`value`: Output<String>) {
        this.policyDefinitionId = value
    }

    /**
     * @param value The resource selector list to filter policies by resource properties.
     */
    @JvmName("djocrkqwpxtrixxl")
    public suspend fun resourceSelectors(`value`: Output<List<ResourceSelectorArgs>>) {
        this.resourceSelectors = value
    }

    @JvmName("jjomrmqqrycyxwnn")
    public suspend fun resourceSelectors(vararg values: Output<ResourceSelectorArgs>) {
        this.resourceSelectors = Output.all(values.asList())
    }

    /**
     * @param values The resource selector list to filter policies by resource properties.
     */
    @JvmName("ysrvnqghabcewoov")
    public suspend fun resourceSelectors(values: List<Output<ResourceSelectorArgs>>) {
        this.resourceSelectors = Output.all(values)
    }

    /**
     * @param value The scope of the policy assignment. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
     */
    @JvmName("xtggobytpcffhndt")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value This message will be part of response in case of policy violation.
     */
    @JvmName("quhteqqaccfqroso")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name of the policy assignment.
     */
    @JvmName("cytwxlqjkiillvra")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The policy assignment enforcement mode. Possible values are Default and DoNotEnforce.
     */
    @JvmName("psyghnlqvfjtdlug")
    public suspend fun enforcementMode(`value`: Either<String, EnforcementMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforcementMode = mapped
    }

    /**
     * @param value The policy assignment enforcement mode. Possible values are Default and DoNotEnforce.
     */
    @JvmName("nvfpvnatxrpcgtbl")
    public fun enforcementMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnforcementMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enforcementMode = mapped
    }

    /**
     * @param value The policy assignment enforcement mode. Possible values are Default and DoNotEnforce.
     */
    @JvmName("knqahehikrkouhbh")
    public fun enforcementMode(`value`: EnforcementMode) {
        val toBeMapped = Either.ofRight<String, EnforcementMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enforcementMode = mapped
    }

    /**
     * @param value The managed identity associated with the policy assignment.
     */
    @JvmName("qmkocqhveppfcgja")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The managed identity associated with the policy assignment.
     */
    @JvmName("cfgyndlgbwekiibx")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The location of the policy assignment. Only required when utilizing managed identity.
     */
    @JvmName("nycfmiailcrmieck")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The policy assignment metadata. Metadata is an open ended object and is typically a collection of key value pairs.
     */
    @JvmName("qvquxqoxiqembyoh")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The messages that describe why a resource is non-compliant with the policy.
     */
    @JvmName("eeoshmphnrowqmvq")
    public suspend fun nonComplianceMessages(`value`: List<NonComplianceMessageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nonComplianceMessages = mapped
    }

    /**
     * @param argument The messages that describe why a resource is non-compliant with the policy.
     */
    @JvmName("nwlpuucybeudthox")
    public suspend
    fun nonComplianceMessages(argument: List<suspend NonComplianceMessageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NonComplianceMessageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nonComplianceMessages = mapped
    }

    /**
     * @param argument The messages that describe why a resource is non-compliant with the policy.
     */
    @JvmName("jfgbuoskmtdaeofr")
    public suspend fun nonComplianceMessages(
        vararg
        argument: suspend NonComplianceMessageArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NonComplianceMessageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.nonComplianceMessages = mapped
    }

    /**
     * @param argument The messages that describe why a resource is non-compliant with the policy.
     */
    @JvmName("kirdtggpditbsbxp")
    public suspend
    fun nonComplianceMessages(argument: suspend NonComplianceMessageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NonComplianceMessageArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.nonComplianceMessages = mapped
    }

    /**
     * @param values The messages that describe why a resource is non-compliant with the policy.
     */
    @JvmName("weqcvcwrchduwhil")
    public suspend fun nonComplianceMessages(vararg values: NonComplianceMessageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nonComplianceMessages = mapped
    }

    /**
     * @param value The policy's excluded scopes.
     */
    @JvmName("akiystpoefvhlatk")
    public suspend fun notScopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notScopes = mapped
    }

    /**
     * @param values The policy's excluded scopes.
     */
    @JvmName("adsayalxykltfngk")
    public suspend fun notScopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notScopes = mapped
    }

    /**
     * @param value The policy property value override.
     */
    @JvmName("qqreigtexvxmtblq")
    public suspend fun overrides(`value`: List<OverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overrides = mapped
    }

    /**
     * @param argument The policy property value override.
     */
    @JvmName("rgwkbnyhvbifukgg")
    public suspend fun overrides(argument: List<suspend OverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { OverrideArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.overrides = mapped
    }

    /**
     * @param argument The policy property value override.
     */
    @JvmName("jcbukhxbvnhrqavb")
    public suspend fun overrides(vararg argument: suspend OverrideArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { OverrideArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.overrides = mapped
    }

    /**
     * @param argument The policy property value override.
     */
    @JvmName("kbyohasqbxnhyirt")
    public suspend fun overrides(argument: suspend OverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(OverrideArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.overrides = mapped
    }

    /**
     * @param values The policy property value override.
     */
    @JvmName("kmnukkblkntduxst")
    public suspend fun overrides(vararg values: OverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.overrides = mapped
    }

    /**
     * @param value The parameter values for the assigned policy rule. The keys are the parameter names.
     */
    @JvmName("yrkkiddbxaenhprx")
    public suspend fun parameters(`value`: Map<String, ParameterValuesValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameter values for the assigned policy rule. The keys are the parameter names.
     */
    @JvmName("xehrawtffqyikrug")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterValuesValueArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterValuesValueArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The parameter values for the assigned policy rule. The keys are the parameter names.
     */
    @JvmName("rbvivkisfabcsegi")
    public fun parameters(vararg values: Pair<String, ParameterValuesValueArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The name of the policy assignment.
     */
    @JvmName("dhtpnkjcdoglyyrx")
    public suspend fun policyAssignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyAssignmentName = mapped
    }

    /**
     * @param value The ID of the policy definition or policy set definition being assigned.
     */
    @JvmName("mhxijrkwtwuvupti")
    public suspend fun policyDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDefinitionId = mapped
    }

    /**
     * @param value The resource selector list to filter policies by resource properties.
     */
    @JvmName("ahohgnxwabpkuoym")
    public suspend fun resourceSelectors(`value`: List<ResourceSelectorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceSelectors = mapped
    }

    /**
     * @param argument The resource selector list to filter policies by resource properties.
     */
    @JvmName("sknwymvwulbnykvj")
    public suspend
    fun resourceSelectors(argument: List<suspend ResourceSelectorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceSelectorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceSelectors = mapped
    }

    /**
     * @param argument The resource selector list to filter policies by resource properties.
     */
    @JvmName("nrnvednleveoabmj")
    public suspend fun resourceSelectors(
        vararg
        argument: suspend ResourceSelectorArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResourceSelectorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceSelectors = mapped
    }

    /**
     * @param argument The resource selector list to filter policies by resource properties.
     */
    @JvmName("pvpdkwggllbaobvo")
    public suspend fun resourceSelectors(argument: suspend ResourceSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceSelectorArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.resourceSelectors = mapped
    }

    /**
     * @param values The resource selector list to filter policies by resource properties.
     */
    @JvmName("ybkbvjpganjgbtub")
    public suspend fun resourceSelectors(vararg values: ResourceSelectorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceSelectors = mapped
    }

    /**
     * @param value The scope of the policy assignment. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
     */
    @JvmName("hrwdndkkcgqniawb")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): PolicyAssignmentArgs = PolicyAssignmentArgs(
        description = description,
        displayName = displayName,
        enforcementMode = enforcementMode,
        identity = identity,
        location = location,
        metadata = metadata,
        nonComplianceMessages = nonComplianceMessages,
        notScopes = notScopes,
        overrides = overrides,
        parameters = parameters,
        policyAssignmentName = policyAssignmentName,
        policyDefinitionId = policyDefinitionId,
        resourceSelectors = resourceSelectors,
        scope = scope,
    )
}
