@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.PolicyDefinitionVersionAtManagementGroupArgs.builder
import com.pulumi.azurenative.authorization.kotlin.enums.PolicyType
import com.pulumi.azurenative.authorization.kotlin.inputs.ParameterDefinitionsValueArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.ParameterDefinitionsValueArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The ID of the policy definition version.
 * Azure REST API version: 2023-04-01.
 * ## Example Usage
 * ### Create or update a policy definition version at management group level
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyDefinitionVersionAtManagementGroup = new AzureNative.Authorization.PolicyDefinitionVersionAtManagementGroup("policyDefinitionVersionAtManagementGroup", new()
 *     {
 *         Description = "Force resource names to begin with given 'prefix' and/or end with given 'suffix'",
 *         DisplayName = "Enforce resource naming convention",
 *         ManagementGroupName = "MyManagementGroup",
 *         Metadata =
 *         {
 *             { "category", "Naming" },
 *         },
 *         Mode = "All",
 *         Parameters =
 *         {
 *             { "prefix", new AzureNative.Authorization.Inputs.ParameterDefinitionsValueArgs
 *             {
 *                 Metadata = new AzureNative.Authorization.Inputs.ParameterDefinitionsValueMetadataArgs
 *                 {
 *                     Description = "Resource name prefix",
 *                     DisplayName = "Prefix",
 *                 },
 *                 Type = "String",
 *             } },
 *             { "suffix", new AzureNative.Authorization.Inputs.ParameterDefinitionsValueArgs
 *             {
 *                 Metadata = new AzureNative.Authorization.Inputs.ParameterDefinitionsValueMetadataArgs
 *                 {
 *                     Description = "Resource name suffix",
 *                     DisplayName = "Suffix",
 *                 },
 *                 Type = "String",
 *             } },
 *         },
 *         PolicyDefinitionName = "ResourceNaming",
 *         PolicyDefinitionVersion = "1.2.1",
 *         PolicyRule =
 *         {
 *             { "if",
 *             {
 *                 { "not",
 *                 {
 *                     { "field", "name" },
 *                     { "like", "[concat(parameters('prefix'), '*', parameters('suffix'))]" },
 *                 } },
 *             } },
 *             { "then",
 *             {
 *                 { "effect", "deny" },
 *             } },
 *         },
 *         Version = "1.2.1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyDefinitionVersionAtManagementGroup(ctx, "policyDefinitionVersionAtManagementGroup", &authorization.PolicyDefinitionVersionAtManagementGroupArgs{
 * 			Description:         pulumi.String("Force resource names to begin with given 'prefix' and/or end with given 'suffix'"),
 * 			DisplayName:         pulumi.String("Enforce resource naming convention"),
 * 			ManagementGroupName: pulumi.String("MyManagementGroup"),
 * 			Metadata: pulumi.Any{
 * 				Category: "Naming",
 * 			},
 * 			Mode: pulumi.String("All"),
 * 			Parameters: authorization.ParameterDefinitionsValueMap{
 * 				"prefix": &authorization.ParameterDefinitionsValueArgs{
 * 					Metadata: &authorization.ParameterDefinitionsValueMetadataArgs{
 * 						Description: pulumi.String("Resource name prefix"),
 * 						DisplayName: pulumi.String("Prefix"),
 * 					},
 * 					Type: pulumi.String("String"),
 * 				},
 * 				"suffix": &authorization.ParameterDefinitionsValueArgs{
 * 					Metadata: &authorization.ParameterDefinitionsValueMetadataArgs{
 * 						Description: pulumi.String("Resource name suffix"),
 * 						DisplayName: pulumi.String("Suffix"),
 * 					},
 * 					Type: pulumi.String("String"),
 * 				},
 * 			},
 * 			PolicyDefinitionName:    pulumi.String("ResourceNaming"),
 * 			PolicyDefinitionVersion: pulumi.String("1.2.1"),
 * 			PolicyRule: pulumi.Any{
 * 				If: map[string]interface{}{
 * 					"not": map[string]interface{}{
 * 						"field": "name",
 * 						"like":  "[concat(parameters('prefix'), '*', parameters('suffix'))]",
 * 					},
 * 				},
 * 				Then: map[string]interface{}{
 * 					"effect": "deny",
 * 				},
 * 			},
 * 			Version: pulumi.String("1.2.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyDefinitionVersionAtManagementGroup;
 * import com.pulumi.azurenative.authorization.PolicyDefinitionVersionAtManagementGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyDefinitionVersionAtManagementGroup = new PolicyDefinitionVersionAtManagementGroup("policyDefinitionVersionAtManagementGroup", PolicyDefinitionVersionAtManagementGroupArgs.builder()
 *             .description("Force resource names to begin with given 'prefix' and/or end with given 'suffix'")
 *             .displayName("Enforce resource naming convention")
 *             .managementGroupName("MyManagementGroup")
 *             .metadata(Map.of("category", "Naming"))
 *             .mode("All")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("prefix", Map.ofEntries(
 *                     Map.entry("metadata", Map.ofEntries(
 *                         Map.entry("description", "Resource name prefix"),
 *                         Map.entry("displayName", "Prefix")
 *                     )),
 *                     Map.entry("type", "String")
 *                 )),
 *                 Map.entry("suffix", Map.ofEntries(
 *                     Map.entry("metadata", Map.ofEntries(
 *                         Map.entry("description", "Resource name suffix"),
 *                         Map.entry("displayName", "Suffix")
 *                     )),
 *                     Map.entry("type", "String")
 *                 ))
 *             ))
 *             .policyDefinitionName("ResourceNaming")
 *             .policyDefinitionVersion("1.2.1")
 *             .policyRule(Map.ofEntries(
 *                 Map.entry("if", Map.of("not", Map.ofEntries(
 *                     Map.entry("field", "name"),
 *                     Map.entry("like", "[concat(parameters('prefix'), '*', parameters('suffix'))]")
 *                 ))),
 *                 Map.entry("then", Map.of("effect", "deny"))
 *             ))
 *             .version("1.2.1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:PolicyDefinitionVersionAtManagementGroup 1.2.1 /providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}/versions/{policyDefinitionVersion}
 * ```
 * @property description The policy definition description.
 * @property displayName The display name of the policy definition.
 * @property managementGroupName The name of the management group. The name is case insensitive.
 * @property metadata The policy definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
 * @property mode The policy definition mode. Some examples are All, Indexed, Microsoft.KeyVault.Data.
 * @property parameters The parameter definitions for parameters used in the policy rule. The keys are the parameter names.
 * @property policyDefinitionName The name of the policy definition.
 * @property policyDefinitionVersion The policy definition version.  The format is x.y.z where x is the major version number, y is the minor version number, and z is the patch number
 * @property policyRule The policy rule.
 * @property policyType The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
 * @property version The policy definition version in #.#.# format.
 */
public data class PolicyDefinitionVersionAtManagementGroupArgs(
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val managementGroupName: Output<String>? = null,
    public val metadata: Output<Any>? = null,
    public val mode: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterDefinitionsValueArgs>>? = null,
    public val policyDefinitionName: Output<String>? = null,
    public val policyDefinitionVersion: Output<String>? = null,
    public val policyRule: Output<Any>? = null,
    public val policyType: Output<Either<String, PolicyType>>? = null,
    public val version: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.PolicyDefinitionVersionAtManagementGroupArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.PolicyDefinitionVersionAtManagementGroupArgs =
        com.pulumi.azurenative.authorization.PolicyDefinitionVersionAtManagementGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .managementGroupName(managementGroupName?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .mode(mode?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .policyDefinitionName(policyDefinitionName?.applyValue({ args0 -> args0 }))
            .policyDefinitionVersion(policyDefinitionVersion?.applyValue({ args0 -> args0 }))
            .policyRule(policyRule?.applyValue({ args0 -> args0 }))
            .policyType(
                policyType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyDefinitionVersionAtManagementGroupArgs].
 */
@PulumiTagMarker
public class PolicyDefinitionVersionAtManagementGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var managementGroupName: Output<String>? = null

    private var metadata: Output<Any>? = null

    private var mode: Output<String>? = null

    private var parameters: Output<Map<String, ParameterDefinitionsValueArgs>>? = null

    private var policyDefinitionName: Output<String>? = null

    private var policyDefinitionVersion: Output<String>? = null

    private var policyRule: Output<Any>? = null

    private var policyType: Output<Either<String, PolicyType>>? = null

    private var version: Output<String>? = null

    /**
     * @param value The policy definition description.
     */
    @JvmName("jdvanqrukotmcuor")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name of the policy definition.
     */
    @JvmName("xrjoanshxmkddibu")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The name of the management group. The name is case insensitive.
     */
    @JvmName("qcgifccamkqvgleo")
    public suspend fun managementGroupName(`value`: Output<String>) {
        this.managementGroupName = value
    }

    /**
     * @param value The policy definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
     */
    @JvmName("rirajvqpdurqgtyx")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value The policy definition mode. Some examples are All, Indexed, Microsoft.KeyVault.Data.
     */
    @JvmName("ehqpctqbyktrerxu")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value The parameter definitions for parameters used in the policy rule. The keys are the parameter names.
     */
    @JvmName("fjcbxixnyvvyrjxy")
    public suspend fun parameters(`value`: Output<Map<String, ParameterDefinitionsValueArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The name of the policy definition.
     */
    @JvmName("nyffoxqvnksbyjrn")
    public suspend fun policyDefinitionName(`value`: Output<String>) {
        this.policyDefinitionName = value
    }

    /**
     * @param value The policy definition version.  The format is x.y.z where x is the major version number, y is the minor version number, and z is the patch number
     */
    @JvmName("bqkavhhyodiscwqg")
    public suspend fun policyDefinitionVersion(`value`: Output<String>) {
        this.policyDefinitionVersion = value
    }

    /**
     * @param value The policy rule.
     */
    @JvmName("glwpwibxfhphhbru")
    public suspend fun policyRule(`value`: Output<Any>) {
        this.policyRule = value
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("miwmdgeboranriav")
    public suspend fun policyType(`value`: Output<Either<String, PolicyType>>) {
        this.policyType = value
    }

    /**
     * @param value The policy definition version in #.#.# format.
     */
    @JvmName("tcwqysbxtufpqify")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The policy definition description.
     */
    @JvmName("wusvxgdmnsqpidhn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name of the policy definition.
     */
    @JvmName("jnknaijcuspccewx")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the management group. The name is case insensitive.
     */
    @JvmName("upckqcawyegnliqh")
    public suspend fun managementGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementGroupName = mapped
    }

    /**
     * @param value The policy definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
     */
    @JvmName("vrwyfvlkmbweexla")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The policy definition mode. Some examples are All, Indexed, Microsoft.KeyVault.Data.
     */
    @JvmName("mlbjywdjqmvvtmta")
    public suspend fun mode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The parameter definitions for parameters used in the policy rule. The keys are the parameter names.
     */
    @JvmName("eumggbiacdxjmtdb")
    public suspend fun parameters(`value`: Map<String, ParameterDefinitionsValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameter definitions for parameters used in the policy rule. The keys are the parameter names.
     */
    @JvmName("ghwdfpgjhryarkmb")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterDefinitionsValueArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterDefinitionsValueArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The parameter definitions for parameters used in the policy rule. The keys are the parameter names.
     */
    @JvmName("gqbvxavwnabgpltd")
    public fun parameters(vararg values: Pair<String, ParameterDefinitionsValueArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The name of the policy definition.
     */
    @JvmName("kobfdyqxagjxpnfl")
    public suspend fun policyDefinitionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDefinitionName = mapped
    }

    /**
     * @param value The policy definition version.  The format is x.y.z where x is the major version number, y is the minor version number, and z is the patch number
     */
    @JvmName("gwdhjwedgbmmypba")
    public suspend fun policyDefinitionVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDefinitionVersion = mapped
    }

    /**
     * @param value The policy rule.
     */
    @JvmName("elunnikuqxjrkvgw")
    public suspend fun policyRule(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyRule = mapped
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("nwcdnfkktexwvlcx")
    public suspend fun policyType(`value`: Either<String, PolicyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("xqfmrfqhntyhkxfl")
    public fun policyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("aigqhnbplqvorogu")
    public fun policyType(`value`: PolicyType) {
        val toBeMapped = Either.ofRight<String, PolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value The policy definition version in #.#.# format.
     */
    @JvmName("klksvihsldwixfdo")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): PolicyDefinitionVersionAtManagementGroupArgs =
        PolicyDefinitionVersionAtManagementGroupArgs(
            description = description,
            displayName = displayName,
            managementGroupName = managementGroupName,
            metadata = metadata,
            mode = mode,
            parameters = parameters,
            policyDefinitionName = policyDefinitionName,
            policyDefinitionVersion = policyDefinitionVersion,
            policyRule = policyRule,
            policyType = policyType,
            version = version,
        )
}
