@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.PolicySetDefinitionAtManagementGroupArgs.builder
import com.pulumi.azurenative.authorization.kotlin.enums.PolicyType
import com.pulumi.azurenative.authorization.kotlin.inputs.ParameterDefinitionsValueArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.ParameterDefinitionsValueArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyDefinitionGroupArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyDefinitionGroupArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyDefinitionReferenceArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyDefinitionReferenceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The policy set definition.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2019-06-01, 2023-04-01.
 * ## Example Usage
 * ### Create or update a policy set definition at management group level
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policySetDefinitionAtManagementGroup = new AzureNative.Authorization.PolicySetDefinitionAtManagementGroup("policySetDefinitionAtManagementGroup", new()
 *     {
 *         Description = "Policies to enforce low cost storage SKUs",
 *         DisplayName = "Cost Management",
 *         ManagementGroupId = "MyManagementGroup",
 *         Metadata =
 *         {
 *             { "category", "Cost Management" },
 *         },
 *         PolicyDefinitions = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionReferenceArgs
 *             {
 *                 Parameters =
 *                 {
 *                     { "listOfAllowedSKUs", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = new[]
 *                         {
 *                             "Standard_GRS",
 *                             "Standard_LRS",
 *                         },
 *                     } },
 *                 },
 *                 PolicyDefinitionId = "/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1",
 *                 PolicyDefinitionReferenceId = "Limit_Skus",
 *             },
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionReferenceArgs
 *             {
 *                 Parameters =
 *                 {
 *                     { "prefix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = "DeptA",
 *                     } },
 *                     { "suffix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = "-LC",
 *                     } },
 *                 },
 *                 PolicyDefinitionId = "/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming",
 *                 PolicyDefinitionReferenceId = "Resource_Naming",
 *             },
 *         },
 *         PolicySetDefinitionName = "CostManagement",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicySetDefinitionAtManagementGroup(ctx, "policySetDefinitionAtManagementGroup", &authorization.PolicySetDefinitionAtManagementGroupArgs{
 * 			Description:       pulumi.String("Policies to enforce low cost storage SKUs"),
 * 			DisplayName:       pulumi.String("Cost Management"),
 * 			ManagementGroupId: pulumi.String("MyManagementGroup"),
 * 			Metadata: pulumi.Any{
 * 				Category: "Cost Management",
 * 			},
 * 			PolicyDefinitions: []authorization.PolicyDefinitionReferenceArgs{
 * 				{
 * 					Parameters: {
 * 						"listOfAllowedSKUs": {
 * 							Value: pulumi.Any{
 * 								"Standard_GRS",
 * 								"Standard_LRS",
 * 							},
 * 						},
 * 					},
 * 					PolicyDefinitionId:          pulumi.String("/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
 * 					PolicyDefinitionReferenceId: pulumi.String("Limit_Skus"),
 * 				},
 * 				{
 * 					Parameters: {
 * 						"prefix": {
 * 							Value: pulumi.Any("DeptA"),
 * 						},
 * 						"suffix": {
 * 							Value: pulumi.Any("-LC"),
 * 						},
 * 					},
 * 					PolicyDefinitionId:          pulumi.String("/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 * 					PolicyDefinitionReferenceId: pulumi.String("Resource_Naming"),
 * 				},
 * 			},
 * 			PolicySetDefinitionName: pulumi.String("CostManagement"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicySetDefinitionAtManagementGroup;
 * import com.pulumi.azurenative.authorization.PolicySetDefinitionAtManagementGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policySetDefinitionAtManagementGroup = new PolicySetDefinitionAtManagementGroup("policySetDefinitionAtManagementGroup", PolicySetDefinitionAtManagementGroupArgs.builder()
 *             .description("Policies to enforce low cost storage SKUs")
 *             .displayName("Cost Management")
 *             .managementGroupId("MyManagementGroup")
 *             .metadata(Map.of("category", "Cost Management"))
 *             .policyDefinitions(
 *                 Map.ofEntries(
 *                     Map.entry("parameters", Map.of("listOfAllowedSKUs", Map.of("value",
 *                         "Standard_GRS",
 *                         "Standard_LRS"))),
 *                     Map.entry("policyDefinitionId", "/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
 *                     Map.entry("policyDefinitionReferenceId", "Limit_Skus")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("parameters", Map.ofEntries(
 *                         Map.entry("prefix", Map.of("value", "DeptA")),
 *                         Map.entry("suffix", Map.of("value", "-LC"))
 *                     )),
 *                     Map.entry("policyDefinitionId", "/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 *                     Map.entry("policyDefinitionReferenceId", "Resource_Naming")
 *                 ))
 *             .policySetDefinitionName("CostManagement")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a policy set definition with groups at management group level
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policySetDefinitionAtManagementGroup = new AzureNative.Authorization.PolicySetDefinitionAtManagementGroup("policySetDefinitionAtManagementGroup", new()
 *     {
 *         Description = "Policies to enforce low cost storage SKUs",
 *         DisplayName = "Cost Management",
 *         ManagementGroupId = "MyManagementGroup",
 *         Metadata =
 *         {
 *             { "category", "Cost Management" },
 *         },
 *         PolicyDefinitionGroups = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionGroupArgs
 *             {
 *                 Description = "Policies designed to control spend within a subscription.",
 *                 DisplayName = "Cost Management Policies",
 *                 Name = "CostSaving",
 *             },
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionGroupArgs
 *             {
 *                 Description = "Policies that help enforce resource organization standards within a subscription.",
 *                 DisplayName = "Organizational Policies",
 *                 Name = "Organizational",
 *             },
 *         },
 *         PolicyDefinitions = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionReferenceArgs
 *             {
 *                 GroupNames = new[]
 *                 {
 *                     "CostSaving",
 *                 },
 *                 Parameters =
 *                 {
 *                     { "listOfAllowedSKUs", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = new[]
 *                         {
 *                             "Standard_GRS",
 *                             "Standard_LRS",
 *                         },
 *                     } },
 *                 },
 *                 PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1",
 *                 PolicyDefinitionReferenceId = "Limit_Skus",
 *             },
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionReferenceArgs
 *             {
 *                 GroupNames = new[]
 *                 {
 *                     "Organizational",
 *                 },
 *                 Parameters =
 *                 {
 *                     { "prefix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = "DeptA",
 *                     } },
 *                     { "suffix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = "-LC",
 *                     } },
 *                 },
 *                 PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming",
 *                 PolicyDefinitionReferenceId = "Resource_Naming",
 *             },
 *         },
 *         PolicySetDefinitionName = "CostManagement",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicySetDefinitionAtManagementGroup(ctx, "policySetDefinitionAtManagementGroup", &authorization.PolicySetDefinitionAtManagementGroupArgs{
 * 			Description:       pulumi.String("Policies to enforce low cost storage SKUs"),
 * 			DisplayName:       pulumi.String("Cost Management"),
 * 			ManagementGroupId: pulumi.String("MyManagementGroup"),
 * 			Metadata: pulumi.Any{
 * 				Category: "Cost Management",
 * 			},
 * 			PolicyDefinitionGroups: []authorization.PolicyDefinitionGroupArgs{
 * 				{
 * 					Description: pulumi.String("Policies designed to control spend within a subscription."),
 * 					DisplayName: pulumi.String("Cost Management Policies"),
 * 					Name:        pulumi.String("CostSaving"),
 * 				},
 * 				{
 * 					Description: pulumi.String("Policies that help enforce resource organization standards within a subscription."),
 * 					DisplayName: pulumi.String("Organizational Policies"),
 * 					Name:        pulumi.String("Organizational"),
 * 				},
 * 			},
 * 			PolicyDefinitions: []authorization.PolicyDefinitionReferenceArgs{
 * 				{
 * 					GroupNames: pulumi.StringArray{
 * 						pulumi.String("CostSaving"),
 * 					},
 * 					Parameters: {
 * 						"listOfAllowedSKUs": {
 * 							Value: pulumi.Any{
 * 								"Standard_GRS",
 * 								"Standard_LRS",
 * 							},
 * 						},
 * 					},
 * 					PolicyDefinitionId:          pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
 * 					PolicyDefinitionReferenceId: pulumi.String("Limit_Skus"),
 * 				},
 * 				{
 * 					GroupNames: pulumi.StringArray{
 * 						pulumi.String("Organizational"),
 * 					},
 * 					Parameters: {
 * 						"prefix": {
 * 							Value: pulumi.Any("DeptA"),
 * 						},
 * 						"suffix": {
 * 							Value: pulumi.Any("-LC"),
 * 						},
 * 					},
 * 					PolicyDefinitionId:          pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 * 					PolicyDefinitionReferenceId: pulumi.String("Resource_Naming"),
 * 				},
 * 			},
 * 			PolicySetDefinitionName: pulumi.String("CostManagement"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicySetDefinitionAtManagementGroup;
 * import com.pulumi.azurenative.authorization.PolicySetDefinitionAtManagementGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policySetDefinitionAtManagementGroup = new PolicySetDefinitionAtManagementGroup("policySetDefinitionAtManagementGroup", PolicySetDefinitionAtManagementGroupArgs.builder()
 *             .description("Policies to enforce low cost storage SKUs")
 *             .displayName("Cost Management")
 *             .managementGroupId("MyManagementGroup")
 *             .metadata(Map.of("category", "Cost Management"))
 *             .policyDefinitionGroups(
 *                 Map.ofEntries(
 *                     Map.entry("description", "Policies designed to control spend within a subscription."),
 *                     Map.entry("displayName", "Cost Management Policies"),
 *                     Map.entry("name", "CostSaving")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("description", "Policies that help enforce resource organization standards within a subscription."),
 *                     Map.entry("displayName", "Organizational Policies"),
 *                     Map.entry("name", "Organizational")
 *                 ))
 *             .policyDefinitions(
 *                 Map.ofEntries(
 *                     Map.entry("groupNames", "CostSaving"),
 *                     Map.entry("parameters", Map.of("listOfAllowedSKUs", Map.of("value",
 *                         "Standard_GRS",
 *                         "Standard_LRS"))),
 *                     Map.entry("policyDefinitionId", "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
 *                     Map.entry("policyDefinitionReferenceId", "Limit_Skus")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("groupNames", "Organizational"),
 *                     Map.entry("parameters", Map.ofEntries(
 *                         Map.entry("prefix", Map.of("value", "DeptA")),
 *                         Map.entry("suffix", Map.of("value", "-LC"))
 *                     )),
 *                     Map.entry("policyDefinitionId", "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 *                     Map.entry("policyDefinitionReferenceId", "Resource_Naming")
 *                 ))
 *             .policySetDefinitionName("CostManagement")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:PolicySetDefinitionAtManagementGroup CostManagement /providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}
 * ```
 * @property description The policy set definition description.
 * @property displayName The display name of the policy set definition.
 * @property managementGroupId The ID of the management group.
 * @property metadata The policy set definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
 * @property parameters The policy set definition parameters that can be used in policy definition references.
 * @property policyDefinitionGroups The metadata describing groups of policy definition references within the policy set definition.
 * @property policyDefinitions An array of policy definition references.
 * @property policySetDefinitionName The name of the policy set definition to create.
 * @property policyType The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
 */
public data class PolicySetDefinitionAtManagementGroupArgs(
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val managementGroupId: Output<String>? = null,
    public val metadata: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterDefinitionsValueArgs>>? = null,
    public val policyDefinitionGroups: Output<List<PolicyDefinitionGroupArgs>>? = null,
    public val policyDefinitions: Output<List<PolicyDefinitionReferenceArgs>>? = null,
    public val policySetDefinitionName: Output<String>? = null,
    public val policyType: Output<Either<String, PolicyType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.PolicySetDefinitionAtManagementGroupArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.PolicySetDefinitionAtManagementGroupArgs =
        com.pulumi.azurenative.authorization.PolicySetDefinitionAtManagementGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .managementGroupId(managementGroupId?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .policyDefinitionGroups(
                policyDefinitionGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .policyDefinitions(
                policyDefinitions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .policySetDefinitionName(policySetDefinitionName?.applyValue({ args0 -> args0 }))
            .policyType(
                policyType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PolicySetDefinitionAtManagementGroupArgs].
 */
@PulumiTagMarker
public class PolicySetDefinitionAtManagementGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var managementGroupId: Output<String>? = null

    private var metadata: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterDefinitionsValueArgs>>? = null

    private var policyDefinitionGroups: Output<List<PolicyDefinitionGroupArgs>>? = null

    private var policyDefinitions: Output<List<PolicyDefinitionReferenceArgs>>? = null

    private var policySetDefinitionName: Output<String>? = null

    private var policyType: Output<Either<String, PolicyType>>? = null

    /**
     * @param value The policy set definition description.
     */
    @JvmName("idensvjyruxuogpr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name of the policy set definition.
     */
    @JvmName("parumbccoctjgbvj")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The ID of the management group.
     */
    @JvmName("luemawngtafmxoiv")
    public suspend fun managementGroupId(`value`: Output<String>) {
        this.managementGroupId = value
    }

    /**
     * @param value The policy set definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
     */
    @JvmName("kvvqxrqextydsocj")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value The policy set definition parameters that can be used in policy definition references.
     */
    @JvmName("bjplmvsssjndfixs")
    public suspend fun parameters(`value`: Output<Map<String, ParameterDefinitionsValueArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("osytuytqkigjyklh")
    public suspend fun policyDefinitionGroups(`value`: Output<List<PolicyDefinitionGroupArgs>>) {
        this.policyDefinitionGroups = value
    }

    @JvmName("sesyuwysrpyrgefw")
    public suspend fun policyDefinitionGroups(vararg values: Output<PolicyDefinitionGroupArgs>) {
        this.policyDefinitionGroups = Output.all(values.asList())
    }

    /**
     * @param values The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("dvxlboesfqhophsm")
    public suspend fun policyDefinitionGroups(values: List<Output<PolicyDefinitionGroupArgs>>) {
        this.policyDefinitionGroups = Output.all(values)
    }

    /**
     * @param value An array of policy definition references.
     */
    @JvmName("agpvcieuafgawxbx")
    public suspend fun policyDefinitions(`value`: Output<List<PolicyDefinitionReferenceArgs>>) {
        this.policyDefinitions = value
    }

    @JvmName("ogkpgvsitxfgxdbp")
    public suspend fun policyDefinitions(vararg values: Output<PolicyDefinitionReferenceArgs>) {
        this.policyDefinitions = Output.all(values.asList())
    }

    /**
     * @param values An array of policy definition references.
     */
    @JvmName("eurvpbfqlosjmuvo")
    public suspend fun policyDefinitions(values: List<Output<PolicyDefinitionReferenceArgs>>) {
        this.policyDefinitions = Output.all(values)
    }

    /**
     * @param value The name of the policy set definition to create.
     */
    @JvmName("aupuqgyndsmjymcx")
    public suspend fun policySetDefinitionName(`value`: Output<String>) {
        this.policySetDefinitionName = value
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("dpsllkqnodwhncqj")
    public suspend fun policyType(`value`: Output<Either<String, PolicyType>>) {
        this.policyType = value
    }

    /**
     * @param value The policy set definition description.
     */
    @JvmName("bfgnsiwxhdsbkfag")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name of the policy set definition.
     */
    @JvmName("srtmuuwpiompwjbs")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The ID of the management group.
     */
    @JvmName("vvltambrpxetxdoi")
    public suspend fun managementGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementGroupId = mapped
    }

    /**
     * @param value The policy set definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
     */
    @JvmName("jynnprshucdntafl")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The policy set definition parameters that can be used in policy definition references.
     */
    @JvmName("cxwnslpklhgvapbw")
    public suspend fun parameters(`value`: Map<String, ParameterDefinitionsValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The policy set definition parameters that can be used in policy definition references.
     */
    @JvmName("uxjawxrexqpnqmlx")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterDefinitionsValueArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterDefinitionsValueArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The policy set definition parameters that can be used in policy definition references.
     */
    @JvmName("tgbcvnpghcxmcvku")
    public fun parameters(vararg values: Pair<String, ParameterDefinitionsValueArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("dllxbllwniqjxbub")
    public suspend fun policyDefinitionGroups(`value`: List<PolicyDefinitionGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDefinitionGroups = mapped
    }

    /**
     * @param argument The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("byksblnfwnpljitr")
    public suspend
    fun policyDefinitionGroups(argument: List<suspend PolicyDefinitionGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyDefinitionGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.policyDefinitionGroups = mapped
    }

    /**
     * @param argument The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("pnvobnlkphydditf")
    public suspend fun policyDefinitionGroups(
        vararg
        argument: suspend PolicyDefinitionGroupArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PolicyDefinitionGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.policyDefinitionGroups = mapped
    }

    /**
     * @param argument The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("codxmoopghyxmgoq")
    public suspend
    fun policyDefinitionGroups(argument: suspend PolicyDefinitionGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PolicyDefinitionGroupArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.policyDefinitionGroups = mapped
    }

    /**
     * @param values The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("sjrditfkglsevsau")
    public suspend fun policyDefinitionGroups(vararg values: PolicyDefinitionGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyDefinitionGroups = mapped
    }

    /**
     * @param value An array of policy definition references.
     */
    @JvmName("kraniqdftrcxgdde")
    public suspend fun policyDefinitions(`value`: List<PolicyDefinitionReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDefinitions = mapped
    }

    /**
     * @param argument An array of policy definition references.
     */
    @JvmName("ivrxjsdhinreqggi")
    public suspend
    fun policyDefinitions(argument: List<suspend PolicyDefinitionReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyDefinitionReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.policyDefinitions = mapped
    }

    /**
     * @param argument An array of policy definition references.
     */
    @JvmName("ieokvgtygsijrhmj")
    public suspend fun policyDefinitions(
        vararg
        argument: suspend PolicyDefinitionReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PolicyDefinitionReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.policyDefinitions = mapped
    }

    /**
     * @param argument An array of policy definition references.
     */
    @JvmName("nkfmghshclcfkciy")
    public suspend
    fun policyDefinitions(argument: suspend PolicyDefinitionReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PolicyDefinitionReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.policyDefinitions = mapped
    }

    /**
     * @param values An array of policy definition references.
     */
    @JvmName("idmgnlndyferguma")
    public suspend fun policyDefinitions(vararg values: PolicyDefinitionReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyDefinitions = mapped
    }

    /**
     * @param value The name of the policy set definition to create.
     */
    @JvmName("fnbgdictlpvhvjlm")
    public suspend fun policySetDefinitionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policySetDefinitionName = mapped
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("dkkabiislovxniqv")
    public suspend fun policyType(`value`: Either<String, PolicyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("ovijmjrqkopmeihe")
    public fun policyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("gmybpeqalmnyyboa")
    public fun policyType(`value`: PolicyType) {
        val toBeMapped = Either.ofRight<String, PolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    internal fun build(): PolicySetDefinitionAtManagementGroupArgs =
        PolicySetDefinitionAtManagementGroupArgs(
            description = description,
            displayName = displayName,
            managementGroupId = managementGroupId,
            metadata = metadata,
            parameters = parameters,
            policyDefinitionGroups = policyDefinitionGroups,
            policyDefinitions = policyDefinitions,
            policySetDefinitionName = policySetDefinitionName,
            policyType = policyType,
        )
}
