@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.PolicySetDefinitionVersionAtManagementGroupArgs.builder
import com.pulumi.azurenative.authorization.kotlin.enums.PolicyType
import com.pulumi.azurenative.authorization.kotlin.inputs.ParameterDefinitionsValueArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.ParameterDefinitionsValueArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyDefinitionGroupArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyDefinitionGroupArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyDefinitionReferenceArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyDefinitionReferenceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The policy set definition version.
 * Azure REST API version: 2023-04-01.
 * ## Example Usage
 * ### Create or update a policy set definition version at management group level
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policySetDefinitionVersionAtManagementGroup = new AzureNative.Authorization.PolicySetDefinitionVersionAtManagementGroup("policySetDefinitionVersionAtManagementGroup", new()
 *     {
 *         Description = "Policies to enforce low cost storage SKUs",
 *         DisplayName = "Cost Management",
 *         ManagementGroupName = "MyManagementGroup",
 *         Metadata =
 *         {
 *             { "category", "Cost Management" },
 *         },
 *         PolicyDefinitionVersion = "1.2.1",
 *         PolicyDefinitions = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionReferenceArgs
 *             {
 *                 Parameters =
 *                 {
 *                     { "listOfAllowedSKUs", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = new[]
 *                         {
 *                             "Standard_GRS",
 *                             "Standard_LRS",
 *                         },
 *                     } },
 *                 },
 *                 PolicyDefinitionId = "/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1",
 *                 PolicyDefinitionReferenceId = "Limit_Skus",
 *             },
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionReferenceArgs
 *             {
 *                 Parameters =
 *                 {
 *                     { "prefix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = "DeptA",
 *                     } },
 *                     { "suffix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = "-LC",
 *                     } },
 *                 },
 *                 PolicyDefinitionId = "/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming",
 *                 PolicyDefinitionReferenceId = "Resource_Naming",
 *             },
 *         },
 *         PolicySetDefinitionName = "CostManagement",
 *         Version = "1.2.1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicySetDefinitionVersionAtManagementGroup(ctx, "policySetDefinitionVersionAtManagementGroup", &authorization.PolicySetDefinitionVersionAtManagementGroupArgs{
 * 			Description:         pulumi.String("Policies to enforce low cost storage SKUs"),
 * 			DisplayName:         pulumi.String("Cost Management"),
 * 			ManagementGroupName: pulumi.String("MyManagementGroup"),
 * 			Metadata: pulumi.Any{
 * 				Category: "Cost Management",
 * 			},
 * 			PolicyDefinitionVersion: pulumi.String("1.2.1"),
 * 			PolicyDefinitions: []authorization.PolicyDefinitionReferenceArgs{
 * 				{
 * 					Parameters: {
 * 						"listOfAllowedSKUs": {
 * 							Value: pulumi.Any{
 * 								"Standard_GRS",
 * 								"Standard_LRS",
 * 							},
 * 						},
 * 					},
 * 					PolicyDefinitionId:          pulumi.String("/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
 * 					PolicyDefinitionReferenceId: pulumi.String("Limit_Skus"),
 * 				},
 * 				{
 * 					Parameters: {
 * 						"prefix": {
 * 							Value: pulumi.Any("DeptA"),
 * 						},
 * 						"suffix": {
 * 							Value: pulumi.Any("-LC"),
 * 						},
 * 					},
 * 					PolicyDefinitionId:          pulumi.String("/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 * 					PolicyDefinitionReferenceId: pulumi.String("Resource_Naming"),
 * 				},
 * 			},
 * 			PolicySetDefinitionName: pulumi.String("CostManagement"),
 * 			Version:                 pulumi.String("1.2.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicySetDefinitionVersionAtManagementGroup;
 * import com.pulumi.azurenative.authorization.PolicySetDefinitionVersionAtManagementGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policySetDefinitionVersionAtManagementGroup = new PolicySetDefinitionVersionAtManagementGroup("policySetDefinitionVersionAtManagementGroup", PolicySetDefinitionVersionAtManagementGroupArgs.builder()
 *             .description("Policies to enforce low cost storage SKUs")
 *             .displayName("Cost Management")
 *             .managementGroupName("MyManagementGroup")
 *             .metadata(Map.of("category", "Cost Management"))
 *             .policyDefinitionVersion("1.2.1")
 *             .policyDefinitions(
 *                 Map.ofEntries(
 *                     Map.entry("parameters", Map.of("listOfAllowedSKUs", Map.of("value",
 *                         "Standard_GRS",
 *                         "Standard_LRS"))),
 *                     Map.entry("policyDefinitionId", "/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
 *                     Map.entry("policyDefinitionReferenceId", "Limit_Skus")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("parameters", Map.ofEntries(
 *                         Map.entry("prefix", Map.of("value", "DeptA")),
 *                         Map.entry("suffix", Map.of("value", "-LC"))
 *                     )),
 *                     Map.entry("policyDefinitionId", "/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 *                     Map.entry("policyDefinitionReferenceId", "Resource_Naming")
 *                 ))
 *             .policySetDefinitionName("CostManagement")
 *             .version("1.2.1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:PolicySetDefinitionVersionAtManagementGroup CostManagement /providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}/versions/{policyDefinitionVersion}
 * ```
 * @property description The policy set definition description.
 * @property displayName The display name of the policy set definition.
 * @property managementGroupName The name of the management group. The name is case insensitive.
 * @property metadata The policy set definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
 * @property parameters The policy set definition parameters that can be used in policy definition references.
 * @property policyDefinitionGroups The metadata describing groups of policy definition references within the policy set definition.
 * @property policyDefinitionVersion The policy set definition version.  The format is x.y.z where x is the major version number, y is the minor version number, and z is the patch number
 * @property policyDefinitions An array of policy definition references.
 * @property policySetDefinitionName The name of the policy set definition.
 * @property policyType The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
 * @property version The policy set definition version in #.#.# format.
 */
public data class PolicySetDefinitionVersionAtManagementGroupArgs(
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val managementGroupName: Output<String>? = null,
    public val metadata: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterDefinitionsValueArgs>>? = null,
    public val policyDefinitionGroups: Output<List<PolicyDefinitionGroupArgs>>? = null,
    public val policyDefinitionVersion: Output<String>? = null,
    public val policyDefinitions: Output<List<PolicyDefinitionReferenceArgs>>? = null,
    public val policySetDefinitionName: Output<String>? = null,
    public val policyType: Output<Either<String, PolicyType>>? = null,
    public val version: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.PolicySetDefinitionVersionAtManagementGroupArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.PolicySetDefinitionVersionAtManagementGroupArgs =
        com.pulumi.azurenative.authorization.PolicySetDefinitionVersionAtManagementGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .managementGroupName(managementGroupName?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .policyDefinitionGroups(
                policyDefinitionGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .policyDefinitionVersion(policyDefinitionVersion?.applyValue({ args0 -> args0 }))
            .policyDefinitions(
                policyDefinitions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .policySetDefinitionName(policySetDefinitionName?.applyValue({ args0 -> args0 }))
            .policyType(
                policyType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicySetDefinitionVersionAtManagementGroupArgs].
 */
@PulumiTagMarker
public class PolicySetDefinitionVersionAtManagementGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var managementGroupName: Output<String>? = null

    private var metadata: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterDefinitionsValueArgs>>? = null

    private var policyDefinitionGroups: Output<List<PolicyDefinitionGroupArgs>>? = null

    private var policyDefinitionVersion: Output<String>? = null

    private var policyDefinitions: Output<List<PolicyDefinitionReferenceArgs>>? = null

    private var policySetDefinitionName: Output<String>? = null

    private var policyType: Output<Either<String, PolicyType>>? = null

    private var version: Output<String>? = null

    /**
     * @param value The policy set definition description.
     */
    @JvmName("vwkrcwkmjcctmhdn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name of the policy set definition.
     */
    @JvmName("balqdhudqpmyyhcc")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The name of the management group. The name is case insensitive.
     */
    @JvmName("sfspryqtvtqflebi")
    public suspend fun managementGroupName(`value`: Output<String>) {
        this.managementGroupName = value
    }

    /**
     * @param value The policy set definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
     */
    @JvmName("exoctgehdjtctykc")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value The policy set definition parameters that can be used in policy definition references.
     */
    @JvmName("oqbvbdipsjmcyfyq")
    public suspend fun parameters(`value`: Output<Map<String, ParameterDefinitionsValueArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("djckrsmnbsoxabpp")
    public suspend fun policyDefinitionGroups(`value`: Output<List<PolicyDefinitionGroupArgs>>) {
        this.policyDefinitionGroups = value
    }

    @JvmName("oniwawpibkyfteuj")
    public suspend fun policyDefinitionGroups(vararg values: Output<PolicyDefinitionGroupArgs>) {
        this.policyDefinitionGroups = Output.all(values.asList())
    }

    /**
     * @param values The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("oupaglvvaakoqimi")
    public suspend fun policyDefinitionGroups(values: List<Output<PolicyDefinitionGroupArgs>>) {
        this.policyDefinitionGroups = Output.all(values)
    }

    /**
     * @param value The policy set definition version.  The format is x.y.z where x is the major version number, y is the minor version number, and z is the patch number
     */
    @JvmName("xjitvkmhsrbvudec")
    public suspend fun policyDefinitionVersion(`value`: Output<String>) {
        this.policyDefinitionVersion = value
    }

    /**
     * @param value An array of policy definition references.
     */
    @JvmName("ilwidpyygfllsjqv")
    public suspend fun policyDefinitions(`value`: Output<List<PolicyDefinitionReferenceArgs>>) {
        this.policyDefinitions = value
    }

    @JvmName("sqwjpmklfiksgxaa")
    public suspend fun policyDefinitions(vararg values: Output<PolicyDefinitionReferenceArgs>) {
        this.policyDefinitions = Output.all(values.asList())
    }

    /**
     * @param values An array of policy definition references.
     */
    @JvmName("lifintdcxtpadprg")
    public suspend fun policyDefinitions(values: List<Output<PolicyDefinitionReferenceArgs>>) {
        this.policyDefinitions = Output.all(values)
    }

    /**
     * @param value The name of the policy set definition.
     */
    @JvmName("wxsmnevgurojdiux")
    public suspend fun policySetDefinitionName(`value`: Output<String>) {
        this.policySetDefinitionName = value
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("liwhrhwyrpkjjgff")
    public suspend fun policyType(`value`: Output<Either<String, PolicyType>>) {
        this.policyType = value
    }

    /**
     * @param value The policy set definition version in #.#.# format.
     */
    @JvmName("xayplewjpqfjqkof")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The policy set definition description.
     */
    @JvmName("cxhlyjbawindbneq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name of the policy set definition.
     */
    @JvmName("fggbvmfcknefpbev")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the management group. The name is case insensitive.
     */
    @JvmName("oglxhvvgfkrujbha")
    public suspend fun managementGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementGroupName = mapped
    }

    /**
     * @param value The policy set definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
     */
    @JvmName("pfgqhdlrdilkcyxr")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The policy set definition parameters that can be used in policy definition references.
     */
    @JvmName("qhiepxflsanippad")
    public suspend fun parameters(`value`: Map<String, ParameterDefinitionsValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The policy set definition parameters that can be used in policy definition references.
     */
    @JvmName("qvdienjaiyxrttny")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterDefinitionsValueArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterDefinitionsValueArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The policy set definition parameters that can be used in policy definition references.
     */
    @JvmName("rrqdhyjmyfbxegjm")
    public fun parameters(vararg values: Pair<String, ParameterDefinitionsValueArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("fcibivdwqdcrbpwi")
    public suspend fun policyDefinitionGroups(`value`: List<PolicyDefinitionGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDefinitionGroups = mapped
    }

    /**
     * @param argument The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("kfuyyvuvplaiikgd")
    public suspend
    fun policyDefinitionGroups(argument: List<suspend PolicyDefinitionGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyDefinitionGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.policyDefinitionGroups = mapped
    }

    /**
     * @param argument The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("ncdutyyadgglvlfm")
    public suspend fun policyDefinitionGroups(
        vararg
        argument: suspend PolicyDefinitionGroupArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PolicyDefinitionGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.policyDefinitionGroups = mapped
    }

    /**
     * @param argument The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("vnchjvjftekfpbij")
    public suspend
    fun policyDefinitionGroups(argument: suspend PolicyDefinitionGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PolicyDefinitionGroupArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.policyDefinitionGroups = mapped
    }

    /**
     * @param values The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("rpuwgananiknidiw")
    public suspend fun policyDefinitionGroups(vararg values: PolicyDefinitionGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyDefinitionGroups = mapped
    }

    /**
     * @param value The policy set definition version.  The format is x.y.z where x is the major version number, y is the minor version number, and z is the patch number
     */
    @JvmName("xvpxbxvdanipnswu")
    public suspend fun policyDefinitionVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDefinitionVersion = mapped
    }

    /**
     * @param value An array of policy definition references.
     */
    @JvmName("tswdvbpnpsmitikn")
    public suspend fun policyDefinitions(`value`: List<PolicyDefinitionReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDefinitions = mapped
    }

    /**
     * @param argument An array of policy definition references.
     */
    @JvmName("xxrjmfhykgadmkut")
    public suspend
    fun policyDefinitions(argument: List<suspend PolicyDefinitionReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyDefinitionReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.policyDefinitions = mapped
    }

    /**
     * @param argument An array of policy definition references.
     */
    @JvmName("loaogtpujbstdstn")
    public suspend fun policyDefinitions(
        vararg
        argument: suspend PolicyDefinitionReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PolicyDefinitionReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.policyDefinitions = mapped
    }

    /**
     * @param argument An array of policy definition references.
     */
    @JvmName("nrsvmbyimwgtqhft")
    public suspend
    fun policyDefinitions(argument: suspend PolicyDefinitionReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PolicyDefinitionReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.policyDefinitions = mapped
    }

    /**
     * @param values An array of policy definition references.
     */
    @JvmName("mfcmemlvfgbsmnor")
    public suspend fun policyDefinitions(vararg values: PolicyDefinitionReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyDefinitions = mapped
    }

    /**
     * @param value The name of the policy set definition.
     */
    @JvmName("aujbqaiccknaeghs")
    public suspend fun policySetDefinitionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policySetDefinitionName = mapped
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("vidfyddsxuriuefk")
    public suspend fun policyType(`value`: Either<String, PolicyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("ouamqttmfsdmifjv")
    public fun policyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("pocwpqiallbnmgkh")
    public fun policyType(`value`: PolicyType) {
        val toBeMapped = Either.ofRight<String, PolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value The policy set definition version in #.#.# format.
     */
    @JvmName("dcdwbknaovmeqhfr")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): PolicySetDefinitionVersionAtManagementGroupArgs =
        PolicySetDefinitionVersionAtManagementGroupArgs(
            description = description,
            displayName = displayName,
            managementGroupName = managementGroupName,
            metadata = metadata,
            parameters = parameters,
            policyDefinitionGroups = policyDefinitionGroups,
            policyDefinitionVersion = policyDefinitionVersion,
            policyDefinitions = policyDefinitions,
            policySetDefinitionName = policySetDefinitionName,
            policyType = policyType,
            version = version,
        )
}
