@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.RoleDefinitionArgs.builder
import com.pulumi.azurenative.authorization.kotlin.inputs.PermissionArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.PermissionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Role definition.
 * Azure REST API version: 2022-05-01-preview. Prior API version in Azure Native 1.x: 2018-01-01-preview.
 * ## Example Usage
 * ### Create role definition
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleDefinition = new AzureNative.Authorization.RoleDefinition("roleDefinition", new()
 *     {
 *         RoleDefinitionId = "roleDefinitionId",
 *         Scope = "scope",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewRoleDefinition(ctx, "roleDefinition", &authorization.RoleDefinitionArgs{
 * 			RoleDefinitionId: pulumi.String("roleDefinitionId"),
 * 			Scope:            pulumi.String("scope"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.RoleDefinition;
 * import com.pulumi.azurenative.authorization.RoleDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleDefinition = new RoleDefinition("roleDefinition", RoleDefinitionArgs.builder()
 *             .roleDefinitionId("roleDefinitionId")
 *             .scope("scope")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:RoleDefinition roleDefinitionId /{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionId}
 * ```
 * @property assignableScopes Role definition assignable scopes.
 * @property description The role definition description.
 * @property permissions Role definition permissions.
 * @property roleDefinitionId The ID of the role definition.
 * @property roleName The role name.
 * @property roleType The role type.
 * @property scope The scope of the operation or resource. Valid scopes are: subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
 */
public data class RoleDefinitionArgs(
    public val assignableScopes: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val permissions: Output<List<PermissionArgs>>? = null,
    public val roleDefinitionId: Output<String>? = null,
    public val roleName: Output<String>? = null,
    public val roleType: Output<String>? = null,
    public val scope: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.RoleDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.RoleDefinitionArgs =
        com.pulumi.azurenative.authorization.RoleDefinitionArgs.builder()
            .assignableScopes(assignableScopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .permissions(
                permissions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .roleDefinitionId(roleDefinitionId?.applyValue({ args0 -> args0 }))
            .roleName(roleName?.applyValue({ args0 -> args0 }))
            .roleType(roleType?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoleDefinitionArgs].
 */
@PulumiTagMarker
public class RoleDefinitionArgsBuilder internal constructor() {
    private var assignableScopes: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var permissions: Output<List<PermissionArgs>>? = null

    private var roleDefinitionId: Output<String>? = null

    private var roleName: Output<String>? = null

    private var roleType: Output<String>? = null

    private var scope: Output<String>? = null

    /**
     * @param value Role definition assignable scopes.
     */
    @JvmName("sjdsgdyexxcdmbei")
    public suspend fun assignableScopes(`value`: Output<List<String>>) {
        this.assignableScopes = value
    }

    @JvmName("bmcjlmkkyyaclkfo")
    public suspend fun assignableScopes(vararg values: Output<String>) {
        this.assignableScopes = Output.all(values.asList())
    }

    /**
     * @param values Role definition assignable scopes.
     */
    @JvmName("myvtinaylvfgeege")
    public suspend fun assignableScopes(values: List<Output<String>>) {
        this.assignableScopes = Output.all(values)
    }

    /**
     * @param value The role definition description.
     */
    @JvmName("vsiusbdprgcxvxvx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Role definition permissions.
     */
    @JvmName("egcfocsmbhxyfogg")
    public suspend fun permissions(`value`: Output<List<PermissionArgs>>) {
        this.permissions = value
    }

    @JvmName("ujvqofoodfktkorc")
    public suspend fun permissions(vararg values: Output<PermissionArgs>) {
        this.permissions = Output.all(values.asList())
    }

    /**
     * @param values Role definition permissions.
     */
    @JvmName("maoufsotulfkkstr")
    public suspend fun permissions(values: List<Output<PermissionArgs>>) {
        this.permissions = Output.all(values)
    }

    /**
     * @param value The ID of the role definition.
     */
    @JvmName("aeitgnpnlrynxryf")
    public suspend fun roleDefinitionId(`value`: Output<String>) {
        this.roleDefinitionId = value
    }

    /**
     * @param value The role name.
     */
    @JvmName("qxiqyetmcchiyawj")
    public suspend fun roleName(`value`: Output<String>) {
        this.roleName = value
    }

    /**
     * @param value The role type.
     */
    @JvmName("wybtxdackfxydklp")
    public suspend fun roleType(`value`: Output<String>) {
        this.roleType = value
    }

    /**
     * @param value The scope of the operation or resource. Valid scopes are: subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
     */
    @JvmName("forljwfqamwmnmbk")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Role definition assignable scopes.
     */
    @JvmName("lrrnshcvrkcxjfcm")
    public suspend fun assignableScopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignableScopes = mapped
    }

    /**
     * @param values Role definition assignable scopes.
     */
    @JvmName("scntkxipiudjuyag")
    public suspend fun assignableScopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assignableScopes = mapped
    }

    /**
     * @param value The role definition description.
     */
    @JvmName("rxcrfdehspuqyjpt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Role definition permissions.
     */
    @JvmName("vxiopqqioovijkup")
    public suspend fun permissions(`value`: List<PermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param argument Role definition permissions.
     */
    @JvmName("odktyihyhwofjvei")
    public suspend fun permissions(argument: List<suspend PermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { PermissionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument Role definition permissions.
     */
    @JvmName("seuwpychrvcnlwgm")
    public suspend fun permissions(vararg argument: suspend PermissionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { PermissionArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument Role definition permissions.
     */
    @JvmName("yytupvopdhvsxkva")
    public suspend fun permissions(argument: suspend PermissionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PermissionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param values Role definition permissions.
     */
    @JvmName("aokyynwxqdhithso")
    public suspend fun permissions(vararg values: PermissionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value The ID of the role definition.
     */
    @JvmName("rybxntteypbkcuwn")
    public suspend fun roleDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleDefinitionId = mapped
    }

    /**
     * @param value The role name.
     */
    @JvmName("eqbjouaivfqfdosx")
    public suspend fun roleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleName = mapped
    }

    /**
     * @param value The role type.
     */
    @JvmName("tpookmghfhjicyox")
    public suspend fun roleType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleType = mapped
    }

    /**
     * @param value The scope of the operation or resource. Valid scopes are: subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
     */
    @JvmName("buwwmcbwvvlfbfqp")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): RoleDefinitionArgs = RoleDefinitionArgs(
        assignableScopes = assignableScopes,
        description = description,
        permissions = permissions,
        roleDefinitionId = roleDefinitionId,
        roleName = roleName,
        roleType = roleType,
        scope = scope,
    )
}
