@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.kotlin.outputs.PolicyAssignmentPropertiesResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.PolicyAssignmentPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [RoleManagementPolicyAssignment].
 */
@PulumiTagMarker
public class RoleManagementPolicyAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RoleManagementPolicyAssignmentArgs = RoleManagementPolicyAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RoleManagementPolicyAssignmentArgsBuilder.() -> Unit) {
        val builder = RoleManagementPolicyAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RoleManagementPolicyAssignment {
        val builtJavaResource =
            com.pulumi.azurenative.authorization.RoleManagementPolicyAssignment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RoleManagementPolicyAssignment(builtJavaResource)
    }
}

/**
 * Role management policy
 * Azure REST API version: 2020-10-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2020-10-01-preview.
 * ## Example Usage
 * ### PutRoleManagementPolicyAssignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var roleManagementPolicyAssignment = new AzureNative.Authorization.RoleManagementPolicyAssignment("roleManagementPolicyAssignment", new()
 *     {
 *         PolicyId = "/subscriptions/129ff972-28f8-46b8-a726-e497be039368/providers/Microsoft.Authorization/roleManagementPolicies/b959d571-f0b5-4042-88a7-01be6cb22db9",
 *         RoleDefinitionId = "/subscriptions/129ff972-28f8-46b8-a726-e497be039368/providers/Microsoft.Authorization/roleDefinitions/a1705bd2-3a8f-45a5-8683-466fcfd5cc24",
 *         RoleManagementPolicyAssignmentName = "b959d571-f0b5-4042-88a7-01be6cb22db9_a1705bd2-3a8f-45a5-8683-466fcfd5cc24",
 *         Scope = "providers/Microsoft.Subscription/subscriptions/129ff972-28f8-46b8-a726-e497be039368",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewRoleManagementPolicyAssignment(ctx, "roleManagementPolicyAssignment", &authorization.RoleManagementPolicyAssignmentArgs{
 * 			PolicyId:                           pulumi.String("/subscriptions/129ff972-28f8-46b8-a726-e497be039368/providers/Microsoft.Authorization/roleManagementPolicies/b959d571-f0b5-4042-88a7-01be6cb22db9"),
 * 			RoleDefinitionId:                   pulumi.String("/subscriptions/129ff972-28f8-46b8-a726-e497be039368/providers/Microsoft.Authorization/roleDefinitions/a1705bd2-3a8f-45a5-8683-466fcfd5cc24"),
 * 			RoleManagementPolicyAssignmentName: pulumi.String("b959d571-f0b5-4042-88a7-01be6cb22db9_a1705bd2-3a8f-45a5-8683-466fcfd5cc24"),
 * 			Scope:                              pulumi.String("providers/Microsoft.Subscription/subscriptions/129ff972-28f8-46b8-a726-e497be039368"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.RoleManagementPolicyAssignment;
 * import com.pulumi.azurenative.authorization.RoleManagementPolicyAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var roleManagementPolicyAssignment = new RoleManagementPolicyAssignment("roleManagementPolicyAssignment", RoleManagementPolicyAssignmentArgs.builder()
 *             .policyId("/subscriptions/129ff972-28f8-46b8-a726-e497be039368/providers/Microsoft.Authorization/roleManagementPolicies/b959d571-f0b5-4042-88a7-01be6cb22db9")
 *             .roleDefinitionId("/subscriptions/129ff972-28f8-46b8-a726-e497be039368/providers/Microsoft.Authorization/roleDefinitions/a1705bd2-3a8f-45a5-8683-466fcfd5cc24")
 *             .roleManagementPolicyAssignmentName("b959d571-f0b5-4042-88a7-01be6cb22db9_a1705bd2-3a8f-45a5-8683-466fcfd5cc24")
 *             .scope("providers/Microsoft.Subscription/subscriptions/129ff972-28f8-46b8-a726-e497be039368")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:RoleManagementPolicyAssignment b959d571-f0b5-4042-88a7-01be6cb22db9_a1705bd2-3a8f-45a5-8683-466fcfd5cc24 /{scope}/providers/Microsoft.Authorization/roleManagementPolicyAssignments/{roleManagementPolicyAssignmentName}
 * ```
 */
public class RoleManagementPolicyAssignment internal constructor(
    override val javaResource: com.pulumi.azurenative.authorization.RoleManagementPolicyAssignment,
) : KotlinCustomResource(javaResource, RoleManagementPolicyAssignmentMapper) {
    /**
     * The readonly computed rule applied to the policy.
     */
    public val effectiveRules: Output<List<Any>>
        get() = javaResource.effectiveRules().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The role management policy name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Additional properties of scope, role definition and policy
     */
    public val policyAssignmentProperties: Output<PolicyAssignmentPropertiesResponse>
        get() = javaResource.policyAssignmentProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The policy id role management policy assignment.
     */
    public val policyId: Output<String>?
        get() = javaResource.policyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The role definition of management policy assignment.
     */
    public val roleDefinitionId: Output<String>?
        get() = javaResource.roleDefinitionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The role management policy scope.
     */
    public val scope: Output<String>?
        get() = javaResource.scope().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The role management policy type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RoleManagementPolicyAssignmentMapper : ResourceMapper<RoleManagementPolicyAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.authorization.RoleManagementPolicyAssignment::class == javaResource::class

    override fun map(javaResource: Resource): RoleManagementPolicyAssignment =
        RoleManagementPolicyAssignment(
            javaResource as
                com.pulumi.azurenative.authorization.RoleManagementPolicyAssignment,
        )
}

/**
 * @see [RoleManagementPolicyAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RoleManagementPolicyAssignment].
 */
public suspend fun roleManagementPolicyAssignment(
    name: String,
    block: suspend RoleManagementPolicyAssignmentResourceBuilder.() -> Unit,
):
    RoleManagementPolicyAssignment {
    val builder = RoleManagementPolicyAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RoleManagementPolicyAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun roleManagementPolicyAssignment(name: String): RoleManagementPolicyAssignment {
    val builder = RoleManagementPolicyAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
