@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.ScopeAccessReviewHistoryDefinitionByIdArgs.builder
import com.pulumi.azurenative.authorization.kotlin.enums.AccessReviewRecurrenceRangeType
import com.pulumi.azurenative.authorization.kotlin.enums.AccessReviewResult
import com.pulumi.azurenative.authorization.kotlin.inputs.AccessReviewHistoryInstanceArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.AccessReviewHistoryInstanceArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.AccessReviewScopeArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.AccessReviewScopeArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Access Review History Definition.
 * Azure REST API version: 2021-12-01-preview. Prior API version in Azure Native 1.x: 2021-12-01-preview.
 * ## Example Usage
 * ### PutAccessReviewHistoryDefinition
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scopeAccessReviewHistoryDefinitionById = new AzureNative.Authorization.ScopeAccessReviewHistoryDefinitionById("scopeAccessReviewHistoryDefinitionById", new()
 *     {
 *         HistoryDefinitionId = "44724910-d7a5-4c29-b28f-db73e717165a",
 *         Scope = "subscriptions/129a304b-4aea-4b86-a9f7-ba7e2b23737a",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewScopeAccessReviewHistoryDefinitionById(ctx, "scopeAccessReviewHistoryDefinitionById", &authorization.ScopeAccessReviewHistoryDefinitionByIdArgs{
 * 			HistoryDefinitionId: pulumi.String("44724910-d7a5-4c29-b28f-db73e717165a"),
 * 			Scope:               pulumi.String("subscriptions/129a304b-4aea-4b86-a9f7-ba7e2b23737a"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.ScopeAccessReviewHistoryDefinitionById;
 * import com.pulumi.azurenative.authorization.ScopeAccessReviewHistoryDefinitionByIdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scopeAccessReviewHistoryDefinitionById = new ScopeAccessReviewHistoryDefinitionById("scopeAccessReviewHistoryDefinitionById", ScopeAccessReviewHistoryDefinitionByIdArgs.builder()
 *             .historyDefinitionId("44724910-d7a5-4c29-b28f-db73e717165a")
 *             .scope("subscriptions/129a304b-4aea-4b86-a9f7-ba7e2b23737a")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:ScopeAccessReviewHistoryDefinitionById 44724910-d7a5-4c29-b28f-db73e717165a /{scope}/providers/Microsoft.Authorization/accessReviewHistoryDefinitions/{historyDefinitionId}
 * ```
 * @property decisions Collection of review decisions which the history data should be filtered on. For example if Approve and Deny are supplied the data will only contain review results in which the decision maker approved or denied a review request.
 * @property displayName The display name for the history definition.
 * @property endDate The DateTime when the review is scheduled to end. Required if type is endDate
 * @property historyDefinitionId The id of the access review history definition.
 * @property instances Set of access review history instances for this history definition.
 * @property interval The interval for recurrence. For a quarterly review, the interval is 3 for type : absoluteMonthly.
 * @property numberOfOccurrences The number of times to repeat the access review. Required and must be positive if type is numbered.
 * @property scope The scope of the resource.
 * @property scopes A collection of scopes used when selecting review history data
 * @property startDate The DateTime when the review is scheduled to be start. This could be a date in the future. Required on create.
 * @property type The recurrence range type. The possible values are: endDate, noEnd, numbered.
 */
public data class ScopeAccessReviewHistoryDefinitionByIdArgs(
    public val decisions: Output<List<Either<String, AccessReviewResult>>>? = null,
    public val displayName: Output<String>? = null,
    public val endDate: Output<String>? = null,
    public val historyDefinitionId: Output<String>? = null,
    public val instances: Output<List<AccessReviewHistoryInstanceArgs>>? = null,
    public val interval: Output<Int>? = null,
    public val numberOfOccurrences: Output<Int>? = null,
    public val scope: Output<String>? = null,
    public val scopes: Output<List<AccessReviewScopeArgs>>? = null,
    public val startDate: Output<String>? = null,
    public val type: Output<Either<String, AccessReviewRecurrenceRangeType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.ScopeAccessReviewHistoryDefinitionByIdArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.ScopeAccessReviewHistoryDefinitionByIdArgs =
        com.pulumi.azurenative.authorization.ScopeAccessReviewHistoryDefinitionByIdArgs.builder()
            .decisions(
                decisions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .endDate(endDate?.applyValue({ args0 -> args0 }))
            .historyDefinitionId(historyDefinitionId?.applyValue({ args0 -> args0 }))
            .instances(
                instances?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .interval(interval?.applyValue({ args0 -> args0 }))
            .numberOfOccurrences(numberOfOccurrences?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .scopes(scopes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .startDate(startDate?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ScopeAccessReviewHistoryDefinitionByIdArgs].
 */
@PulumiTagMarker
public class ScopeAccessReviewHistoryDefinitionByIdArgsBuilder internal constructor() {
    private var decisions: Output<List<Either<String, AccessReviewResult>>>? = null

    private var displayName: Output<String>? = null

    private var endDate: Output<String>? = null

    private var historyDefinitionId: Output<String>? = null

    private var instances: Output<List<AccessReviewHistoryInstanceArgs>>? = null

    private var interval: Output<Int>? = null

    private var numberOfOccurrences: Output<Int>? = null

    private var scope: Output<String>? = null

    private var scopes: Output<List<AccessReviewScopeArgs>>? = null

    private var startDate: Output<String>? = null

    private var type: Output<Either<String, AccessReviewRecurrenceRangeType>>? = null

    /**
     * @param value Collection of review decisions which the history data should be filtered on. For example if Approve and Deny are supplied the data will only contain review results in which the decision maker approved or denied a review request.
     */
    @JvmName("jtpmbgkklsxgttwg")
    public suspend fun decisions(`value`: Output<List<Either<String, AccessReviewResult>>>) {
        this.decisions = value
    }

    @JvmName("hgbnmupxrefeovjb")
    public suspend fun decisions(vararg values: Output<Either<String, AccessReviewResult>>) {
        this.decisions = Output.all(values.asList())
    }

    /**
     * @param values Collection of review decisions which the history data should be filtered on. For example if Approve and Deny are supplied the data will only contain review results in which the decision maker approved or denied a review request.
     */
    @JvmName("vsnsefstoomvqdoo")
    public suspend fun decisions(values: List<Output<Either<String, AccessReviewResult>>>) {
        this.decisions = Output.all(values)
    }

    /**
     * @param value The display name for the history definition.
     */
    @JvmName("cexxvidwmgwavuon")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The DateTime when the review is scheduled to end. Required if type is endDate
     */
    @JvmName("pidjtxhuotfljfds")
    public suspend fun endDate(`value`: Output<String>) {
        this.endDate = value
    }

    /**
     * @param value The id of the access review history definition.
     */
    @JvmName("dvqwuhppqqsbkjlr")
    public suspend fun historyDefinitionId(`value`: Output<String>) {
        this.historyDefinitionId = value
    }

    /**
     * @param value Set of access review history instances for this history definition.
     */
    @JvmName("lgfpeimjgscauouc")
    public suspend fun instances(`value`: Output<List<AccessReviewHistoryInstanceArgs>>) {
        this.instances = value
    }

    @JvmName("glcyiycppfgfbrwk")
    public suspend fun instances(vararg values: Output<AccessReviewHistoryInstanceArgs>) {
        this.instances = Output.all(values.asList())
    }

    /**
     * @param values Set of access review history instances for this history definition.
     */
    @JvmName("jtaoseydslobxucr")
    public suspend fun instances(values: List<Output<AccessReviewHistoryInstanceArgs>>) {
        this.instances = Output.all(values)
    }

    /**
     * @param value The interval for recurrence. For a quarterly review, the interval is 3 for type : absoluteMonthly.
     */
    @JvmName("heoxdbnvjfsvlomq")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value The number of times to repeat the access review. Required and must be positive if type is numbered.
     */
    @JvmName("wjgjforuelqhcnni")
    public suspend fun numberOfOccurrences(`value`: Output<Int>) {
        this.numberOfOccurrences = value
    }

    /**
     * @param value The scope of the resource.
     */
    @JvmName("luigfnyqyvjeyntv")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value A collection of scopes used when selecting review history data
     */
    @JvmName("opbyspoepqxyjyfj")
    public suspend fun scopes(`value`: Output<List<AccessReviewScopeArgs>>) {
        this.scopes = value
    }

    @JvmName("yqbfkjyxarttxllt")
    public suspend fun scopes(vararg values: Output<AccessReviewScopeArgs>) {
        this.scopes = Output.all(values.asList())
    }

    /**
     * @param values A collection of scopes used when selecting review history data
     */
    @JvmName("fjstrhvhkivorvup")
    public suspend fun scopes(values: List<Output<AccessReviewScopeArgs>>) {
        this.scopes = Output.all(values)
    }

    /**
     * @param value The DateTime when the review is scheduled to be start. This could be a date in the future. Required on create.
     */
    @JvmName("nhfafamndiddspuw")
    public suspend fun startDate(`value`: Output<String>) {
        this.startDate = value
    }

    /**
     * @param value The recurrence range type. The possible values are: endDate, noEnd, numbered.
     */
    @JvmName("ewtpugqfgkioyxxu")
    public suspend fun type(`value`: Output<Either<String, AccessReviewRecurrenceRangeType>>) {
        this.type = value
    }

    /**
     * @param value Collection of review decisions which the history data should be filtered on. For example if Approve and Deny are supplied the data will only contain review results in which the decision maker approved or denied a review request.
     */
    @JvmName("bjaxgixsxcnkywxw")
    public suspend fun decisions(`value`: List<Either<String, AccessReviewResult>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.decisions = mapped
    }

    /**
     * @param values Collection of review decisions which the history data should be filtered on. For example if Approve and Deny are supplied the data will only contain review results in which the decision maker approved or denied a review request.
     */
    @JvmName("hhubbhqnrhgpexda")
    public suspend fun decisions(vararg values: Either<String, AccessReviewResult>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.decisions = mapped
    }

    /**
     * @param value The display name for the history definition.
     */
    @JvmName("mtrnbgoswefahxkr")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The DateTime when the review is scheduled to end. Required if type is endDate
     */
    @JvmName("goskboqxsxirpesi")
    public suspend fun endDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endDate = mapped
    }

    /**
     * @param value The id of the access review history definition.
     */
    @JvmName("doxucsuvkfvgoobc")
    public suspend fun historyDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.historyDefinitionId = mapped
    }

    /**
     * @param value Set of access review history instances for this history definition.
     */
    @JvmName("xrolmqdutappwrhw")
    public suspend fun instances(`value`: List<AccessReviewHistoryInstanceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instances = mapped
    }

    /**
     * @param argument Set of access review history instances for this history definition.
     */
    @JvmName("pajbgonbqdqbpltt")
    public suspend
    fun instances(argument: List<suspend AccessReviewHistoryInstanceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AccessReviewHistoryInstanceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.instances = mapped
    }

    /**
     * @param argument Set of access review history instances for this history definition.
     */
    @JvmName("omprscmjqhyiofsa")
    public suspend fun instances(
        vararg
        argument: suspend AccessReviewHistoryInstanceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AccessReviewHistoryInstanceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.instances = mapped
    }

    /**
     * @param argument Set of access review history instances for this history definition.
     */
    @JvmName("ernmffeigywgrqge")
    public suspend
    fun instances(argument: suspend AccessReviewHistoryInstanceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AccessReviewHistoryInstanceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.instances = mapped
    }

    /**
     * @param values Set of access review history instances for this history definition.
     */
    @JvmName("fekvfgospbiauadd")
    public suspend fun instances(vararg values: AccessReviewHistoryInstanceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instances = mapped
    }

    /**
     * @param value The interval for recurrence. For a quarterly review, the interval is 3 for type : absoluteMonthly.
     */
    @JvmName("mlpsqihqmcdbrugv")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value The number of times to repeat the access review. Required and must be positive if type is numbered.
     */
    @JvmName("fqasjvxnikafovsn")
    public suspend fun numberOfOccurrences(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfOccurrences = mapped
    }

    /**
     * @param value The scope of the resource.
     */
    @JvmName("ysiqnttdcnilxdkj")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value A collection of scopes used when selecting review history data
     */
    @JvmName("ddmcfsslhjcmhcdq")
    public suspend fun scopes(`value`: List<AccessReviewScopeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param argument A collection of scopes used when selecting review history data
     */
    @JvmName("swrspcmhdioxxnus")
    public suspend fun scopes(argument: List<suspend AccessReviewScopeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AccessReviewScopeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.scopes = mapped
    }

    /**
     * @param argument A collection of scopes used when selecting review history data
     */
    @JvmName("cytxkbljmlovrtyl")
    public suspend fun scopes(vararg argument: suspend AccessReviewScopeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AccessReviewScopeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.scopes = mapped
    }

    /**
     * @param argument A collection of scopes used when selecting review history data
     */
    @JvmName("ffbnevvfhkxvjowb")
    public suspend fun scopes(argument: suspend AccessReviewScopeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AccessReviewScopeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.scopes = mapped
    }

    /**
     * @param values A collection of scopes used when selecting review history data
     */
    @JvmName("vsrspgehlsjopass")
    public suspend fun scopes(vararg values: AccessReviewScopeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param value The DateTime when the review is scheduled to be start. This could be a date in the future. Required on create.
     */
    @JvmName("iutcoufyogkwvajh")
    public suspend fun startDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startDate = mapped
    }

    /**
     * @param value The recurrence range type. The possible values are: endDate, noEnd, numbered.
     */
    @JvmName("nmjvhcnpghrieybg")
    public suspend fun type(`value`: Either<String, AccessReviewRecurrenceRangeType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The recurrence range type. The possible values are: endDate, noEnd, numbered.
     */
    @JvmName("vpryfldjxdmlcgnp")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AccessReviewRecurrenceRangeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The recurrence range type. The possible values are: endDate, noEnd, numbered.
     */
    @JvmName("cuisnlthurlheola")
    public fun type(`value`: AccessReviewRecurrenceRangeType) {
        val toBeMapped = Either.ofRight<String, AccessReviewRecurrenceRangeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ScopeAccessReviewHistoryDefinitionByIdArgs =
        ScopeAccessReviewHistoryDefinitionByIdArgs(
            decisions = decisions,
            displayName = displayName,
            endDate = endDate,
            historyDefinitionId = historyDefinitionId,
            instances = instances,
            interval = interval,
            numberOfOccurrences = numberOfOccurrences,
            scope = scope,
            scopes = scopes,
            startDate = startDate,
            type = type,
        )
}
