@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.ScopeAccessReviewScheduleDefinitionByIdArgs.builder
import com.pulumi.azurenative.authorization.kotlin.enums.AccessReviewRecurrenceRangeType
import com.pulumi.azurenative.authorization.kotlin.enums.DefaultDecisionType
import com.pulumi.azurenative.authorization.kotlin.inputs.AccessReviewInstanceArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.AccessReviewInstanceArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.AccessReviewReviewerArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.AccessReviewReviewerArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Access Review Schedule Definition.
 * Azure REST API version: 2021-12-01-preview. Prior API version in Azure Native 1.x: 2021-12-01-preview.
 * ## Example Usage
 * ### PutAccessReview
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scopeAccessReviewScheduleDefinitionById = new AzureNative.Authorization.ScopeAccessReviewScheduleDefinitionById("scopeAccessReviewScheduleDefinitionById", new()
 *     {
 *         ScheduleDefinitionId = "fa73e90b-5bf1-45fd-a182-35ce5fc0674d",
 *         Scope = "subscriptions/fa73e90b-5bf1-45fd-a182-35ce5fc0674d",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewScopeAccessReviewScheduleDefinitionById(ctx, "scopeAccessReviewScheduleDefinitionById", &authorization.ScopeAccessReviewScheduleDefinitionByIdArgs{
 * 			ScheduleDefinitionId: pulumi.String("fa73e90b-5bf1-45fd-a182-35ce5fc0674d"),
 * 			Scope:                pulumi.String("subscriptions/fa73e90b-5bf1-45fd-a182-35ce5fc0674d"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.ScopeAccessReviewScheduleDefinitionById;
 * import com.pulumi.azurenative.authorization.ScopeAccessReviewScheduleDefinitionByIdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scopeAccessReviewScheduleDefinitionById = new ScopeAccessReviewScheduleDefinitionById("scopeAccessReviewScheduleDefinitionById", ScopeAccessReviewScheduleDefinitionByIdArgs.builder()
 *             .scheduleDefinitionId("fa73e90b-5bf1-45fd-a182-35ce5fc0674d")
 *             .scope("subscriptions/fa73e90b-5bf1-45fd-a182-35ce5fc0674d")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:ScopeAccessReviewScheduleDefinitionById fa73e90b-5bf1-45fd-a182-35ce5fc0674d /{scope}/providers/Microsoft.Authorization/accessReviewScheduleDefinitions/{scheduleDefinitionId}
 * ```
 * @property autoApplyDecisionsEnabled Flag to indicate whether auto-apply capability, to automatically change the target object access resource, is enabled. If not enabled, a user must, after the review completes, apply the access review.
 * @property backupReviewers This is the collection of backup reviewers.
 * @property defaultDecision This specifies the behavior for the autoReview feature when an access review completes.
 * @property defaultDecisionEnabled Flag to indicate whether reviewers are required to provide a justification when reviewing access.
 * @property descriptionForAdmins The description provided by the access review creator and visible to admins.
 * @property descriptionForReviewers The description provided by the access review creator to be shown to reviewers.
 * @property displayName The display name for the schedule definition.
 * @property endDate The DateTime when the review is scheduled to end. Required if type is endDate
 * @property excludeResourceId This is used to indicate the resource id(s) to exclude
 * @property excludeRoleDefinitionId This is used to indicate the role definition id(s) to exclude
 * @property expandNestedMemberships Flag to indicate whether to expand nested memberships or not.
 * @property inactiveDuration Duration users are inactive for. The value should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds))
 * @property includeAccessBelowResource Flag to indicate whether to expand nested memberships or not.
 * @property includeInheritedAccess Flag to indicate whether to expand nested memberships or not.
 * @property instanceDurationInDays The duration in days for an instance.
 * @property instances This is the collection of instances returned when one does an expand on it.
 * @property interval The interval for recurrence. For a quarterly review, the interval is 3 for type : absoluteMonthly.
 * @property justificationRequiredOnApproval Flag to indicate whether the reviewer is required to pass justification when recording a decision.
 * @property mailNotificationsEnabled Flag to indicate whether sending mails to reviewers and the review creator is enabled.
 * @property numberOfOccurrences The number of times to repeat the access review. Required and must be positive if type is numbered.
 * @property recommendationLookBackDuration Recommendations for access reviews are calculated by looking back at 30 days of data(w.r.t the start date of the review) by default. However, in some scenarios, customers want to change how far back to look at and want to configure 60 days, 90 days, etc. instead. This setting allows customers to configure this duration. The value should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds))
 * @property recommendationsEnabled Flag to indicate whether showing recommendations to reviewers is enabled.
 * @property reminderNotificationsEnabled Flag to indicate whether sending reminder emails to reviewers are enabled.
 * @property reviewers This is the collection of reviewers.
 * @property scheduleDefinitionId The id of the access review schedule definition.
 * @property scope The scope of the resource.
 * @property startDate The DateTime when the review is scheduled to be start. This could be a date in the future. Required on create.
 * @property type The recurrence range type. The possible values are: endDate, noEnd, numbered.
 */
public data class ScopeAccessReviewScheduleDefinitionByIdArgs(
    public val autoApplyDecisionsEnabled: Output<Boolean>? = null,
    public val backupReviewers: Output<List<AccessReviewReviewerArgs>>? = null,
    public val defaultDecision: Output<Either<String, DefaultDecisionType>>? = null,
    public val defaultDecisionEnabled: Output<Boolean>? = null,
    public val descriptionForAdmins: Output<String>? = null,
    public val descriptionForReviewers: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val endDate: Output<String>? = null,
    public val excludeResourceId: Output<String>? = null,
    public val excludeRoleDefinitionId: Output<String>? = null,
    public val expandNestedMemberships: Output<Boolean>? = null,
    public val inactiveDuration: Output<String>? = null,
    public val includeAccessBelowResource: Output<Boolean>? = null,
    public val includeInheritedAccess: Output<Boolean>? = null,
    public val instanceDurationInDays: Output<Int>? = null,
    public val instances: Output<List<AccessReviewInstanceArgs>>? = null,
    public val interval: Output<Int>? = null,
    public val justificationRequiredOnApproval: Output<Boolean>? = null,
    public val mailNotificationsEnabled: Output<Boolean>? = null,
    public val numberOfOccurrences: Output<Int>? = null,
    public val recommendationLookBackDuration: Output<String>? = null,
    public val recommendationsEnabled: Output<Boolean>? = null,
    public val reminderNotificationsEnabled: Output<Boolean>? = null,
    public val reviewers: Output<List<AccessReviewReviewerArgs>>? = null,
    public val scheduleDefinitionId: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val startDate: Output<String>? = null,
    public val type: Output<Either<String, AccessReviewRecurrenceRangeType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.ScopeAccessReviewScheduleDefinitionByIdArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.ScopeAccessReviewScheduleDefinitionByIdArgs =
        com.pulumi.azurenative.authorization.ScopeAccessReviewScheduleDefinitionByIdArgs.builder()
            .autoApplyDecisionsEnabled(autoApplyDecisionsEnabled?.applyValue({ args0 -> args0 }))
            .backupReviewers(
                backupReviewers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultDecision(
                defaultDecision?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .defaultDecisionEnabled(defaultDecisionEnabled?.applyValue({ args0 -> args0 }))
            .descriptionForAdmins(descriptionForAdmins?.applyValue({ args0 -> args0 }))
            .descriptionForReviewers(descriptionForReviewers?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .endDate(endDate?.applyValue({ args0 -> args0 }))
            .excludeResourceId(excludeResourceId?.applyValue({ args0 -> args0 }))
            .excludeRoleDefinitionId(excludeRoleDefinitionId?.applyValue({ args0 -> args0 }))
            .expandNestedMemberships(expandNestedMemberships?.applyValue({ args0 -> args0 }))
            .inactiveDuration(inactiveDuration?.applyValue({ args0 -> args0 }))
            .includeAccessBelowResource(includeAccessBelowResource?.applyValue({ args0 -> args0 }))
            .includeInheritedAccess(includeInheritedAccess?.applyValue({ args0 -> args0 }))
            .instanceDurationInDays(instanceDurationInDays?.applyValue({ args0 -> args0 }))
            .instances(
                instances?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .interval(interval?.applyValue({ args0 -> args0 }))
            .justificationRequiredOnApproval(justificationRequiredOnApproval?.applyValue({ args0 -> args0 }))
            .mailNotificationsEnabled(mailNotificationsEnabled?.applyValue({ args0 -> args0 }))
            .numberOfOccurrences(numberOfOccurrences?.applyValue({ args0 -> args0 }))
            .recommendationLookBackDuration(recommendationLookBackDuration?.applyValue({ args0 -> args0 }))
            .recommendationsEnabled(recommendationsEnabled?.applyValue({ args0 -> args0 }))
            .reminderNotificationsEnabled(reminderNotificationsEnabled?.applyValue({ args0 -> args0 }))
            .reviewers(
                reviewers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .scheduleDefinitionId(scheduleDefinitionId?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .startDate(startDate?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ScopeAccessReviewScheduleDefinitionByIdArgs].
 */
@PulumiTagMarker
public class ScopeAccessReviewScheduleDefinitionByIdArgsBuilder internal constructor() {
    private var autoApplyDecisionsEnabled: Output<Boolean>? = null

    private var backupReviewers: Output<List<AccessReviewReviewerArgs>>? = null

    private var defaultDecision: Output<Either<String, DefaultDecisionType>>? = null

    private var defaultDecisionEnabled: Output<Boolean>? = null

    private var descriptionForAdmins: Output<String>? = null

    private var descriptionForReviewers: Output<String>? = null

    private var displayName: Output<String>? = null

    private var endDate: Output<String>? = null

    private var excludeResourceId: Output<String>? = null

    private var excludeRoleDefinitionId: Output<String>? = null

    private var expandNestedMemberships: Output<Boolean>? = null

    private var inactiveDuration: Output<String>? = null

    private var includeAccessBelowResource: Output<Boolean>? = null

    private var includeInheritedAccess: Output<Boolean>? = null

    private var instanceDurationInDays: Output<Int>? = null

    private var instances: Output<List<AccessReviewInstanceArgs>>? = null

    private var interval: Output<Int>? = null

    private var justificationRequiredOnApproval: Output<Boolean>? = null

    private var mailNotificationsEnabled: Output<Boolean>? = null

    private var numberOfOccurrences: Output<Int>? = null

    private var recommendationLookBackDuration: Output<String>? = null

    private var recommendationsEnabled: Output<Boolean>? = null

    private var reminderNotificationsEnabled: Output<Boolean>? = null

    private var reviewers: Output<List<AccessReviewReviewerArgs>>? = null

    private var scheduleDefinitionId: Output<String>? = null

    private var scope: Output<String>? = null

    private var startDate: Output<String>? = null

    private var type: Output<Either<String, AccessReviewRecurrenceRangeType>>? = null

    /**
     * @param value Flag to indicate whether auto-apply capability, to automatically change the target object access resource, is enabled. If not enabled, a user must, after the review completes, apply the access review.
     */
    @JvmName("oxsbejtgnjpfyomp")
    public suspend fun autoApplyDecisionsEnabled(`value`: Output<Boolean>) {
        this.autoApplyDecisionsEnabled = value
    }

    /**
     * @param value This is the collection of backup reviewers.
     */
    @JvmName("mwxpestlgukjprlc")
    public suspend fun backupReviewers(`value`: Output<List<AccessReviewReviewerArgs>>) {
        this.backupReviewers = value
    }

    @JvmName("kbocyjyrtcvruump")
    public suspend fun backupReviewers(vararg values: Output<AccessReviewReviewerArgs>) {
        this.backupReviewers = Output.all(values.asList())
    }

    /**
     * @param values This is the collection of backup reviewers.
     */
    @JvmName("oxgbutqdapricdgd")
    public suspend fun backupReviewers(values: List<Output<AccessReviewReviewerArgs>>) {
        this.backupReviewers = Output.all(values)
    }

    /**
     * @param value This specifies the behavior for the autoReview feature when an access review completes.
     */
    @JvmName("pscjmveosukdfnkf")
    public suspend fun defaultDecision(`value`: Output<Either<String, DefaultDecisionType>>) {
        this.defaultDecision = value
    }

    /**
     * @param value Flag to indicate whether reviewers are required to provide a justification when reviewing access.
     */
    @JvmName("ofjaxgpmoosklrdk")
    public suspend fun defaultDecisionEnabled(`value`: Output<Boolean>) {
        this.defaultDecisionEnabled = value
    }

    /**
     * @param value The description provided by the access review creator and visible to admins.
     */
    @JvmName("vbdfypagayaqadty")
    public suspend fun descriptionForAdmins(`value`: Output<String>) {
        this.descriptionForAdmins = value
    }

    /**
     * @param value The description provided by the access review creator to be shown to reviewers.
     */
    @JvmName("gvornjevkaahumya")
    public suspend fun descriptionForReviewers(`value`: Output<String>) {
        this.descriptionForReviewers = value
    }

    /**
     * @param value The display name for the schedule definition.
     */
    @JvmName("ukdptwdqsfurqasu")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The DateTime when the review is scheduled to end. Required if type is endDate
     */
    @JvmName("eabdjvrvulmhmtpe")
    public suspend fun endDate(`value`: Output<String>) {
        this.endDate = value
    }

    /**
     * @param value This is used to indicate the resource id(s) to exclude
     */
    @JvmName("blnohhgihfbtnwke")
    public suspend fun excludeResourceId(`value`: Output<String>) {
        this.excludeResourceId = value
    }

    /**
     * @param value This is used to indicate the role definition id(s) to exclude
     */
    @JvmName("ykwwjkqafjwgxcng")
    public suspend fun excludeRoleDefinitionId(`value`: Output<String>) {
        this.excludeRoleDefinitionId = value
    }

    /**
     * @param value Flag to indicate whether to expand nested memberships or not.
     */
    @JvmName("rlunssxgcfuuesnk")
    public suspend fun expandNestedMemberships(`value`: Output<Boolean>) {
        this.expandNestedMemberships = value
    }

    /**
     * @param value Duration users are inactive for. The value should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds))
     */
    @JvmName("cywwirukoytxsdou")
    public suspend fun inactiveDuration(`value`: Output<String>) {
        this.inactiveDuration = value
    }

    /**
     * @param value Flag to indicate whether to expand nested memberships or not.
     */
    @JvmName("hicmauojmcnaaoig")
    public suspend fun includeAccessBelowResource(`value`: Output<Boolean>) {
        this.includeAccessBelowResource = value
    }

    /**
     * @param value Flag to indicate whether to expand nested memberships or not.
     */
    @JvmName("wexmaqyltoptgrjb")
    public suspend fun includeInheritedAccess(`value`: Output<Boolean>) {
        this.includeInheritedAccess = value
    }

    /**
     * @param value The duration in days for an instance.
     */
    @JvmName("evgdvyfxgslbcpop")
    public suspend fun instanceDurationInDays(`value`: Output<Int>) {
        this.instanceDurationInDays = value
    }

    /**
     * @param value This is the collection of instances returned when one does an expand on it.
     */
    @JvmName("kerrteuoflastoaf")
    public suspend fun instances(`value`: Output<List<AccessReviewInstanceArgs>>) {
        this.instances = value
    }

    @JvmName("hcisdjkbwweihthq")
    public suspend fun instances(vararg values: Output<AccessReviewInstanceArgs>) {
        this.instances = Output.all(values.asList())
    }

    /**
     * @param values This is the collection of instances returned when one does an expand on it.
     */
    @JvmName("okedoivyojqiphqh")
    public suspend fun instances(values: List<Output<AccessReviewInstanceArgs>>) {
        this.instances = Output.all(values)
    }

    /**
     * @param value The interval for recurrence. For a quarterly review, the interval is 3 for type : absoluteMonthly.
     */
    @JvmName("fvlhkrqtibpuaidq")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value Flag to indicate whether the reviewer is required to pass justification when recording a decision.
     */
    @JvmName("endvyqdphcwldpdb")
    public suspend fun justificationRequiredOnApproval(`value`: Output<Boolean>) {
        this.justificationRequiredOnApproval = value
    }

    /**
     * @param value Flag to indicate whether sending mails to reviewers and the review creator is enabled.
     */
    @JvmName("lnuickedqlurbuyq")
    public suspend fun mailNotificationsEnabled(`value`: Output<Boolean>) {
        this.mailNotificationsEnabled = value
    }

    /**
     * @param value The number of times to repeat the access review. Required and must be positive if type is numbered.
     */
    @JvmName("fbjscdunxwbxqicj")
    public suspend fun numberOfOccurrences(`value`: Output<Int>) {
        this.numberOfOccurrences = value
    }

    /**
     * @param value Recommendations for access reviews are calculated by looking back at 30 days of data(w.r.t the start date of the review) by default. However, in some scenarios, customers want to change how far back to look at and want to configure 60 days, 90 days, etc. instead. This setting allows customers to configure this duration. The value should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds))
     */
    @JvmName("lxfcaljatwfouuwm")
    public suspend fun recommendationLookBackDuration(`value`: Output<String>) {
        this.recommendationLookBackDuration = value
    }

    /**
     * @param value Flag to indicate whether showing recommendations to reviewers is enabled.
     */
    @JvmName("aeinpevohikhhoum")
    public suspend fun recommendationsEnabled(`value`: Output<Boolean>) {
        this.recommendationsEnabled = value
    }

    /**
     * @param value Flag to indicate whether sending reminder emails to reviewers are enabled.
     */
    @JvmName("iwviqbnmhjdpqsdv")
    public suspend fun reminderNotificationsEnabled(`value`: Output<Boolean>) {
        this.reminderNotificationsEnabled = value
    }

    /**
     * @param value This is the collection of reviewers.
     */
    @JvmName("oqiklwuccaulombv")
    public suspend fun reviewers(`value`: Output<List<AccessReviewReviewerArgs>>) {
        this.reviewers = value
    }

    @JvmName("nebmmrkssnuvhryc")
    public suspend fun reviewers(vararg values: Output<AccessReviewReviewerArgs>) {
        this.reviewers = Output.all(values.asList())
    }

    /**
     * @param values This is the collection of reviewers.
     */
    @JvmName("yiruupurvgckvfse")
    public suspend fun reviewers(values: List<Output<AccessReviewReviewerArgs>>) {
        this.reviewers = Output.all(values)
    }

    /**
     * @param value The id of the access review schedule definition.
     */
    @JvmName("xvisahjdkontpejc")
    public suspend fun scheduleDefinitionId(`value`: Output<String>) {
        this.scheduleDefinitionId = value
    }

    /**
     * @param value The scope of the resource.
     */
    @JvmName("byhelnqxxysfgdbr")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The DateTime when the review is scheduled to be start. This could be a date in the future. Required on create.
     */
    @JvmName("hlfomsljenfyvrbq")
    public suspend fun startDate(`value`: Output<String>) {
        this.startDate = value
    }

    /**
     * @param value The recurrence range type. The possible values are: endDate, noEnd, numbered.
     */
    @JvmName("iacbcyvbitnhmblc")
    public suspend fun type(`value`: Output<Either<String, AccessReviewRecurrenceRangeType>>) {
        this.type = value
    }

    /**
     * @param value Flag to indicate whether auto-apply capability, to automatically change the target object access resource, is enabled. If not enabled, a user must, after the review completes, apply the access review.
     */
    @JvmName("lnncjppynkfthuqp")
    public suspend fun autoApplyDecisionsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoApplyDecisionsEnabled = mapped
    }

    /**
     * @param value This is the collection of backup reviewers.
     */
    @JvmName("exvyclrrapfutfjt")
    public suspend fun backupReviewers(`value`: List<AccessReviewReviewerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupReviewers = mapped
    }

    /**
     * @param argument This is the collection of backup reviewers.
     */
    @JvmName("lrjtimbqxgyfsonw")
    public suspend
    fun backupReviewers(argument: List<suspend AccessReviewReviewerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AccessReviewReviewerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.backupReviewers = mapped
    }

    /**
     * @param argument This is the collection of backup reviewers.
     */
    @JvmName("rhtaoiqegcjfqmeb")
    public suspend fun backupReviewers(
        vararg
        argument: suspend AccessReviewReviewerArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AccessReviewReviewerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.backupReviewers = mapped
    }

    /**
     * @param argument This is the collection of backup reviewers.
     */
    @JvmName("aosasofeetstoyux")
    public suspend fun backupReviewers(argument: suspend AccessReviewReviewerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AccessReviewReviewerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.backupReviewers = mapped
    }

    /**
     * @param values This is the collection of backup reviewers.
     */
    @JvmName("cntdpxucwmjsrqoa")
    public suspend fun backupReviewers(vararg values: AccessReviewReviewerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupReviewers = mapped
    }

    /**
     * @param value This specifies the behavior for the autoReview feature when an access review completes.
     */
    @JvmName("tcqrihhokmlgkjqw")
    public suspend fun defaultDecision(`value`: Either<String, DefaultDecisionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultDecision = mapped
    }

    /**
     * @param value This specifies the behavior for the autoReview feature when an access review completes.
     */
    @JvmName("oovtxxmmtuxdhcsn")
    public fun defaultDecision(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DefaultDecisionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultDecision = mapped
    }

    /**
     * @param value This specifies the behavior for the autoReview feature when an access review completes.
     */
    @JvmName("ltuieledbssguaag")
    public fun defaultDecision(`value`: DefaultDecisionType) {
        val toBeMapped = Either.ofRight<String, DefaultDecisionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultDecision = mapped
    }

    /**
     * @param value Flag to indicate whether reviewers are required to provide a justification when reviewing access.
     */
    @JvmName("ppbxcesywdolnveq")
    public suspend fun defaultDecisionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultDecisionEnabled = mapped
    }

    /**
     * @param value The description provided by the access review creator and visible to admins.
     */
    @JvmName("rkgmkcakipgorrhh")
    public suspend fun descriptionForAdmins(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.descriptionForAdmins = mapped
    }

    /**
     * @param value The description provided by the access review creator to be shown to reviewers.
     */
    @JvmName("sacplcgdlqnmjfch")
    public suspend fun descriptionForReviewers(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.descriptionForReviewers = mapped
    }

    /**
     * @param value The display name for the schedule definition.
     */
    @JvmName("homfypintngonddl")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The DateTime when the review is scheduled to end. Required if type is endDate
     */
    @JvmName("rjdgmmkfkggpxilt")
    public suspend fun endDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endDate = mapped
    }

    /**
     * @param value This is used to indicate the resource id(s) to exclude
     */
    @JvmName("iprauckschjprpsq")
    public suspend fun excludeResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeResourceId = mapped
    }

    /**
     * @param value This is used to indicate the role definition id(s) to exclude
     */
    @JvmName("syvmolltwusdijyy")
    public suspend fun excludeRoleDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeRoleDefinitionId = mapped
    }

    /**
     * @param value Flag to indicate whether to expand nested memberships or not.
     */
    @JvmName("afboqbgpsomtxfmk")
    public suspend fun expandNestedMemberships(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expandNestedMemberships = mapped
    }

    /**
     * @param value Duration users are inactive for. The value should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds))
     */
    @JvmName("lumaawshyyahwymw")
    public suspend fun inactiveDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inactiveDuration = mapped
    }

    /**
     * @param value Flag to indicate whether to expand nested memberships or not.
     */
    @JvmName("gubomgkdtkrwcufi")
    public suspend fun includeAccessBelowResource(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeAccessBelowResource = mapped
    }

    /**
     * @param value Flag to indicate whether to expand nested memberships or not.
     */
    @JvmName("ayjjwjeqddwhhbsc")
    public suspend fun includeInheritedAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeInheritedAccess = mapped
    }

    /**
     * @param value The duration in days for an instance.
     */
    @JvmName("xrrxisyildmrxfjb")
    public suspend fun instanceDurationInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceDurationInDays = mapped
    }

    /**
     * @param value This is the collection of instances returned when one does an expand on it.
     */
    @JvmName("kjhwnxmblesbvbwq")
    public suspend fun instances(`value`: List<AccessReviewInstanceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instances = mapped
    }

    /**
     * @param argument This is the collection of instances returned when one does an expand on it.
     */
    @JvmName("exltnopocvxfvsrj")
    public suspend fun instances(argument: List<suspend AccessReviewInstanceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AccessReviewInstanceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.instances = mapped
    }

    /**
     * @param argument This is the collection of instances returned when one does an expand on it.
     */
    @JvmName("wcmgyxvdqquujryc")
    public suspend fun instances(
        vararg
        argument: suspend AccessReviewInstanceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AccessReviewInstanceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.instances = mapped
    }

    /**
     * @param argument This is the collection of instances returned when one does an expand on it.
     */
    @JvmName("jtxlyhvjqptlwmlt")
    public suspend fun instances(argument: suspend AccessReviewInstanceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AccessReviewInstanceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.instances = mapped
    }

    /**
     * @param values This is the collection of instances returned when one does an expand on it.
     */
    @JvmName("fcvrsjsrtvyqerni")
    public suspend fun instances(vararg values: AccessReviewInstanceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instances = mapped
    }

    /**
     * @param value The interval for recurrence. For a quarterly review, the interval is 3 for type : absoluteMonthly.
     */
    @JvmName("saxbsmyhtynkaidq")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value Flag to indicate whether the reviewer is required to pass justification when recording a decision.
     */
    @JvmName("eabckrjtheqvhwcp")
    public suspend fun justificationRequiredOnApproval(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.justificationRequiredOnApproval = mapped
    }

    /**
     * @param value Flag to indicate whether sending mails to reviewers and the review creator is enabled.
     */
    @JvmName("xvervaobttjlvswx")
    public suspend fun mailNotificationsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mailNotificationsEnabled = mapped
    }

    /**
     * @param value The number of times to repeat the access review. Required and must be positive if type is numbered.
     */
    @JvmName("kogjabwnrbyvjabo")
    public suspend fun numberOfOccurrences(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numberOfOccurrences = mapped
    }

    /**
     * @param value Recommendations for access reviews are calculated by looking back at 30 days of data(w.r.t the start date of the review) by default. However, in some scenarios, customers want to change how far back to look at and want to configure 60 days, 90 days, etc. instead. This setting allows customers to configure this duration. The value should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds))
     */
    @JvmName("bivbcjdxfipujfxn")
    public suspend fun recommendationLookBackDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recommendationLookBackDuration = mapped
    }

    /**
     * @param value Flag to indicate whether showing recommendations to reviewers is enabled.
     */
    @JvmName("cpixxydbuymlbvfx")
    public suspend fun recommendationsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recommendationsEnabled = mapped
    }

    /**
     * @param value Flag to indicate whether sending reminder emails to reviewers are enabled.
     */
    @JvmName("qhpivrdruobxdnia")
    public suspend fun reminderNotificationsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reminderNotificationsEnabled = mapped
    }

    /**
     * @param value This is the collection of reviewers.
     */
    @JvmName("fuveskwkmogktndn")
    public suspend fun reviewers(`value`: List<AccessReviewReviewerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reviewers = mapped
    }

    /**
     * @param argument This is the collection of reviewers.
     */
    @JvmName("pgwvrnrprthmilsh")
    public suspend fun reviewers(argument: List<suspend AccessReviewReviewerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AccessReviewReviewerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.reviewers = mapped
    }

    /**
     * @param argument This is the collection of reviewers.
     */
    @JvmName("kdmdiaqqqcmnytuf")
    public suspend fun reviewers(
        vararg
        argument: suspend AccessReviewReviewerArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AccessReviewReviewerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.reviewers = mapped
    }

    /**
     * @param argument This is the collection of reviewers.
     */
    @JvmName("xthltdmcsoceabwn")
    public suspend fun reviewers(argument: suspend AccessReviewReviewerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AccessReviewReviewerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.reviewers = mapped
    }

    /**
     * @param values This is the collection of reviewers.
     */
    @JvmName("aeyakhugbijaybdm")
    public suspend fun reviewers(vararg values: AccessReviewReviewerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reviewers = mapped
    }

    /**
     * @param value The id of the access review schedule definition.
     */
    @JvmName("gdyoopmqmxghbuft")
    public suspend fun scheduleDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleDefinitionId = mapped
    }

    /**
     * @param value The scope of the resource.
     */
    @JvmName("qmkkprvcaassamnb")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The DateTime when the review is scheduled to be start. This could be a date in the future. Required on create.
     */
    @JvmName("kygrfxhmpqiwgwyo")
    public suspend fun startDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startDate = mapped
    }

    /**
     * @param value The recurrence range type. The possible values are: endDate, noEnd, numbered.
     */
    @JvmName("dohmpnbttlaeuvhq")
    public suspend fun type(`value`: Either<String, AccessReviewRecurrenceRangeType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The recurrence range type. The possible values are: endDate, noEnd, numbered.
     */
    @JvmName("tdvqsnctfsjhsutr")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AccessReviewRecurrenceRangeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The recurrence range type. The possible values are: endDate, noEnd, numbered.
     */
    @JvmName("nkumvgikplrmcehf")
    public fun type(`value`: AccessReviewRecurrenceRangeType) {
        val toBeMapped = Either.ofRight<String, AccessReviewRecurrenceRangeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ScopeAccessReviewScheduleDefinitionByIdArgs =
        ScopeAccessReviewScheduleDefinitionByIdArgs(
            autoApplyDecisionsEnabled = autoApplyDecisionsEnabled,
            backupReviewers = backupReviewers,
            defaultDecision = defaultDecision,
            defaultDecisionEnabled = defaultDecisionEnabled,
            descriptionForAdmins = descriptionForAdmins,
            descriptionForReviewers = descriptionForReviewers,
            displayName = displayName,
            endDate = endDate,
            excludeResourceId = excludeResourceId,
            excludeRoleDefinitionId = excludeRoleDefinitionId,
            expandNestedMemberships = expandNestedMemberships,
            inactiveDuration = inactiveDuration,
            includeAccessBelowResource = includeAccessBelowResource,
            includeInheritedAccess = includeInheritedAccess,
            instanceDurationInDays = instanceDurationInDays,
            instances = instances,
            interval = interval,
            justificationRequiredOnApproval = justificationRequiredOnApproval,
            mailNotificationsEnabled = mailNotificationsEnabled,
            numberOfOccurrences = numberOfOccurrences,
            recommendationLookBackDuration = recommendationLookBackDuration,
            recommendationsEnabled = recommendationsEnabled,
            reminderNotificationsEnabled = reminderNotificationsEnabled,
            reviewers = reviewers,
            scheduleDefinitionId = scheduleDefinitionId,
            scope = scope,
            startDate = startDate,
            type = type,
        )
}
