@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.kotlin.outputs.PolicyVariableColumnResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.authorization.kotlin.outputs.PolicyVariableColumnResponse.Companion.toKotlin as policyVariableColumnResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Variable].
 */
@PulumiTagMarker
public class VariableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VariableArgs = VariableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VariableArgsBuilder.() -> Unit) {
        val builder = VariableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Variable {
        val builtJavaResource = com.pulumi.azurenative.authorization.Variable(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Variable(builtJavaResource)
    }
}

/**
 * The variable.
 * Azure REST API version: 2022-08-01-preview.
 * ## Example Usage
 * ### Create or update a variable
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var variable = new AzureNative.Authorization.Variable("variable", new()
 *     {
 *         Columns = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.PolicyVariableColumnArgs
 *             {
 *                 ColumnName = "TestColumn",
 *             },
 *         },
 *         VariableName = "DemoTestVariable",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewVariable(ctx, "variable", &authorization.VariableArgs{
 * 			Columns: []authorization.PolicyVariableColumnArgs{
 * 				{
 * 					ColumnName: pulumi.String("TestColumn"),
 * 				},
 * 			},
 * 			VariableName: pulumi.String("DemoTestVariable"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.Variable;
 * import com.pulumi.azurenative.authorization.VariableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var variable = new Variable("variable", VariableArgs.builder()
 *             .columns(Map.of("columnName", "TestColumn"))
 *             .variableName("DemoTestVariable")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:Variable DemoTestVariable /subscriptions/{subscriptionId}/providers/Microsoft.Authorization/variables/{variableName}
 * ```
 */
public class Variable internal constructor(
    override val javaResource: com.pulumi.azurenative.authorization.Variable,
) : KotlinCustomResource(javaResource, VariableMapper) {
    /**
     * Variable column definitions.
     */
    public val columns: Output<List<PolicyVariableColumnResponse>>
        get() = javaResource.columns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    policyVariableColumnResponseToKotlin(args0)
                })
            })
        })

    /**
     * The name of the variable.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource (Microsoft.Authorization/variables).
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VariableMapper : ResourceMapper<Variable> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.authorization.Variable::class == javaResource::class

    override fun map(javaResource: Resource): Variable = Variable(
        javaResource as
            com.pulumi.azurenative.authorization.Variable,
    )
}

/**
 * @see [Variable].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Variable].
 */
public suspend fun variable(name: String, block: suspend VariableResourceBuilder.() -> Unit):
    Variable {
    val builder = VariableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Variable].
 * @param name The _unique_ name of the resulting resource.
 */
public fun variable(name: String): Variable {
    val builder = VariableResourceBuilder()
    builder.name(name)
    return builder.build()
}
