@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.AccessReviewReviewerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Descriptor for what needs to be reviewed
 * @property principalId The id of the reviewer(user/servicePrincipal)
 */
public data class AccessReviewReviewerArgs(
    public val principalId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.AccessReviewReviewerArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.AccessReviewReviewerArgs =
        com.pulumi.azurenative.authorization.inputs.AccessReviewReviewerArgs.builder()
            .principalId(principalId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessReviewReviewerArgs].
 */
@PulumiTagMarker
public class AccessReviewReviewerArgsBuilder internal constructor() {
    private var principalId: Output<String>? = null

    /**
     * @param value The id of the reviewer(user/servicePrincipal)
     */
    @JvmName("unhopygcwbnctwsr")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value The id of the reviewer(user/servicePrincipal)
     */
    @JvmName("dugthshyysccsuxh")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    internal fun build(): AccessReviewReviewerArgs = AccessReviewReviewerArgs(
        principalId = principalId,
    )
}
