@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetPolicyDefinitionAtManagementGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managementGroupId The ID of the management group.
 * @property policyDefinitionName The name of the policy definition to get.
 */
public data class GetPolicyDefinitionAtManagementGroupPlainArgs(
    public val managementGroupId: String,
    public val policyDefinitionName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetPolicyDefinitionAtManagementGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.inputs.GetPolicyDefinitionAtManagementGroupPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetPolicyDefinitionAtManagementGroupPlainArgs.builder()
            .managementGroupId(managementGroupId.let({ args0 -> args0 }))
            .policyDefinitionName(policyDefinitionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicyDefinitionAtManagementGroupPlainArgs].
 */
@PulumiTagMarker
public class GetPolicyDefinitionAtManagementGroupPlainArgsBuilder internal constructor() {
    private var managementGroupId: String? = null

    private var policyDefinitionName: String? = null

    /**
     * @param value The ID of the management group.
     */
    @JvmName("rrntkrpxqvuednme")
    public suspend fun managementGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managementGroupId = mapped
    }

    /**
     * @param value The name of the policy definition to get.
     */
    @JvmName("cryujcnxvnkautuj")
    public suspend fun policyDefinitionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyDefinitionName = mapped
    }

    internal fun build(): GetPolicyDefinitionAtManagementGroupPlainArgs =
        GetPolicyDefinitionAtManagementGroupPlainArgs(
            managementGroupId = managementGroupId ?: throw PulumiNullFieldException("managementGroupId"),
            policyDefinitionName = policyDefinitionName ?: throw
                PulumiNullFieldException("policyDefinitionName"),
        )
}
