@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetPolicyDefinitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property policyDefinitionName The name of the policy definition to get.
 */
public data class GetPolicyDefinitionPlainArgs(
    public val policyDefinitionName: String,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetPolicyDefinitionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.GetPolicyDefinitionPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetPolicyDefinitionPlainArgs.builder()
            .policyDefinitionName(policyDefinitionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicyDefinitionPlainArgs].
 */
@PulumiTagMarker
public class GetPolicyDefinitionPlainArgsBuilder internal constructor() {
    private var policyDefinitionName: String? = null

    /**
     * @param value The name of the policy definition to get.
     */
    @JvmName("fmhdclhnjxpcnysg")
    public suspend fun policyDefinitionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyDefinitionName = mapped
    }

    internal fun build(): GetPolicyDefinitionPlainArgs = GetPolicyDefinitionPlainArgs(
        policyDefinitionName = policyDefinitionName ?: throw
            PulumiNullFieldException("policyDefinitionName"),
    )
}
