@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetPolicySetDefinitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property policySetDefinitionName The name of the policy set definition to get.
 */
public data class GetPolicySetDefinitionPlainArgs(
    public val policySetDefinitionName: String,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetPolicySetDefinitionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.GetPolicySetDefinitionPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetPolicySetDefinitionPlainArgs.builder()
            .policySetDefinitionName(policySetDefinitionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicySetDefinitionPlainArgs].
 */
@PulumiTagMarker
public class GetPolicySetDefinitionPlainArgsBuilder internal constructor() {
    private var policySetDefinitionName: String? = null

    /**
     * @param value The name of the policy set definition to get.
     */
    @JvmName("avjlddsphmdfbrfv")
    public suspend fun policySetDefinitionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policySetDefinitionName = mapped
    }

    internal fun build(): GetPolicySetDefinitionPlainArgs = GetPolicySetDefinitionPlainArgs(
        policySetDefinitionName = policySetDefinitionName ?: throw
            PulumiNullFieldException("policySetDefinitionName"),
    )
}
