@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetPolicySetDefinitionVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property policyDefinitionVersion The policy set definition version.  The format is x.y.z where x is the major version number, y is the minor version number, and z is the patch number
 * @property policySetDefinitionName The name of the policy set definition.
 */
public data class GetPolicySetDefinitionVersionPlainArgs(
    public val policyDefinitionVersion: String,
    public val policySetDefinitionName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetPolicySetDefinitionVersionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.inputs.GetPolicySetDefinitionVersionPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetPolicySetDefinitionVersionPlainArgs.builder()
            .policyDefinitionVersion(policyDefinitionVersion.let({ args0 -> args0 }))
            .policySetDefinitionName(policySetDefinitionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicySetDefinitionVersionPlainArgs].
 */
@PulumiTagMarker
public class GetPolicySetDefinitionVersionPlainArgsBuilder internal constructor() {
    private var policyDefinitionVersion: String? = null

    private var policySetDefinitionName: String? = null

    /**
     * @param value The policy set definition version.  The format is x.y.z where x is the major version number, y is the minor version number, and z is the patch number
     */
    @JvmName("wykcvaghallxlbuq")
    public suspend fun policyDefinitionVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyDefinitionVersion = mapped
    }

    /**
     * @param value The name of the policy set definition.
     */
    @JvmName("qdhielslcnumsyty")
    public suspend fun policySetDefinitionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policySetDefinitionName = mapped
    }

    internal fun build(): GetPolicySetDefinitionVersionPlainArgs =
        GetPolicySetDefinitionVersionPlainArgs(
            policyDefinitionVersion = policyDefinitionVersion ?: throw
                PulumiNullFieldException("policyDefinitionVersion"),
            policySetDefinitionName = policySetDefinitionName ?: throw
                PulumiNullFieldException("policySetDefinitionName"),
        )
}
