@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetPrivateLinkAssociationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupId The management group ID.
 * @property plaId The ID of the PLA
 */
public data class GetPrivateLinkAssociationPlainArgs(
    public val groupId: String,
    public val plaId: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetPrivateLinkAssociationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.inputs.GetPrivateLinkAssociationPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetPrivateLinkAssociationPlainArgs.builder()
            .groupId(groupId.let({ args0 -> args0 }))
            .plaId(plaId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateLinkAssociationPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateLinkAssociationPlainArgsBuilder internal constructor() {
    private var groupId: String? = null

    private var plaId: String? = null

    /**
     * @param value The management group ID.
     */
    @JvmName("rfagxwjmvfnbnuba")
    public suspend fun groupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupId = mapped
    }

    /**
     * @param value The ID of the PLA
     */
    @JvmName("wxevvktiavgraxka")
    public suspend fun plaId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.plaId = mapped
    }

    internal fun build(): GetPrivateLinkAssociationPlainArgs = GetPrivateLinkAssociationPlainArgs(
        groupId = groupId ?: throw PulumiNullFieldException("groupId"),
        plaId = plaId ?: throw PulumiNullFieldException("plaId"),
    )
}
