@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.ParameterDefinitionsValueMetadataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * General metadata for the parameter.
 * @property assignPermissions Set to true to have Azure portal create role assignments on the resource ID or resource scope value of this parameter during policy assignment. This property is useful in case you wish to assign permissions outside the assignment scope.
 * @property description The description of the parameter.
 * @property displayName The display name for the parameter.
 * @property strongType Used when assigning the policy definition through the portal. Provides a context aware list of values for the user to choose from.
 */
public data class ParameterDefinitionsValueMetadataArgs(
    public val assignPermissions: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val strongType: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.ParameterDefinitionsValueMetadataArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.inputs.ParameterDefinitionsValueMetadataArgs =
        com.pulumi.azurenative.authorization.inputs.ParameterDefinitionsValueMetadataArgs.builder()
            .assignPermissions(assignPermissions?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .strongType(strongType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ParameterDefinitionsValueMetadataArgs].
 */
@PulumiTagMarker
public class ParameterDefinitionsValueMetadataArgsBuilder internal constructor() {
    private var assignPermissions: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var strongType: Output<String>? = null

    /**
     * @param value Set to true to have Azure portal create role assignments on the resource ID or resource scope value of this parameter during policy assignment. This property is useful in case you wish to assign permissions outside the assignment scope.
     */
    @JvmName("exxnnbxfyncnjsco")
    public suspend fun assignPermissions(`value`: Output<Boolean>) {
        this.assignPermissions = value
    }

    /**
     * @param value The description of the parameter.
     */
    @JvmName("qnucirpeehxprkrr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name for the parameter.
     */
    @JvmName("qmuoflyedqcvjgpo")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Used when assigning the policy definition through the portal. Provides a context aware list of values for the user to choose from.
     */
    @JvmName("caahvldylrwwopfe")
    public suspend fun strongType(`value`: Output<String>) {
        this.strongType = value
    }

    /**
     * @param value Set to true to have Azure portal create role assignments on the resource ID or resource scope value of this parameter during policy assignment. This property is useful in case you wish to assign permissions outside the assignment scope.
     */
    @JvmName("nhgaersjlgeqmdar")
    public suspend fun assignPermissions(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignPermissions = mapped
    }

    /**
     * @param value The description of the parameter.
     */
    @JvmName("gibgwmydhxlanedf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name for the parameter.
     */
    @JvmName("ysrisgpkyxqindkc")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Used when assigning the policy definition through the portal. Provides a context aware list of values for the user to choose from.
     */
    @JvmName("iqqobgutivabyite")
    public suspend fun strongType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.strongType = mapped
    }

    internal fun build(): ParameterDefinitionsValueMetadataArgs =
        ParameterDefinitionsValueMetadataArgs(
            assignPermissions = assignPermissions,
            description = description,
            displayName = displayName,
            strongType = strongType,
        )
}
